/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.compacting;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.compacting.CompressionLadder;
import io.github.mattidragon.extendeddrawers.compacting.CompressionRecipeManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1935;
import net.minecraft.class_2291;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7225;

public class CompressionOverrideLoader
extends class_4309 {
    private static final Gson GSON = new Gson();
    private final CompressionRecipeManager compressionRecipeManager;

    public CompressionOverrideLoader(CompressionRecipeManager compressionRecipeManager) {
        super(GSON, "extended_drawers/compression_overrides");
        this.compressionRecipeManager = compressionRecipeManager;
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        ArrayList<CompressionLadder> overrides = new ArrayList<CompressionLadder>();
        for (Map.Entry<class_2960, JsonElement> overrideEntry : prepared.entrySet()) {
            class_2960 id = overrideEntry.getKey();
            JsonElement json = overrideEntry.getValue();
            try {
                JsonObject values = class_3518.method_15295((JsonElement)json, (String)"compression override");
                LinkedHashMap<ItemVariant, Integer> steps = new LinkedHashMap<ItemVariant, Integer>();
                int currentCompression = 0;
                for (Map.Entry stepEntry : values.entrySet()) {
                    ItemVariant item = this.parseItem((String)stepEntry.getKey());
                    int compressionAmount = class_3518.method_15257((JsonElement)((JsonElement)stepEntry.getValue()), (String)("compression amount for " + (String)stepEntry.getKey()));
                    if (compressionAmount == 0) {
                        throw new JsonParseException("Illegal compression amount for " + (String)stepEntry.getKey() + ": 0");
                    }
                    if (compressionAmount < currentCompression) {
                        throw new JsonParseException("Illegal compression amount for %s: %d, amounts should always rise or stay equal".formatted(stepEntry.getKey(), compressionAmount));
                    }
                    currentCompression = compressionAmount;
                    steps.put(item, compressionAmount);
                }
                if (steps.isEmpty()) continue;
                overrides.add(new CompressionLadder(steps.entrySet().stream().map(entry -> new CompressionLadder.Step((ItemVariant)entry.getKey(), (Integer)entry.getValue())).toList()));
            }
            catch (JsonParseException | IllegalArgumentException e) {
                ExtendedDrawers.LOGGER.error("Parsing error loading compression override {}", (Object)id, (Object)e);
            }
        }
        this.compressionRecipeManager.setOverrides(overrides);
    }

    private ItemVariant parseItem(String data) {
        try {
            StringReader reader = new StringReader(data);
            class_2291.class_7215 result = class_2291.method_41972((class_7225)class_7225.method_42018((class_2378)class_2378.field_11142), (StringReader)reader);
            if (reader.getRemainingLength() != 0) {
                throw new JsonParseException("Failed to parse item, found trailing data: '%s'".formatted(reader.getRemaining()));
            }
            return ItemVariant.of((class_1935)((class_1935)result.comp_628().comp_349()), (class_2487)result.comp_629());
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException("Failed to parse item", (Throwable)e);
        }
    }
}

