/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.storage;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.entity.CompactingDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.compacting.CompressionLadder;
import io.github.mattidragon.extendeddrawers.compacting.CompressionRecipeManager;
import io.github.mattidragon.extendeddrawers.config.CommonConfig;
import io.github.mattidragon.extendeddrawers.item.UpgradeItem;
import io.github.mattidragon.extendeddrawers.misc.ItemUtils;
import io.github.mattidragon.extendeddrawers.storage.DrawerStorage;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompactingDrawerStorage
extends SnapshotParticipant<Snapshot>
implements DrawerStorage {
    private final CompactingDrawerBlockEntity owner;
    private final DrawerStorage.Settings settings;
    private ItemVariant item = ItemVariant.blank();
    private final Slot[] slots = new Slot[]{new Slot(), new Slot(), new Slot()};
    private boolean updatePending;
    private long amount;

    public CompactingDrawerStorage(CompactingDrawerBlockEntity owner) {
        this.owner = owner;
        this.settings = new DrawerStorage.Settings();
    }

    @Override
    public boolean changeUpgrade(@Nullable UpgradeItem newUpgrade, class_1937 world, class_2338 pos, class_2350 side, @Nullable class_1657 player) {
        UpgradeItem oldUpgrade = this.settings.upgrade;
        this.settings.upgrade = newUpgrade;
        if (this.amount > this.getCapacity() && ((CommonConfig)CommonConfig.HANDLE.get()).blockUpgradeRemovalsWithOverflow()) {
            this.settings.upgrade = oldUpgrade;
            if (player != null) {
                player.method_7353((class_2561)class_2561.method_43471((String)"extended_drawer.drawer.upgrade_fail"), true);
            }
            return false;
        }
        ItemUtils.offerOrDrop(world, pos, side, player, new class_1799((class_1935)oldUpgrade));
        this.dumpExcess(world, pos, side, player);
        return true;
    }

    @Override
    public void dumpExcess(class_1937 world, class_2338 pos, @Nullable class_2350 side, @Nullable class_1657 player) {
        if (this.amount > this.getCapacity()) {
            Slot[] slots = this.getSlots();
            for (int i = slots.length - 1; i >= 0; --i) {
                Slot slot = slots[i];
                if (slot.isBlocked()) continue;
                long toDrop = slot.getAmount() - slot.getCapacity();
                ItemUtils.offerOrDropStacks(world, pos, side, player, slot.getResource(), toDrop);
                this.amount -= toDrop * (long)slot.compression;
            }
        }
        this.update();
    }

    @Override
    public CompactingDrawerBlockEntity getOwner() {
        return this.owner;
    }

    public long getCapacity() {
        CommonConfig config = (CommonConfig)CommonConfig.HANDLE.get();
        long capacity = config.compactingCapacity();
        if (config.stackSizeAffectsCapacity()) {
            capacity = (long)((double)capacity / (64.0 / (double)this.item.getItem().method_7882()));
        }
        if (this.settings.upgrade != null) {
            capacity = this.settings.upgrade.modifier.applyAsLong(capacity);
        }
        return capacity *= (long)this.getTotalCompression();
    }

    @Override
    public DrawerStorage.Settings settings() {
        return this.settings;
    }

    @Override
    public boolean isBlank() {
        return this.item.isBlank();
    }

    protected Snapshot createSnapshot() {
        return new Snapshot(this.item, this.amount);
    }

    protected void readSnapshot(Snapshot snapshot) {
        this.item = snapshot.item;
        this.amount = snapshot.amount;
        this.updatePending = true;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        long inserted = 0L;
        for (Slot slot2 : this.getActiveSlots()) {
            if ((inserted += slot2.insert(resource, maxAmount - inserted, transaction)) == maxAmount) break;
        }
        if (Arrays.stream(this.getActiveSlots()).anyMatch(slot -> slot.item.equals(resource)) && this.settings.voiding) {
            return maxAmount;
        }
        return inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long extraced = 0L;
        for (Slot slot : this.getActiveSlots()) {
            if ((extraced += slot.extract(resource, maxAmount - extraced, transaction)) == maxAmount) break;
        }
        return extraced;
    }

    @NotNull
    public Iterator<StorageView<ItemVariant>> iterator() {
        return new StorageIterator();
    }

    public Slot getSlot(int index) {
        return this.getSlots()[index];
    }

    @Override
    public void setLocked(boolean locked) {
        if (!locked && this.amount == 0L) {
            this.clear();
        }
        DrawerStorage.super.setLocked(locked);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        DrawerStorage.super.readNbt(nbt);
        this.item = ItemVariant.fromNbt((class_2487)nbt.method_10562("item"));
        this.amount = nbt.method_10537("amount");
        if (this.item.isBlank()) {
            this.amount = 0L;
        }
        this.updatePending = true;
    }

    @Override
    public void writeNbt(class_2487 nbt) {
        DrawerStorage.super.writeNbt(nbt);
        nbt.method_10566("item", (class_2520)this.item.toNbt());
        nbt.method_10544("amount", this.amount);
    }

    public Slot[] getActiveSlots() {
        int count = this.getActiveSlotCount();
        Slot[] result = new Slot[count];
        System.arraycopy(this.getSlots(), 0, result, 0, count);
        return result;
    }

    public int getActiveSlotCount() {
        int size;
        Slot[] slots = this.getSlots();
        for (size = 0; size < slots.length && !slots[size].blocked; ++size) {
        }
        return size;
    }

    public Slot[] getSlots() {
        if (this.updatePending) {
            this.updateSlots();
        }
        return this.slots;
    }

    private int getTotalCompression() {
        Slot[] slots = this.getActiveSlots();
        if (slots.length == 0) {
            return 1;
        }
        return slots[slots.length - 1].compression;
    }

    private void clear() {
        this.item = ItemVariant.blank();
        this.settings.sortingDirty = true;
        for (Slot slot : this.slots) {
            slot.reset(false);
        }
        this.updatePending = false;
    }

    private void updateSlots() {
        for (Slot slot2 : this.slots) {
            slot2.reset(true);
        }
        CompressionLadder ladder = this.owner.method_10997() == null ? new CompressionLadder(List.of(new CompressionLadder.Step(this.item, 1))) : CompressionRecipeManager.of(this.owner.method_10997().method_8433()).getLadder(this.item, this.owner.method_10997());
        int ladderSize = ladder.steps().size();
        int initialPosition = ladder.getPosition(this.item);
        if (initialPosition == -1) {
            throw new IllegalStateException("Item is not on it's own recipe ladder. Did we lookup mid-reload?");
        }
        int[] positions = CompactingDrawerStorage.chooseLadderPositions(ladderSize, initialPosition);
        int globalCompression = ladder.steps().get(positions[0]).size();
        for (int i = 0; i < positions.length; ++i) {
            int position = positions[i];
            CompressionLadder.Step step = ladder.steps().get(position);
            this.slots[i].compression = step.size() / globalCompression;
            this.slots[i].item = step.item();
            this.slots[i].blocked = false;
        }
        Slot initalSlot = Stream.of(this.slots).filter(slot -> slot.item.equals(this.item)).findFirst().orElseThrow();
        this.item = this.slots[0].item;
        this.amount *= (long)initalSlot.compression;
        this.updatePending = false;
    }

    private static int[] chooseLadderPositions(int size, int start) {
        if (size == 1) {
            return new int[]{0};
        }
        if (size == 2) {
            return new int[]{0, 1};
        }
        if (start == size - 1) {
            return new int[]{start - 2, start - 1, start};
        }
        if (start == size - 2) {
            return new int[]{start - 1, start, start + 1};
        }
        return new int[]{start, start + 1, start + 2};
    }

    protected void onFinalCommit() {
        this.update();
    }

    public long getAmount() {
        return this.amount;
    }

    public class Slot
    implements SingleSlotStorage<ItemVariant> {
        private int compression;
        private ItemVariant item;
        private boolean blocked;

        public Slot() {
            this.reset(false);
        }

        private void reset(boolean blocked) {
            this.compression = 1;
            this.item = ItemVariant.blank();
            this.blocked = blocked;
        }

        public long insert(ItemVariant item, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)item, (long)maxAmount);
            if (this.blocked) {
                return 0L;
            }
            if (!this.item.equals(item) && !this.item.isBlank()) {
                return 0L;
            }
            if (!((CommonConfig)CommonConfig.HANDLE.get()).allowRecursion() && !item.getItem().method_31568()) {
                return 0L;
            }
            if (this.item.isBlank() && CompactingDrawerStorage.this.settings.locked && !CompactingDrawerStorage.this.settings.lockOverridden) {
                return 0L;
            }
            if (this.item.isBlank()) {
                CompactingDrawerStorage.this.updateSnapshots(transaction);
                CompactingDrawerStorage.this.item = item;
                CompactingDrawerStorage.this.updateSlots();
                return CompactingDrawerStorage.this.insert(item, maxAmount, transaction);
            }
            long inserted = Math.min(maxAmount, this.getSpace());
            if (inserted > 0L) {
                CompactingDrawerStorage.this.updateSnapshots(transaction);
                CompactingDrawerStorage.this.amount += inserted * (long)this.compression;
            } else if (inserted < 0L) {
                ExtendedDrawers.LOGGER.warn("Somehow inserted negative amount of items ({}) into compacting drawer, aborting. Arguments: item={} maxAmount={}. Status: compression={} item={} capacity={} amount={}", new Object[]{inserted, item, maxAmount, this.compression, this.item, this.getCapacity(), this.getAmount()});
                return 0L;
            }
            return inserted;
        }

        public long extract(ItemVariant item, long maxAmount, TransactionContext transaction) {
            if (this.blocked) {
                return 0L;
            }
            if (!this.item.equals(item)) {
                return 0L;
            }
            long extracted = Math.min(maxAmount, this.getAmount());
            if (extracted > 0L) {
                CompactingDrawerStorage.this.updateSnapshots(transaction);
                CompactingDrawerStorage.this.amount -= extracted * (long)this.compression;
            } else if (extracted < 0L) {
                ExtendedDrawers.LOGGER.warn("Somehow extracted negative amount of items ({}) from compacting drawer, aborting. Arguments: item={} maxAmount={}. Status: compression={} item={} capacity={} amount={}", new Object[]{extracted, item, maxAmount, this.compression, this.item, this.getCapacity(), this.getAmount()});
                return 0L;
            }
            if (CompactingDrawerStorage.this.amount == 0L && !CompactingDrawerStorage.this.settings.locked) {
                CompactingDrawerStorage.this.clear();
            }
            return extracted;
        }

        public boolean supportsInsertion() {
            return !this.blocked;
        }

        public boolean supportsExtraction() {
            return !this.blocked;
        }

        public boolean isResourceBlank() {
            return this.item.isBlank();
        }

        public ItemVariant getResource() {
            return this.item;
        }

        public long getSpace() {
            return (CompactingDrawerStorage.this.getCapacity() - CompactingDrawerStorage.this.amount) / (long)this.compression;
        }

        public long getAmount() {
            return CompactingDrawerStorage.this.amount / (long)this.compression;
        }

        public long getCapacity() {
            return CompactingDrawerStorage.this.getCapacity() / (long)this.compression;
        }

        public CompactingDrawerStorage getStorage() {
            return CompactingDrawerStorage.this;
        }

        public boolean isBlocked() {
            return this.blocked;
        }

        public long getCompression() {
            return this.compression;
        }
    }

    record Snapshot(ItemVariant item, long amount) {
    }

    private class StorageIterator
    implements Iterator<StorageView<ItemVariant>> {
        private int index;

        private StorageIterator() {
            this.index = CompactingDrawerStorage.this.slots.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public Slot next() {
            return CompactingDrawerStorage.this.getSlots()[this.index--];
        }
    }
}

