/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.storage;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.entity.StorageDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.item.UpgradeItem;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface DrawerStorage
extends Comparable<DrawerStorage>,
Storage<ItemVariant> {
    public boolean changeUpgrade(@Nullable UpgradeItem var1, class_1937 var2, class_2338 var3, class_2350 var4, @Nullable class_1657 var5);

    public StorageDrawerBlockEntity getOwner();

    public Settings settings();

    public boolean isBlank();

    default public void update() {
        this.getOwner().onSlotChanged(this.settings().sortingDirty);
        this.settings().sortingDirty = false;
    }

    @Override
    default public int compareTo(@NotNull DrawerStorage other) {
        if (this.isBlank() != other.isBlank()) {
            return this.isBlank() ? 1 : -1;
        }
        if (this.isLocked() != other.isLocked()) {
            return this.isLocked() ? -1 : 1;
        }
        if (this.isVoiding() != other.isVoiding()) {
            return this.isVoiding() ? 1 : -1;
        }
        return 0;
    }

    public void dumpExcess(class_1937 var1, class_2338 var2, @Nullable class_2350 var3, @Nullable class_1657 var4);

    default public void readNbt(class_2487 nbt) {
        UpgradeItem upgrade;
        this.settings().locked = nbt.method_10577("locked");
        this.settings().voiding = nbt.method_10577("voiding");
        this.settings().hidden = nbt.method_10577("hidden");
        Object object = class_2378.field_11142.method_10223(class_2960.method_12829((String)nbt.method_10558("upgrade")));
        this.settings().upgrade = object instanceof UpgradeItem ? (upgrade = (UpgradeItem)((Object)object)) : null;
    }

    default public void writeNbt(class_2487 nbt) {
        nbt.method_10556("locked", this.settings().locked);
        nbt.method_10556("voiding", this.settings().voiding);
        nbt.method_10556("hidden", this.settings().hidden);
        nbt.method_10582("upgrade", class_2378.field_11142.method_10221((Object)this.settings().upgrade).toString());
    }

    default public void overrideLock(TransactionContext transaction) {
        if (this.settings().lockOverridden) {
            ExtendedDrawers.LOGGER.warn("Tried to override drawer lock while already overridden. Unexpected behavior may follow.");
            return;
        }
        transaction.addCloseCallback((transaction1, result) -> {
            this.settings().lockOverridden = false;
        });
        this.settings().lockOverridden = true;
    }

    default public boolean isLocked() {
        return this.settings().locked;
    }

    default public boolean isVoiding() {
        return this.settings().voiding;
    }

    default public boolean isHidden() {
        return this.settings().hidden;
    }

    @Nullable
    default public UpgradeItem getUpgrade() {
        return this.settings().upgrade;
    }

    default public void setLocked(boolean locked) {
        this.settings().sortingDirty = true;
        this.settings().locked = locked;
        this.update();
    }

    default public void setVoiding(boolean voiding) {
        this.settings().sortingDirty = true;
        this.settings().voiding = voiding;
        this.update();
    }

    default public void setHidden(boolean hidden) {
        this.settings().hidden = hidden;
        this.update();
    }

    public static class Settings {
        @Nullable
        UpgradeItem upgrade = null;
        boolean locked = false;
        boolean lockOverridden = false;
        boolean hidden = false;
        boolean voiding = false;
        boolean sortingDirty = false;
    }
}

