/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.config;

import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import terrails.healthoverlay.config.ConfigOption;
import terrails.healthoverlay.heart.HeartPiece;
import terrails.healthoverlay.utilities.Vec2i;

public class Configuration {
    public static final Configuration COMMON = new Configuration();
    public static final Health HEALTH = new Health();
    public static final Absorption ABSORPTION = new Absorption();
    public ConfigOption<HeartDisplayMode> displayMode;

    public static class Health {
        public ConfigOption<String> displayText;
        public ConfigOption<Boolean> vanillaHearts;
        public ConfigOption<List<HeartPiece>> normalColors;
        public ConfigOption<List<HeartPiece>> poisonedColors;
        public ConfigOption<List<HeartPiece>> witheredColors;
        public ConfigOption<List<HeartPiece>> frozenColors;
        public ConfigOption<RelativeTo> posRelativeTo;
        public ConfigOption<Integer> posX;
        public ConfigOption<Integer> posY;
    }

    public static class Absorption {
        public ConfigOption<String> displayText;
        public ConfigOption<Boolean> vanillaHearts;
        public ConfigOption<Boolean> renderOverHealth;
        public ConfigOption<List<HeartPiece>> normalColors;
        public ConfigOption<List<HeartPiece>> poisonedColors;
        public ConfigOption<List<HeartPiece>> witheredColors;
        public ConfigOption<List<HeartPiece>> frozenColors;
        public ConfigOption<RelativeTo> posRelativeTo;
        public ConfigOption<Integer> posX;
        public ConfigOption<Integer> posY;
    }

    public static enum RelativeTo {
        TOP_LEFT,
        TOP_MIDDLE,
        TOP_RIGHT,
        MIDDLE_LEFT,
        MIDDLE,
        MIDDLE_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_MIDDLE,
        BOTTOM_RIGHT;


        public int clampHorizontalCoordinates(int x, int widgetWidth) {
            int winWidth = class_310.method_1551().method_22683().method_4486();
            switch (this) {
                case TOP_LEFT: 
                case MIDDLE_LEFT: 
                case BOTTOM_LEFT: {
                    x = class_3532.method_15340((int)x, (int)0, (int)(winWidth - widgetWidth));
                    break;
                }
                case TOP_MIDDLE: 
                case MIDDLE: 
                case BOTTOM_MIDDLE: {
                    x = class_3532.method_15340((int)x, (int)(-(winWidth / 2)), (int)(winWidth / 2 - widgetWidth));
                    break;
                }
                case TOP_RIGHT: 
                case MIDDLE_RIGHT: 
                case BOTTOM_RIGHT: {
                    x = class_3532.method_15340((int)x, (int)(-winWidth), (int)(-widgetWidth));
                }
            }
            return x;
        }

        public int clampVerticalCoordinates(int y, int widgetHeight) {
            int winHeight = class_310.method_1551().method_22683().method_4502();
            switch (this) {
                case TOP_LEFT: 
                case TOP_MIDDLE: 
                case TOP_RIGHT: {
                    y = class_3532.method_15340((int)y, (int)0, (int)(winHeight - widgetHeight));
                    break;
                }
                case MIDDLE_LEFT: 
                case MIDDLE: 
                case MIDDLE_RIGHT: {
                    y = class_3532.method_15340((int)y, (int)(-(winHeight / 2)), (int)(winHeight / 2 - widgetHeight));
                    break;
                }
                case BOTTOM_LEFT: 
                case BOTTOM_MIDDLE: 
                case BOTTOM_RIGHT: {
                    y = class_3532.method_15340((int)y, (int)(-winHeight), (int)(-widgetHeight));
                }
            }
            return y;
        }

        public Vec2i clampCoordinates(int x, int y, int widgetWidth, int widgetHeight) {
            x = this.clampHorizontalCoordinates(x, widgetWidth);
            y = this.clampVerticalCoordinates(y, widgetHeight);
            return new Vec2i(x, y);
        }

        public Vec2i rootCoordinates() {
            class_1041 window = class_310.method_1551().method_22683();
            int winWidth = window.method_4486();
            int winHeight = window.method_4502();
            int x = 0;
            int y = 0;
            switch (this) {
                case TOP_MIDDLE: 
                case MIDDLE: 
                case BOTTOM_MIDDLE: {
                    x = winWidth / 2;
                    break;
                }
                case TOP_RIGHT: 
                case MIDDLE_RIGHT: 
                case BOTTOM_RIGHT: {
                    x = winWidth;
                }
            }
            switch (this) {
                case MIDDLE_LEFT: 
                case MIDDLE: 
                case MIDDLE_RIGHT: {
                    y = winHeight / 2;
                    break;
                }
                case BOTTOM_LEFT: 
                case BOTTOM_MIDDLE: 
                case BOTTOM_RIGHT: {
                    y = winHeight;
                }
            }
            return new Vec2i(x, y);
        }
    }

    public static enum HeartDisplayMode {
        OFF("off"),
        ALWAYS("always"),
        ON_CHANGE("on_change");

        private final String key;

        private HeartDisplayMode(String key) {
            this.key = key;
        }

        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)("healthoverlay.options.heart_display_mode." + this.key));
        }
    }
}

