/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.config.screen.base;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import terrails.healthoverlay.config.ConfigOption;
import terrails.healthoverlay.config.Configuration;
import terrails.healthoverlay.config.screen.widgets.SelectionCircleWidget;
import terrails.healthoverlay.config.screen.widgets.TinyButton;
import terrails.healthoverlay.utilities.Vec2i;

public abstract class AbstractPlacementScreen
extends class_437 {
    private static final Predicate<String> NUMBER_FILTER = text -> text.matches("-?[0-9]+");
    private final class_437 lastScreen;
    private final SelectionCircleWidget[] selectionCircles = new SelectionCircleWidget[9];
    private class_342 xPos;
    private class_342 yPos;

    public AbstractPlacementScreen(class_437 lastScreen, class_2561 component) {
        super(component);
        this.lastScreen = lastScreen;
    }

    protected void method_25426() {
        int BOX_WIDTH = this.field_22793.method_1727("-ABCDEF");
        Objects.requireNonNull(this.field_22793);
        this.xPos = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 - 80 - BOX_WIDTH, this.field_22790 - 15, BOX_WIDTH, 9 + 2, (class_2561)class_2561.method_43473()));
        this.xPos.method_1890(NUMBER_FILTER);
        this.xPos.method_1863(text -> {
            int value;
            Configuration.RelativeTo relativeTo = this.getRelativeTo();
            int clamped = relativeTo.clampHorizontalCoordinates(value = Integer.parseInt(text), this.getMovableWidth());
            if (clamped != value) {
                this.xPos.method_1852(Integer.toString(clamped));
            }
            int x = relativeTo.rootCoordinates().move(clamped, 0).getX();
            this.setMovableX(x);
        });
        this.setCoordinateX(this.getCoordinateX());
        Objects.requireNonNull(this.field_22793);
        this.yPos = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 - 76, this.field_22790 - 15, BOX_WIDTH, 9 + 2, (class_2561)class_2561.method_43473()));
        this.yPos.method_1890(NUMBER_FILTER);
        this.yPos.method_1863(text -> {
            int value;
            Configuration.RelativeTo relativeTo = this.getRelativeTo();
            int clamped = relativeTo.clampVerticalCoordinates(value = Integer.parseInt(text), this.getMovableHeight());
            if (clamped != value) {
                this.yPos.method_1852(Integer.toString(clamped));
            }
            int y = relativeTo.rootCoordinates().move(0, clamped).getY();
            this.setMovableY(y);
        });
        this.setCoordinateY(this.getCoordinateY());
        this.method_37063((class_364)new TinyButton(27, this.field_22790 - 18, 32, 12, button -> this.loadDefaults()));
        Configuration.RelativeTo relativeTo = this.getRelativeTo();
        this.selectionCircles[0] = (SelectionCircleWidget)this.method_37063((class_364)new SelectionCircleWidget(0, 0, 6, 6, 7, 7, Configuration.RelativeTo.TOP_LEFT, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[1] = (SelectionCircleWidget)this.method_37063((class_364)new SelectionCircleWidget((this.field_22789 - 1) / 2 - 6, 0, 0, 6, 13, 7, Configuration.RelativeTo.TOP_MIDDLE, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[2] = (SelectionCircleWidget)this.method_37063((class_364)new SelectionCircleWidget(this.field_22789 - 7, 0, 0, 6, 7, 7, Configuration.RelativeTo.TOP_RIGHT, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[3] = (SelectionCircleWidget)this.method_37063((class_364)new SelectionCircleWidget(0, (this.field_22790 - 1) / 2 - 6, 6, 0, 7, 13, Configuration.RelativeTo.MIDDLE_LEFT, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[4] = (SelectionCircleWidget)this.method_37063((class_364)new SelectionCircleWidget((this.field_22789 - 1) / 2 - 6, (this.field_22790 - 1) / 2 - 6, 0, 0, 13, 13, Configuration.RelativeTo.MIDDLE, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[5] = (SelectionCircleWidget)this.method_37063((class_364)new SelectionCircleWidget(this.field_22789 - 7, (this.field_22790 - 1) / 2 - 6, 0, 0, 7, 13, Configuration.RelativeTo.MIDDLE_RIGHT, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[6] = (SelectionCircleWidget)this.method_37063((class_364)new SelectionCircleWidget(0, this.field_22790 - 7, 6, 0, 7, 7, Configuration.RelativeTo.BOTTOM_LEFT, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[7] = (SelectionCircleWidget)this.method_37063((class_364)new SelectionCircleWidget((this.field_22789 - 1) / 2 - 6, this.field_22790 - 7, 0, 0, 13, 7, Configuration.RelativeTo.BOTTOM_MIDDLE, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[8] = (SelectionCircleWidget)this.method_37063((class_364)new SelectionCircleWidget(this.field_22789 - 7, this.field_22790 - 7, 0, 0, 7, 7, Configuration.RelativeTo.BOTTOM_RIGHT, relativeTo, this::updateCoordinatesToRelative));
    }

    public void method_25394(@NotNull class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        this.saveValuesToConfig();
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.lastScreen);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 1 && this.haveValuesChanged()) {
            this.setRelativeTo(this.configRelativeTo().get());
            this.setCoordinateX(this.configCoordinateX().get());
            this.setCoordinateY(this.configCoordinateY().get());
            assert (this.field_22787 != null);
            class_1144 sm = this.field_22787.method_1483();
            sm.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public int getCoordinateX() {
        if (this.xPos == null || this.xPos.method_1882().isEmpty()) {
            return this.configCoordinateX().get();
        }
        return Integer.parseInt(this.xPos.method_1882());
    }

    public void setCoordinateX(int x) {
        this.xPos.method_1852(Integer.toString(x));
    }

    public int getCoordinateY() {
        if (this.yPos == null || this.yPos.method_1882().isEmpty()) {
            return this.configCoordinateY().get();
        }
        return Integer.parseInt(this.yPos.method_1882());
    }

    public void setCoordinateY(int y) {
        this.yPos.method_1852(Integer.toString(y));
    }

    public Configuration.RelativeTo getRelativeTo() {
        return Arrays.stream(this.selectionCircles).filter(Objects::nonNull).filter(SelectionCircleWidget::isActivated).map(SelectionCircleWidget::getRelativeTo).findAny().orElse(this.configRelativeTo().get());
    }

    public void setRelativeTo(Configuration.RelativeTo relativeTo) {
        Arrays.stream(this.selectionCircles).filter(Objects::nonNull).forEach(widget -> widget.updateActivated(relativeTo));
    }

    public void updateCoordinatesToRelative(Configuration.RelativeTo relativeTo) {
        int x = this.getCoordinateX();
        int y = this.getCoordinateY();
        Vec2i clamped = relativeTo.clampCoordinates(x, y, this.getMovableWidth(), this.getMovableHeight());
        Vec2i root = relativeTo.rootCoordinates();
        this.setRelativeTo(relativeTo);
        this.setCoordinateX(clamped.getX());
        this.setCoordinateY(clamped.getY());
        this.setMovableX(root.getX() + clamped.getX());
        this.setMovableY(root.getY() + clamped.getY());
    }

    public boolean haveValuesChanged() {
        Configuration.RelativeTo configRelativeTo = this.configRelativeTo().get();
        int configX = this.configCoordinateX().get();
        int configY = this.configCoordinateY().get();
        Configuration.RelativeTo relativeTo = this.getRelativeTo();
        int x = this.getCoordinateX();
        int y = this.getCoordinateY();
        return configRelativeTo != relativeTo || configX != x || configY != y;
    }

    public void saveValuesToConfig() {
        if (this.haveValuesChanged()) {
            this.configRelativeTo().set(this.getRelativeTo());
            this.configCoordinateX().set(this.getCoordinateX());
            this.configCoordinateY().set(this.getCoordinateY());
        }
    }

    public void loadDefaults() {
        Configuration.RelativeTo relativeTo = this.configRelativeTo().getDefault();
        int x = this.configCoordinateX().getDefault();
        int y = this.configCoordinateY().getDefault();
        this.setRelativeTo(relativeTo);
        this.setCoordinateX(x);
        this.setCoordinateY(y);
    }

    public abstract int getMovableWidth();

    public abstract int getMovableHeight();

    public abstract void setMovableX(int var1);

    public abstract void setMovableY(int var1);

    public abstract ConfigOption<Configuration.RelativeTo> configRelativeTo();

    public abstract ConfigOption<Integer> configCoordinateX();

    public abstract ConfigOption<Integer> configCoordinateY();
}

