/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.fabric;

import com.google.common.collect.Lists;
import io.github.fablabsmc.fablabs.api.fiber.v1.FiberId;
import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.StringSerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.EnumConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ListConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigAttribute;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigBranch;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ObjectShare;
import terrails.healthoverlay.Constants;
import terrails.healthoverlay.config.ConfigOption;
import terrails.healthoverlay.config.Configuration;
import terrails.healthoverlay.heart.HeartPiece;

public class HealthOverlay
implements ClientModInitializer {
    public static final JanksonValueSerializer JANKSON_SERIALIZER = new JanksonValueSerializer(false);
    public static final ConfigBranch CONFIG_NODE;
    public static final Path CONFIG_PATH;
    public static final FiberId LIST_MIN_SIZE;
    public static final FiberId LIST_MAX_SIZE;

    public void onInitializeClient() {
        HealthOverlay.setupConfig(true);
        HealthOverlay.setupStaticObjectShare();
    }

    public static void setupObjectShare() {
        ObjectShare objectShare = FabricLoader.getInstance().getObjectShare();
        objectShare.put("healthoverlay:absorptionOverHealth", (Object)Configuration.ABSORPTION.renderOverHealth.get());
    }

    public static void setupStaticObjectShare() {
        ObjectShare objectShare = FabricLoader.getInstance().getObjectShare();
        objectShare.put("healthoverlay:forceHardcoreHearts", (Object)false);
    }

    public static void setupConfig(boolean deserialize) {
        try {
            while (deserialize) {
                if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    try {
                        FiberSerialization.deserialize((ConfigTree)CONFIG_NODE, (InputStream)Files.newInputStream(CONFIG_PATH, new OpenOption[0]), (ValueSerializer)JANKSON_SERIALIZER);
                        break;
                    }
                    catch (ValueDeserializationException e) {
                        Constants.LOGGER.error("Found a syntax error in '{}'.", (Object)CONFIG_PATH.toString());
                        e.printStackTrace();
                        String deformedFile = "healthoverlay-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss")) + ".json5";
                        Files.move(CONFIG_PATH, FabricLoader.getInstance().getConfigDir().resolve(deformedFile), new CopyOption[0]);
                        Constants.LOGGER.info("Deformed config file renamed to '{}'.", (Object)deformedFile);
                        continue;
                    }
                }
                Constants.LOGGER.info("Creating config file at '{}'.", (Object)CONFIG_PATH.toString());
                break;
            }
            FiberSerialization.serialize((ConfigTree)CONFIG_NODE, (OutputStream)Files.newOutputStream(CONFIG_PATH, new OpenOption[0]), (ValueSerializer)JANKSON_SERIALIZER);
            HealthOverlay.setupObjectShare();
            Constants.LOGGER.info("Successfully loaded '{}'.", (Object)CONFIG_PATH.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ String lambda$static$35(String defaultValue) {
        return defaultValue;
    }

    private static /* synthetic */ String lambda$static$34(String defaultValue) {
        return defaultValue;
    }

    private static /* synthetic */ List lambda$static$27(List defaultValue) {
        return HeartPiece.getColorsFromConfig(defaultValue, true, true);
    }

    private static /* synthetic */ List lambda$static$24(List defaultValue) {
        return HeartPiece.getColorsFromConfig(defaultValue, true, true);
    }

    private static /* synthetic */ List lambda$static$21(List defaultValue) {
        return HeartPiece.getColorsFromConfig(defaultValue, true, true);
    }

    private static /* synthetic */ List lambda$static$18(List defaultValue) {
        return HeartPiece.getColorsFromConfig(defaultValue, true, false);
    }

    private static /* synthetic */ List lambda$static$11(List defaultValue) {
        return HeartPiece.getColorsFromConfig(defaultValue, false, true);
    }

    private static /* synthetic */ List lambda$static$8(List defaultValue) {
        return HeartPiece.getColorsFromConfig(defaultValue, false, true);
    }

    private static /* synthetic */ List lambda$static$5(List defaultValue) {
        return HeartPiece.getColorsFromConfig(defaultValue, false, true);
    }

    private static /* synthetic */ List lambda$static$2(List defaultValue) {
        return HeartPiece.getColorsFromConfig(defaultValue, false, false);
    }

    static {
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("healthoverlay.json5");
        LIST_MIN_SIZE = new FiberId("healthoverlay", "list_min_size");
        LIST_MAX_SIZE = new FiberId("healthoverlay", "list_max_size");
        ListConfigType COLOR = ConfigTypes.makeList((ConfigType)ConfigTypes.STRING.withType(new StringSerializableType(7, 7, Pattern.compile("^#[0-9a-fA-F]{6}+$"))));
        EnumConfigType HEART_DISPLAY_MODE = ConfigTypes.makeEnum(Configuration.HeartDisplayMode.class);
        EnumConfigType RELATIVE_TO = ConfigTypes.makeEnum(Configuration.RelativeTo.class);
        ConfigTreeBuilder builder = ConfigTree.builder();
        ConfigAttribute listMinSizeAttribute = ConfigAttribute.create((FiberId)LIST_MIN_SIZE, (ConfigType)ConfigTypes.INTEGER, (Object)1);
        ConfigAttribute listMaxSizeAttribute = ConfigAttribute.create((FiberId)LIST_MAX_SIZE, (ConfigType)ConfigTypes.INTEGER, (Object)2);
        builder = builder.fork("health");
        PropertyMirror healthVanilla = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        builder.beginValue("health_vanilla", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Show vanilla hearts").finishValue(arg_0 -> ((PropertyMirror)healthVanilla).mirror(arg_0));
        Configuration.HEALTH.vanillaHearts = new ConfigOption<Boolean>(() -> ((PropertyMirror)healthVanilla).getValue(), () -> true, arg_0 -> ((PropertyMirror)healthVanilla).setValue(arg_0));
        PropertyMirror healthColors = PropertyMirror.create((ConfigType)COLOR);
        Object defaultValue = Lists.newArrayList((Object[])new String[]{"#F06E14", "#F5DC23", "#2DB928", "#1EAFBE", "#7346E1", "#FA7DEB", "#EB375A", "#FF8278", "#AAFFFA", "#EBEBFF"});
        builder.beginValue("health_colors", (ConfigType)COLOR.withMinSize(1), defaultValue).withComment("Colors for every 10 hearts (not counting the default red)\nAll values are written as hexadecimal RGB color in '#RRGGBB' format").withAttribute(listMinSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)healthColors).mirror(arg_0));
        Configuration.HEALTH.normalColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)healthColors.getValue(), false, false), () -> HealthOverlay.lambda$static$2((List)defaultValue), value -> healthColors.setValue(HeartPiece.getColorList(value)));
        PropertyMirror healthPoisonColors = PropertyMirror.create((ConfigType)COLOR);
        defaultValue = Lists.newArrayList((Object[])new String[]{"#739B00", "#96CD00"});
        builder.beginValue("health_poison_colors", (ConfigType)COLOR.withMinSize(1).withMaxSize(2), defaultValue).withComment("Two alternating colors when poisoned\nThere can be one color in case vanilla poisoned heart is wanted").withAttribute(listMinSizeAttribute).withAttribute(listMaxSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)healthPoisonColors).mirror(arg_0));
        Configuration.HEALTH.poisonedColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)healthPoisonColors.getValue(), false, true), () -> HealthOverlay.lambda$static$5((List)defaultValue), value -> healthPoisonColors.setValue(HeartPiece.getColorList(value)));
        PropertyMirror healthWitherColors = PropertyMirror.create((ConfigType)COLOR);
        defaultValue = Lists.newArrayList((Object[])new String[]{"#0F0F0F", "#2D2D2D"});
        builder.beginValue("health_wither_colors", (ConfigType)COLOR.withMinSize(1).withMaxSize(2), defaultValue).withComment("Two alternating colors when withered\nThere can be one color in case vanilla withered heart is wanted").withAttribute(listMinSizeAttribute).withAttribute(listMaxSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)healthWitherColors).mirror(arg_0));
        Configuration.HEALTH.witheredColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)healthWitherColors.getValue(), false, true), () -> HealthOverlay.lambda$static$8((List)defaultValue), value -> healthWitherColors.setValue(HeartPiece.getColorList(value)));
        PropertyMirror healthFrozenColors = PropertyMirror.create((ConfigType)COLOR);
        defaultValue = Lists.newArrayList((Object[])new String[]{"#3E70E6", "#873EE6"});
        builder.beginValue("health_frozen_colors", (ConfigType)COLOR.withMinSize(1).withMaxSize(2), defaultValue).withComment("Two alternating colors when freezing\nThere can be one color in case vanilla frozen heart is wanted").withAttribute(listMinSizeAttribute).withAttribute(listMaxSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)healthFrozenColors).mirror(arg_0));
        Configuration.HEALTH.frozenColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)healthFrozenColors.getValue(), false, true), () -> HealthOverlay.lambda$static$11((List)defaultValue), value -> healthFrozenColors.setValue(HeartPiece.getColorList(value)));
        builder = builder.fork("gui");
        PropertyMirror healthRelativeTo = PropertyMirror.create((ConfigType)RELATIVE_TO);
        builder.beginValue("relative_to", (ConfigType)RELATIVE_TO, (Object)Configuration.RelativeTo.BOTTOM_MIDDLE).withComment("A point coordinates should be relative to.\nNOTE: moving towards left or top from a point always requires negative coordinates!\nAllowed Values: TOP_LEFT, TOP_MIDDLE, TOP_RIGHT, MIDDLE_LEFT, MIDDLE, MIDDLE_RIGHT, BOTTOM_LEFT, BOTTOM_MIDDLE, BOTTOM_RIGHT").finishValue(arg_0 -> ((PropertyMirror)healthRelativeTo).mirror(arg_0));
        Configuration.HEALTH.posRelativeTo = new ConfigOption<Configuration.RelativeTo>(() -> ((PropertyMirror)healthRelativeTo).getValue(), () -> Configuration.RelativeTo.BOTTOM_MIDDLE, arg_0 -> ((PropertyMirror)healthRelativeTo).setValue(arg_0));
        PropertyMirror healthX = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        builder.beginValue("x", (ConfigType)ConfigTypes.INTEGER, (Object)-91).finishValue(arg_0 -> ((PropertyMirror)healthX).mirror(arg_0));
        Configuration.HEALTH.posX = new ConfigOption<Integer>(() -> ((PropertyMirror)healthX).getValue(), () -> -91, arg_0 -> ((PropertyMirror)healthX).setValue(arg_0));
        PropertyMirror healthY = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        builder.beginValue("y", (ConfigType)ConfigTypes.INTEGER, (Object)-39).finishValue(arg_0 -> ((PropertyMirror)healthY).mirror(arg_0));
        Configuration.HEALTH.posY = new ConfigOption<Integer>(() -> ((PropertyMirror)healthY).getValue(), () -> -39, arg_0 -> ((PropertyMirror)healthY).setValue(arg_0));
        builder = builder.finishBranch().finishBranch();
        builder = builder.fork("absorption");
        PropertyMirror absorptionVanilla = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        builder.beginValue("absorption_vanilla", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Show vanilla hearts").finishValue(arg_0 -> ((PropertyMirror)absorptionVanilla).mirror(arg_0));
        Configuration.ABSORPTION.vanillaHearts = new ConfigOption<Boolean>(() -> ((PropertyMirror)absorptionVanilla).getValue(), () -> true, arg_0 -> ((PropertyMirror)absorptionVanilla).setValue(arg_0));
        PropertyMirror absorptionColors = PropertyMirror.create((ConfigType)COLOR);
        defaultValue = Lists.newArrayList((Object[])new String[]{"#E1FA9B", "#A0FFAF", "#AAFFFA", "#AACDFF", "#D7B4FF", "#FAA5FF", "#FFB4B4", "#FFAA7D", "#D7F0FF", "#EBFFFA"});
        builder.beginValue("absorption_colors", (ConfigType)COLOR.withMinSize(1), defaultValue).withComment("Colors for every 10 hearts (not counting the default yellow)\nAll values are written as hexadecimal RGB color in '#RRGGBB' format").withAttribute(listMinSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)absorptionColors).mirror(arg_0));
        Configuration.ABSORPTION.normalColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)absorptionColors.getValue(), true, false), () -> HealthOverlay.lambda$static$18((List)defaultValue), value -> absorptionColors.setValue(HeartPiece.getColorList(value)));
        listMinSizeAttribute = ConfigAttribute.create((FiberId)LIST_MIN_SIZE, (ConfigType)ConfigTypes.INTEGER, (Object)2);
        PropertyMirror absorptionPoisonColors = PropertyMirror.create((ConfigType)COLOR);
        defaultValue = Lists.newArrayList((Object[])new String[]{"#BFF230", "#7AA15A"});
        builder.beginValue("absorption_poison_colors", (ConfigType)COLOR.withMinSize(2).withMaxSize(2), defaultValue).withComment("Two alternating colors when poisoned").withAttribute(listMinSizeAttribute).withAttribute(listMaxSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)absorptionPoisonColors).mirror(arg_0));
        Configuration.ABSORPTION.poisonedColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)absorptionPoisonColors.getValue(), true, true), () -> HealthOverlay.lambda$static$21((List)defaultValue), value -> absorptionPoisonColors.setValue(HeartPiece.getColorList(value)));
        PropertyMirror absorptionWitherColors = PropertyMirror.create((ConfigType)COLOR);
        defaultValue = Lists.newArrayList((Object[])new String[]{"#787061", "#73625C"});
        builder.beginValue("absorption_wither_colors", (ConfigType)COLOR.withMinSize(2).withMaxSize(2), defaultValue).withComment("Two alternating colors when withered").withAttribute(listMinSizeAttribute).withAttribute(listMaxSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)absorptionWitherColors).mirror(arg_0));
        Configuration.ABSORPTION.witheredColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)absorptionWitherColors.getValue(), true, true), () -> HealthOverlay.lambda$static$24((List)defaultValue), value -> absorptionWitherColors.setValue(HeartPiece.getColorList(value)));
        PropertyMirror absorptionFrozenColors = PropertyMirror.create((ConfigType)COLOR);
        defaultValue = Lists.newArrayList((Object[])new String[]{"#90D136", "#36D183"});
        builder.beginValue("absorption_frozen_colors", (ConfigType)COLOR.withMinSize(2).withMaxSize(2), defaultValue).withComment("Two alternating colors when freezing").withAttribute(listMinSizeAttribute).withAttribute(listMaxSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)absorptionFrozenColors).mirror(arg_0));
        Configuration.ABSORPTION.frozenColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)absorptionFrozenColors.getValue(), true, true), () -> HealthOverlay.lambda$static$27((List)defaultValue), value -> absorptionFrozenColors.setValue(HeartPiece.getColorList(value)));
        builder = builder.fork("gui");
        PropertyMirror absorptionRelativeTo = PropertyMirror.create((ConfigType)RELATIVE_TO);
        builder.beginValue("relative_to", (ConfigType)RELATIVE_TO, (Object)Configuration.RelativeTo.BOTTOM_MIDDLE).withComment("A point coordinates should be relative to.\nNOTE: moving towards left or top from a point always requires negative coordinates!\nAllowed Values: TOP_LEFT, TOP_MIDDLE, TOP_RIGHT, MIDDLE_LEFT, MIDDLE, MIDDLE_RIGHT, BOTTOM_LEFT, BOTTOM_MIDDLE, BOTTOM_RIGHT").finishValue(arg_0 -> ((PropertyMirror)absorptionRelativeTo).mirror(arg_0));
        Configuration.ABSORPTION.posRelativeTo = new ConfigOption<Configuration.RelativeTo>(() -> ((PropertyMirror)absorptionRelativeTo).getValue(), () -> Configuration.RelativeTo.BOTTOM_MIDDLE, arg_0 -> ((PropertyMirror)absorptionRelativeTo).setValue(arg_0));
        PropertyMirror absorptionX = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        builder.beginValue("x", (ConfigType)ConfigTypes.INTEGER, (Object)-91).finishValue(arg_0 -> ((PropertyMirror)absorptionX).mirror(arg_0));
        Configuration.ABSORPTION.posX = new ConfigOption<Integer>(() -> ((PropertyMirror)absorptionX).getValue(), () -> -91, arg_0 -> ((PropertyMirror)absorptionX).setValue(arg_0));
        PropertyMirror absorptionY = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        builder.beginValue("y", (ConfigType)ConfigTypes.INTEGER, (Object)-49).finishValue(arg_0 -> ((PropertyMirror)absorptionY).mirror(arg_0));
        Configuration.ABSORPTION.posY = new ConfigOption<Integer>(() -> ((PropertyMirror)absorptionY).getValue(), () -> -49, arg_0 -> ((PropertyMirror)absorptionY).setValue(arg_0));
        builder = builder.finishBranch().finishBranch();
        builder = builder.fork("qol");
        PropertyMirror absorptionOverHealth = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        builder.beginValue("absorption_over_health", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Display absorption in the same row as health\nAbsorption hearts start directly after the last health heart.").finishValue(arg_0 -> ((PropertyMirror)absorptionOverHealth).mirror(arg_0));
        Configuration.ABSORPTION.renderOverHealth = new ConfigOption<Boolean>(() -> ((PropertyMirror)absorptionOverHealth).getValue(), () -> false, arg_0 -> ((PropertyMirror)absorptionOverHealth).setValue(arg_0));
        builder = builder.fork("counter");
        PropertyMirror heartDisplayMode = PropertyMirror.create((ConfigType)HEART_DISPLAY_MODE);
        builder.beginValue("display_mode", (ConfigType)HEART_DISPLAY_MODE, (Object)Configuration.HeartDisplayMode.OFF).withComment("Visualizes health/absorption to left of the hearts.\nAllowed Values: OFF, ALWAYS, ON_CHANGE").finishValue(arg_0 -> ((PropertyMirror)heartDisplayMode).mirror(arg_0));
        Configuration.COMMON.displayMode = new ConfigOption<Configuration.HeartDisplayMode>(() -> ((PropertyMirror)heartDisplayMode).getValue(), () -> Configuration.HeartDisplayMode.OFF, arg_0 -> ((PropertyMirror)heartDisplayMode).setValue(arg_0));
        PropertyMirror textHealth = PropertyMirror.create((ConfigType)ConfigTypes.STRING);
        defaultValue = "\u00a74[HEALTH]\u00a77/\u00a72[MAX]";
        builder.beginValue("text_health", (ConfigType)ConfigTypes.STRING, defaultValue).withComment("Text displayed next to health. Minecraft chat color codes are allowed.\nAvailable variables:\n    \"[HEALTH]\": Current health.\n    \"[MAX]\": Max health.\n    \"[HEARTS]\": Current health in hearts.\n    \"[MAX_HEARTS]\": Max health in hearts.\n    \"[ROW]\": Current health row.\n    \"[MAX_ROW]\": Max health row.").finishValue(arg_0 -> ((PropertyMirror)textHealth).mirror(arg_0));
        Configuration.HEALTH.displayText = new ConfigOption<String>(() -> ((PropertyMirror)textHealth).getValue(), () -> HealthOverlay.lambda$static$34((String)defaultValue), arg_0 -> ((PropertyMirror)textHealth).setValue(arg_0));
        PropertyMirror textAbsorption = PropertyMirror.create((ConfigType)ConfigTypes.STRING);
        defaultValue = "\u00a76[ABSORPTION]";
        builder.beginValue("text_absorption", (ConfigType)ConfigTypes.STRING, defaultValue).withComment("Text displayed next to absorption. Minecraft chat color codes are allowed.\nIn case 'absorption_over_health' is true, this text is displayed at the same position as or left of 'text_health'.\nAvailable variables:\n   \"[ABSORPTION]\": Current absorption.\n   \"[HEARTS]\": Current absorption in hearts.\n   \"[ROW]\": Current absorption row.").finishValue(arg_0 -> ((PropertyMirror)textAbsorption).mirror(arg_0));
        Configuration.ABSORPTION.displayText = new ConfigOption<String>(() -> ((PropertyMirror)textAbsorption).getValue(), () -> HealthOverlay.lambda$static$35((String)defaultValue), arg_0 -> ((PropertyMirror)textAbsorption).setValue(arg_0));
        builder = builder.finishBranch().finishBranch();
        CONFIG_NODE = builder.build();
    }
}

