/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.heart;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import terrails.healthoverlay.Constants;
import terrails.healthoverlay.HOExpectPlatform;
import terrails.healthoverlay.config.Configuration;
import terrails.healthoverlay.heart.HeartPiece;
import terrails.healthoverlay.heart.HeartType;
import terrails.healthoverlay.render.RenderUtils;

public class Heart {
    private static final Set<Heart> HEART_CACHE = Sets.newHashSet();
    public static final Heart CONTAINER_FULL = new Heart(true, null, null);
    public static final Heart CONTAINER_HALF = new Heart(false, null, null);
    private final boolean isBackgroundFull;
    private final HeartPiece firstHalf;
    private final HeartPiece secondHalf;

    private Heart(boolean isBackgroundFull, HeartPiece firstHalf, HeartPiece secondHalf) {
        this.isBackgroundFull = isBackgroundFull;
        this.firstHalf = firstHalf;
        this.secondHalf = secondHalf;
    }

    public static Heart full(HeartPiece firstHalf, HeartPiece secondHalf) {
        if (firstHalf == null || secondHalf == null) {
            Constants.LOGGER.error("Something went very wrong with heart creation. HeartPiece cannot be null, returning heart container to prevent crashes...");
            return CONTAINER_FULL;
        }
        Optional<Heart> optional = HEART_CACHE.stream().filter(heart -> heart.isBackgroundFull && Objects.equals(heart.firstHalf, firstHalf) && Objects.equals(heart.secondHalf, secondHalf)).findAny();
        return optional.orElseGet(() -> {
            Heart heart = new Heart(true, firstHalf, secondHalf);
            HEART_CACHE.add(heart);
            return heart;
        });
    }

    public static Heart full(HeartPiece heartPiece) {
        if (heartPiece == null) {
            Constants.LOGGER.error("Something went very wrong with heart creation. HeartPiece cannot be null, returning heart container to prevent crashes...");
            return CONTAINER_FULL;
        }
        Optional<Heart> optional = HEART_CACHE.stream().filter(heart -> heart.isBackgroundFull && Objects.equals(heart.firstHalf, heartPiece) && Objects.equals(heart.secondHalf, heartPiece)).findAny();
        return optional.orElseGet(() -> {
            Heart heart = new Heart(true, heartPiece, heartPiece);
            HEART_CACHE.add(heart);
            return heart;
        });
    }

    public static Heart half(HeartPiece heartPiece, boolean isBackgroundFull) {
        if (heartPiece == null) {
            Constants.LOGGER.error("Something went very wrong with heart creation. HeartPiece cannot be null, returning heart container to prevent crashes...");
            return isBackgroundFull ? CONTAINER_FULL : CONTAINER_HALF;
        }
        Optional<Heart> optional = HEART_CACHE.stream().filter(heart -> heart.isBackgroundFull == isBackgroundFull && Objects.equals(heart.firstHalf, heartPiece) && heart.secondHalf == null).findAny();
        return optional.orElseGet(() -> {
            Heart heart = new Heart(isBackgroundFull, heartPiece, null);
            HEART_CACHE.add(heart);
            return heart;
        });
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            Heart heart = (Heart)obj;
            return this.isBackgroundFull == heart.isBackgroundFull && Objects.equals(this.firstHalf, heart.firstHalf) && Objects.equals(this.secondHalf, heart.secondHalf);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.isBackgroundFull, this.firstHalf, this.secondHalf);
    }

    public void draw(class_4587 poseStack, int xPos, int yPos, boolean blinking, HeartType type) {
        boolean canBlink;
        boolean hardcore = HOExpectPlatform.forcedHardcoreHearts() || class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_28104().method_152();
        boolean bl = canBlink = Configuration.ABSORPTION.renderOverHealth.get() != false || this.firstHalf == null || !this.firstHalf.isAbsorption();
        if (this.isBackgroundFull) {
            RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
            RenderUtils.drawTexture(poseStack, xPos, yPos, 16 + (canBlink && blinking ? 9 : 0), hardcore ? 45 : 0);
        } else {
            RenderSystem.setShaderTexture((int)0, (class_2960)Constants.HALF_HEART_ICONS_LOCATION);
            RenderUtils.drawTexture(poseStack, xPos, yPos, 0, canBlink && blinking ? 9 : 0);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
        }
        if (this.firstHalf != null) {
            if (this.secondHalf == null) {
                this.firstHalf.draw(poseStack, xPos, yPos, blinking, hardcore, type, true);
            } else if (Objects.equals(this.firstHalf, this.secondHalf)) {
                this.firstHalf.draw(poseStack, xPos, yPos, blinking, hardcore, type);
            } else {
                this.firstHalf.draw(poseStack, xPos, yPos, blinking, hardcore, type, true);
                this.secondHalf.draw(poseStack, xPos, yPos, blinking, hardcore, type, false);
            }
        }
    }
}

