/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.heart;

import net.minecraft.class_1294;
import net.minecraft.class_1657;

public enum HeartType {
    NORMAL(4, 0, true),
    POISONED(8, 2, true),
    WITHERED(12, 4, true),
    FROZEN(18, 6, false);

    private final int indexVanilla;
    private final int index;
    private final boolean canBlink;

    private HeartType(int indexVanilla, int index, boolean canBlink) {
        this.indexVanilla = indexVanilla;
        this.index = index;
        this.canBlink = canBlink;
    }

    public int getX(int x, boolean vanilla, boolean absorption, boolean blinking) {
        if (vanilla) {
            x += 16;
            if (absorption) {
                x += 144;
            } else {
                x += this.indexVanilla * 9;
                if (this.canBlink && blinking) {
                    x += 18;
                }
            }
        } else {
            x += this.index * 9;
        }
        return x;
    }

    public static HeartType forPlayer(class_1657 player) {
        if (player.method_6059(class_1294.field_5899)) {
            return POISONED;
        }
        if (player.method_6059(class_1294.field_5920)) {
            return WITHERED;
        }
        if (player.method_32314()) {
            return FROZEN;
        }
        return NORMAL;
    }
}

