/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.util.ItemColor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5251;
import net.minecraft.class_6862;

public class Selectors {
    private static Map<String, class_1814> rarities = new HashMap<String, class_1814>(){
        {
            this.put("common", class_1814.field_8906);
            this.put("uncommon", class_1814.field_8907);
            this.put("rare", class_1814.field_8903);
            this.put("epic", class_1814.field_8904);
        }
    };
    private static Map<String, BiPredicate<class_2520, String>> nbtComparators = new HashMap<String, BiPredicate<class_2520, String>>(){
        {
            this.put("=", (tag, value) -> tag.method_10714().contentEquals((CharSequence)value));
            this.put("!=", (tag, value) -> !tag.method_10714().contentEquals((CharSequence)value));
            this.put(">", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof class_2514) {
                        return ((class_2514)tag).method_10697() > parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
            this.put("<", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof class_2514) {
                        return ((class_2514)tag).method_10697() < parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }
    };

    public static List<SelectorDocumentation> selectorDocumentation() {
        return Arrays.asList(new SelectorDocumentation("Item name", "Use item name for vanilla items or include mod name for modded items.", "minecraft:stick", "iron_ore"), new SelectorDocumentation("Tag", "$ followed by tag name.", "$forge:stone", "$planks"), new SelectorDocumentation("Mod name", "@ followed by mod identifier.", "@spoiledeggs"), new SelectorDocumentation("Rarity", "! followed by item's rarity.  This is ONLY vanilla rarities.", "!uncommon", "!rare", "!epic"), new SelectorDocumentation("Item name color", "# followed by color hex code, the hex code must match exactly.", "#23F632"), new SelectorDocumentation("Display name", "% followed by any text.  Will match any item with this text in its tooltip display name.", "%Netherite", "%[Uncommon]"), new SelectorDocumentation("Tooltip text", "Will match any item with this text anywhere in the tooltip text (besides the name).", "^Legendary"), new SelectorDocumentation("NBT tag", "& followed by tag name and optional comparator (=, >, <, or !=) and value, in the format <tag><comparator><value> or just <tag>.", "&Damage=0", "&Tier>1", "&map!=128", "&Enchantments"));
    }

    public static boolean validateSelector(String value) {
        if (value.startsWith("$")) {
            return class_2960.method_20207((String)value.substring(1));
        }
        if (value.startsWith("@")) {
            return value.substring(1).matches("^[a-z][a-z0-9_-]{1,63}$");
        }
        if (value.startsWith("!")) {
            return rarities.keySet().contains(value.substring(1).toLowerCase());
        }
        if (value.startsWith("#")) {
            return class_5251.method_27719((String)value) != null;
        }
        if (value.startsWith("%") || value.startsWith("^")) {
            return true;
        }
        if (value.startsWith("&")) {
            return true;
        }
        return value == null || value == "" || class_2960.method_20207((String)value);
    }

    public static boolean itemMatches(class_1799 item, String selector) {
        String itemResourceLocation = class_2378.field_11142.method_10221((Object)item.method_7909()).toString();
        if (selector.equals(itemResourceLocation) || selector.equals(itemResourceLocation.replace("minecraft:", ""))) {
            return true;
        }
        if (selector.startsWith("#")) {
            class_5251 entryColor = class_5251.method_27719((String)selector);
            if (entryColor != null && entryColor.equals((Object)ItemColor.getColorForItem(item, class_5251.method_27717((int)0xFFFFFF)))) {
                return true;
            }
        } else if (selector.startsWith("!")) {
            if (item.method_7932() == rarities.get(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("@")) {
            if (itemResourceLocation.startsWith(selector.substring(1) + ":")) {
                return true;
            }
        } else if (selector.startsWith("$")) {
            Optional<class_6862> matchingTag = class_2378.field_11142.method_40273().filter(tagKey -> tagKey.comp_327().equals((Object)new class_2960(selector.substring(1)))).findFirst();
            if (matchingTag.isPresent() && item.method_31573(matchingTag.get())) {
                return true;
            }
        } else if (selector.startsWith("%")) {
            if (item.method_7954().getString().contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("^")) {
            class_310 mc = class_310.method_1551();
            List lines = item.method_7950((class_1657)mc.field_1724, (class_1836)class_1836.class_1837.field_8935);
            Object tooltipText = "";
            for (int n = 1; n < lines.size(); ++n) {
                tooltipText = (String)tooltipText + ((class_2561)lines.get(n)).getString() + "\n";
            }
            if (((String)tooltipText).contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("&")) {
            String tagName = selector.substring(1);
            String tagValue = null;
            BiPredicate<class_2520, String> valueChecker = null;
            for (String comparator : nbtComparators.keySet()) {
                if (!tagName.contains(comparator)) continue;
                valueChecker = nbtComparators.get(comparator);
                String[] components = tagName.split(comparator);
                tagName = components[0];
                if (components.length <= 1) break;
                tagValue = components[1];
                break;
            }
            return Selectors.findMatchingSubtag((class_2520)item.method_7969(), tagName, tagValue, valueChecker);
        }
        return false;
    }

    private static boolean findMatchingSubtag(class_2520 tag, String key, String value, BiPredicate<class_2520, String> valueChecker) {
        if (tag == null) {
            return false;
        }
        if (tag.method_10711() == 10) {
            class_2487 compoundTag = (class_2487)tag;
            if (compoundTag.method_10545(key)) {
                if (value == null && valueChecker == null) {
                    return true;
                }
                return valueChecker.test(compoundTag.method_10580(key), value);
            }
            for (String innerKey : compoundTag.method_10541()) {
                if (compoundTag.method_10540(innerKey) != 9 && compoundTag.method_10540(innerKey) != 10 || !Selectors.findMatchingSubtag(compoundTag.method_10580(innerKey), key, value, valueChecker)) continue;
                return true;
            }
            return false;
        }
        if (tag.method_10711() == 9) {
            class_2499 listTag = (class_2499)tag;
            for (class_2520 innerTag : listTag) {
                if (innerTag.method_10711() != 9 && innerTag.method_10711() != 10 || !Selectors.findMatchingSubtag(innerTag, key, value, valueChecker)) continue;
                return true;
            }
        }
        return false;
    }

    public record SelectorDocumentation(String name, String description, List<String> examples) {
        public SelectorDocumentation(String name, String description, String ... examples) {
            this(name, description, Arrays.asList(examples));
        }
    }
}

