/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.attachment.attached;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.IoAttachmentItem;
import dev.technici4n.moderndynamics.attachment.IoAttachmentType;
import dev.technici4n.moderndynamics.attachment.Setting;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.FluidAttachedIo;
import dev.technici4n.moderndynamics.attachment.attached.ItemAttachedIo;
import dev.technici4n.moderndynamics.attachment.attached.UpgradeContainer;
import dev.technici4n.moderndynamics.attachment.settings.FilterInversionMode;
import dev.technici4n.moderndynamics.attachment.settings.RedstoneMode;
import dev.technici4n.moderndynamics.attachment.upgrade.LoadedUpgrades;
import dev.technici4n.moderndynamics.attachment.upgrade.UpgradeType;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.WrenchHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public abstract class AttachedIo
extends AttachedAttachment {
    public static final int UPGRADE_SLOTS = 4;
    protected final Runnable setChangedCallback;
    private FilterInversionMode filterInversion;
    private RedstoneMode redstoneMode;
    protected final UpgradeContainer upgradeContainer = new UpgradeContainer();

    public AttachedIo(AttachmentItem item, class_2487 configData, Runnable setChangedCallback) {
        super(item, configData);
        this.setChangedCallback = setChangedCallback;
        this.filterInversion = (FilterInversionMode)AttachedIo.readEnum((Enum[])FilterInversionMode.values(), (class_2487)configData, (String)"filterInversion", (Enum)FilterInversionMode.BLACKLIST);
        this.redstoneMode = (RedstoneMode)AttachedIo.readEnum((Enum[])RedstoneMode.values(), (class_2487)configData, (String)"redstoneMode", (Enum)RedstoneMode.IGNORED);
        this.upgradeContainer.readNbt(configData);
    }

    @Override
    public class_2487 writeConfigTag(class_2487 configData) {
        super.writeConfigTag(configData);
        AttachedIo.writeEnum(this.filterInversion, configData, "filterInversion");
        AttachedIo.writeEnum(this.redstoneMode, configData, "redstoneMode");
        this.upgradeContainer.writeNbt(configData);
        return configData;
    }

    public FilterInversionMode getFilterInversion() {
        return this.filterInversion;
    }

    public void setFilterInversion(FilterInversionMode filterInversion) {
        if (filterInversion != this.filterInversion) {
            this.filterInversion = filterInversion;
            this.resetCachedFilter();
        }
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
    }

    public class_1799 getUpgrade(int slot) {
        return (class_1799)this.upgradeContainer.upgrades.get(slot);
    }

    public void setUpgrade(int slot, class_1799 upgrade) {
        this.upgradeContainer.upgrades.set(slot, (Object)upgrade);
        this.onUpgradesChanged();
    }

    public class_1799 removeUpgrade(int slot, int count) {
        return class_1262.method_5430(this.upgradeContainer.upgrades, (int)slot, (int)count);
    }

    public boolean mayPlaceUpgrade(int slot, class_1792 upgrade) {
        if (!this.upgradeContainer.mayPlaceUpgrade(slot, upgrade)) {
            return false;
        }
        UpgradeType type = LoadedUpgrades.getType(upgrade);
        if (type.getAddFilterSlots() > 0) {
            return true;
        }
        if (this instanceof ItemAttachedIo) {
            if (type.isEnableAdvancedBehavior() || type.getAddItemSpeed() > 0) {
                return true;
            }
            if (this.getType() != IoAttachmentType.FILTER && (type.getAddItemCount() > 0 || type.getAddItemTransferFrequency() > 0)) {
                return true;
            }
        }
        return this instanceof FluidAttachedIo && (type.getAddFluidTransfer() > 0 || type.getMultiplyFluidTransfer() > 0);
    }

    public void onUpgradesChanged() {
        this.setChangedCallback.run();
        this.resetCachedFilter();
    }

    public int getFilterSize() {
        return this.upgradeContainer.getFilterSize();
    }

    protected abstract void resetCachedFilter();

    @Override
    public IoAttachmentItem getItem() {
        return (IoAttachmentItem)super.getItem();
    }

    public IoAttachmentType getType() {
        return this.getItem().getType();
    }

    public Set<Setting> getSupportedSettings() {
        return this.getItem().getSupportedSettings();
    }

    public boolean isAdvancedBehaviorAllowed() {
        return this.upgradeContainer.isAdvancedBehaviorAllowed();
    }

    protected static <T extends Enum<T>> T readEnum(T[] enumValues, class_2487 tag, String key, T defaultValue) {
        byte idx = tag.method_10571(key);
        if (!tag.method_10545(key) || idx < 0 || idx >= enumValues.length) {
            return defaultValue;
        }
        return enumValues[idx];
    }

    protected static <T extends Enum<T>> void writeEnum(T enumValue, class_2487 tag, String key) {
        tag.method_10567(key, (byte)enumValue.ordinal());
    }

    public boolean isEnabledViaRedstone(PipeBlockEntity pipe) {
        if (this.getRedstoneMode() == RedstoneMode.IGNORED) {
            return true;
        }
        boolean signal = pipe.method_10997().method_8479(pipe.method_11016());
        if (signal) {
            return this.getRedstoneMode() == RedstoneMode.REQUIRES_HIGH;
        }
        return this.getRedstoneMode() == RedstoneMode.REQUIRES_LOW;
    }

    @Override
    public List<class_1799> getDrops() {
        ArrayList<class_1799> drops = new ArrayList<class_1799>(super.getDrops());
        for (class_1799 upgrade : this.upgradeContainer.upgrades) {
            if (upgrade.method_7960()) continue;
            drops.add(upgrade);
        }
        return drops;
    }

    @Override
    public void onPlaced(class_1657 player) {
        if (WrenchHelper.isWrench(player.method_6079())) {
            this.filterInversion = FilterInversionMode.WHITELIST;
        }
    }
}

