/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.ber;

import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;

@Environment(value=EnvType.CLIENT)
public class FluidPipeRendering {
    private static final float PIPE_W = 0.375f;
    private static final float P0 = 0.0f;
    private static final float P1 = 0.3125f;
    private static final float P2 = 0.5f;
    private static final float P3 = 0.6875f;
    private static final float P4 = 1.0f;
    public static final int FULL_LIGHT = 0xF000F0;
    private static final int DOWN = 1;
    private static final int UP = 2;
    private static final int NORTH = 4;
    private static final int SOUTH = 8;
    private static final int WEST = 16;
    private static final int EAST = 32;

    public static void drawFluidInPipe(PipeBlockEntity pipe, class_4587 ms, class_4597 vcp, FluidVariant fluid, float fill) {
        int conn = pipe.getClientSideConnections();
        class_1937 level = pipe.method_10997();
        class_2338 pos = pipe.method_11016();
        class_4588 vc = vcp.getBuffer(class_1921.method_23583());
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluid);
        if (sprite == null || (double)fill < 1.0E-5) {
            return;
        }
        int color = FluidVariantRendering.getColor((FluidVariant)fluid, (class_1920)level, (class_2338)pos);
        float r = (float)(color >> 16 & 0xFF) / 256.0f;
        float g = (float)(color >> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        Objects.requireNonNull(renderer, "Please install Indium if you are using Sodium!");
        MeshBuilder meshBuilder = renderer.meshBuilder();
        QuadBuilder builder = (direction, x, y, z, X, Y, Z) -> {
            QuadEmitter emitter = renderer.meshBuilder().getEmitter();
            FluidPipeRendering.quad(emitter, direction, x, y, z, X, Y, Z);
            emitter.spriteBake(0, sprite, 4);
            emitter.spriteColor(0, -1, -1, -1, -1);
            vc.method_22919(ms.method_23760(), emitter.toBakedQuad(0, sprite, false), r, g, b, 0xF000F0, class_4608.field_21444);
        };
        float F = fill * 0.375f;
        float E = 0.001f;
        if (FluidPipeRendering.hasConnection(conn, 4)) {
            builder.cube(0.3125f + E, 0.3125f + E, 0.0f, 0.6875f - E, 0.3125f + F - E, 0.3125f + E, 12);
        }
        if (FluidPipeRendering.hasConnection(conn, 8)) {
            builder.cube(0.3125f + E, 0.3125f + E, 0.6875f - E, 0.6875f - E, 0.3125f + F - E, 1.0f, 12);
        }
        if (FluidPipeRendering.hasConnection(conn, 32)) {
            builder.cube(0.6875f - E, 0.3125f + E, 0.3125f + E, 1.0f, 0.3125f + F - E, 0.6875f - E, 48);
        }
        if (FluidPipeRendering.hasConnection(conn, 16)) {
            builder.cube(0.0f, 0.3125f + E, 0.3125f + E, 0.3125f + E, 0.3125f + F - E, 0.6875f - E, 48);
        }
        if (conn == 3) {
            builder.cube(0.5f - F / 2.0f + E, 0.0f, 0.5f - F / 2.0f + E, 0.5f + F / 2.0f - E, 1.0f, 0.5f + F / 2.0f - E, 3);
        } else {
            builder.cube(0.3125f + E, 0.3125f + E, 0.3125f + E, 0.6875f - E, 0.3125f + F - E, 0.6875f - E, conn & 0x3C);
            if (FluidPipeRendering.hasConnection(conn, 2)) {
                builder.cube(0.5f - F / 2.0f + E, 0.3125f + F - E, 0.5f - F / 2.0f + E, 0.5f + F / 2.0f - E, 1.0f, 0.5f + F / 2.0f - E, 3);
            }
            if (FluidPipeRendering.hasConnection(conn, 1)) {
                builder.cube(0.5f - F / 2.0f + E, 0.0f, 0.5f - F / 2.0f + E, 0.5f + F / 2.0f - E, 0.3125f + E, 0.5f + F / 2.0f - E, 3);
            }
        }
    }

    private static boolean hasConnection(int mask, int dir) {
        return (mask & dir) > 0;
    }

    private static void quad(QuadEmitter emitter, class_2350 direction, float x, float y, float z, float X, float Y, float Z) {
        if (direction == class_2350.field_11036) {
            FluidPipeRendering.quad(emitter, class_2350.field_11036, x, 1.0f - Z, X, 1.0f - z, 1.0f - Y);
        } else if (direction == class_2350.field_11033) {
            FluidPipeRendering.quad(emitter, class_2350.field_11033, x, z, X, Z, y);
        } else if (direction == class_2350.field_11043) {
            FluidPipeRendering.quad(emitter, class_2350.field_11043, 1.0f - X, y, 1.0f - x, Y, z);
        } else if (direction == class_2350.field_11034) {
            FluidPipeRendering.quad(emitter, class_2350.field_11034, 1.0f - Z, y, 1.0f - z, Y, 1.0f - X);
        } else if (direction == class_2350.field_11035) {
            FluidPipeRendering.quad(emitter, class_2350.field_11035, x, y, X, Y, 1.0f - Z);
        } else {
            FluidPipeRendering.quad(emitter, class_2350.field_11039, z, y, Z, Y, x);
        }
    }

    protected static void quad(QuadEmitter emitter, class_2350 direction, float left, float bottom, float right, float top, float depth) {
        emitter.square(direction, left, bottom, right, top, depth);
    }

    @Environment(value=EnvType.CLIENT)
    private static interface QuadBuilder {
        public void build(class_2350 var1, float var2, float var3, float var4, float var5, float var6, float var7);

        default public void cube(float x, float y, float z, float X, float Y, float Z, int excludedMask) {
            int mask = 0x3F ^ excludedMask;
            if ((mask & 1) > 0) {
                this.build(class_2350.field_11033, x, y, z, X, y, Z);
            }
            if ((mask & 2) > 0) {
                this.build(class_2350.field_11036, x, Y, z, X, Y, Z);
            }
            if ((mask & 4) > 0) {
                this.build(class_2350.field_11043, x, y, z, X, Y, z);
            }
            if ((mask & 8) > 0) {
                this.build(class_2350.field_11035, x, y, Z, X, Y, Z);
            }
            if ((mask & 0x20) > 0) {
                this.build(class_2350.field_11034, X, y, z, X, Y, Z);
            }
            if ((mask & 0x10) > 0) {
                this.build(class_2350.field_11039, x, y, z, x, Y, Z);
            }
        }
    }
}

