/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.compat.jei;

import dev.technici4n.moderndynamics.client.screen.AttachedIoScreen;
import dev.technici4n.moderndynamics.client.screen.FluidAttachedIoScreen;
import dev.technici4n.moderndynamics.client.screen.ItemAttachedIoScreen;
import dev.technici4n.moderndynamics.gui.menu.ConfigSlot;
import dev.technici4n.moderndynamics.gui.menu.FluidAttachedIoMenu;
import dev.technici4n.moderndynamics.gui.menu.FluidConfigSlot;
import dev.technici4n.moderndynamics.gui.menu.ItemAttachedIoMenu;
import dev.technici4n.moderndynamics.gui.menu.ItemConfigSlot;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import net.minecraft.class_768;

@Environment(value=EnvType.CLIENT)
class GhostIngredientHandler
implements IGhostIngredientHandler<AttachedIoScreen> {
    GhostIngredientHandler() {
    }

    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(AttachedIoScreen gui, I ingredient, boolean doStart) {
        ConfigSlot slot;
        AttachedIoScreen ioScreen;
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        if (gui instanceof ItemAttachedIoScreen) {
            ioScreen = (ItemAttachedIoScreen)gui;
            if (ingredient instanceof class_1799) {
                for (class_1735 s : ((ItemAttachedIoMenu)ioScreen.method_17577()).field_7761) {
                    if (!(s instanceof ItemConfigSlot) || !(slot = (ItemConfigSlot)s).method_7682()) continue;
                    targets.add(new ItemSlotTarget((ItemConfigSlot)slot, (ItemAttachedIoScreen)ioScreen));
                }
            }
        }
        if (gui instanceof FluidAttachedIoScreen) {
            ioScreen = (FluidAttachedIoScreen)gui;
            if (ingredient instanceof IJeiFluidIngredient) {
                for (class_1735 s : ((FluidAttachedIoMenu)ioScreen.method_17577()).field_7761) {
                    if (!(s instanceof FluidConfigSlot) || !(slot = (FluidConfigSlot)s).method_7682()) continue;
                    targets.add(new FluidSlotTarget((FluidConfigSlot)slot, (FluidAttachedIoScreen)ioScreen));
                }
            }
        }
        return targets;
    }

    public void onComplete() {
    }

    private static class_768 getSlotBounds(class_1735 slot, AttachedIoScreen<?> screen) {
        return new class_768(slot.field_7873 + screen.getLeftPos(), slot.field_7872 + screen.getTopPos(), 16, 16);
    }

    @Environment(value=EnvType.CLIENT)
    private static class ItemSlotTarget
    implements IGhostIngredientHandler.Target<class_1799> {
        private final ItemConfigSlot slot;
        private final ItemAttachedIoScreen ioScreen;

        public ItemSlotTarget(ItemConfigSlot slot, ItemAttachedIoScreen ioScreen) {
            this.slot = slot;
            this.ioScreen = ioScreen;
        }

        public class_768 getArea() {
            return GhostIngredientHandler.getSlotBounds(this.slot, this.ioScreen);
        }

        public void accept(class_1799 ingredient) {
            if (this.slot.method_7682()) {
                ItemVariant iv = ItemVariant.of((class_1799)ingredient);
                ((ItemAttachedIoMenu)this.ioScreen.method_17577()).setFilter(this.slot.getConfigIdx(), iv, true);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class FluidSlotTarget
    implements IGhostIngredientHandler.Target<IJeiFluidIngredient> {
        private final FluidConfigSlot slot;
        private final FluidAttachedIoScreen ioScreen;

        public FluidSlotTarget(FluidConfigSlot slot, FluidAttachedIoScreen ioScreen) {
            this.slot = slot;
            this.ioScreen = ioScreen;
        }

        public class_768 getArea() {
            return GhostIngredientHandler.getSlotBounds(this.slot, this.ioScreen);
        }

        public void accept(IJeiFluidIngredient ingredient) {
            if (this.slot.method_7682()) {
                FluidVariant fv = FluidVariant.of((class_3611)ingredient.getFluid(), (class_2487)ingredient.getTag().orElse(null));
                ((FluidAttachedIoMenu)this.ioScreen.method_17577()).setFilter(this.slot.getConfigIdx(), fv, true);
            }
        }
    }
}

