/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.technici4n.moderndynamics.attachment.settings.FilterDamageMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterInversionMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterModMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterNbtMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterSimilarMode;
import dev.technici4n.moderndynamics.attachment.settings.OversendingMode;
import dev.technici4n.moderndynamics.attachment.settings.RoutingMode;
import dev.technici4n.moderndynamics.client.screen.CycleSetting;
import dev.technici4n.moderndynamics.client.screen.ItemAttachedIoScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class CycleSettingButton<T>
extends class_4185 {
    private static final int DISABLED_SETTING = 0;
    private final List<CycleSetting<T>> settings;
    private int currentSetting;
    private final BiConsumer<T, Boolean> onChange;
    private boolean advancedBehavior = false;
    public static final List<CycleSetting<FilterInversionMode>> FILTER_INVERSION = ImmutableList.of(new CycleSetting<FilterInversionMode>(FilterInversionMode.WHITELIST, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.filter_mode.whitelist"), 176, 0), new CycleSetting<FilterInversionMode>(FilterInversionMode.BLACKLIST, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.filter_mode.blacklist"), 196, 0));
    public static final List<CycleSetting<FilterNbtMode>> FILTER_NBT = ImmutableList.of(new CycleSetting<FilterNbtMode>(FilterNbtMode.RESPECT_NBT, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.filter_nbt.respect_nbt"), 216, 0), new CycleSetting<FilterNbtMode>(FilterNbtMode.IGNORE_NBT, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.filter_nbt.ignore_nbt"), 236, 0));
    public static final List<CycleSetting<FilterDamageMode>> FILTER_DAMAGE = ImmutableList.of(new CycleSetting<FilterDamageMode>(FilterDamageMode.RESPECT_DAMAGE, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.filter_damage.respect_damage"), 176, 60), new CycleSetting<FilterDamageMode>(FilterDamageMode.IGNORE_DAMAGE, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.filter_damage.ignore_damage"), 196, 60));
    public static final List<CycleSetting<FilterModMode>> FILTER_MOD = ImmutableList.of(new CycleSetting<FilterModMode>(FilterModMode.IGNORE_MOD, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.filter_mod.ignore_mod"), 196, 120), new CycleSetting<FilterModMode>(FilterModMode.INCLUDE_ALL_OF_MOD, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.filter_mod.include_all_of_mod"), 176, 120));
    public static final List<CycleSetting<FilterSimilarMode>> FILTER_SIMILAR = ImmutableList.of(new CycleSetting<FilterSimilarMode>(FilterSimilarMode.IGNORE_SIMILAR, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.filter_similar.ignore_similar"), 236, 60), new CycleSetting<FilterSimilarMode>(FilterSimilarMode.INCLUDE_SIMILAR, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.filter_similar.include_similar"), 216, 60));
    public static final List<CycleSetting<RoutingMode>> ROUTING_MODE = ImmutableList.of(new CycleSetting<RoutingMode>(RoutingMode.CLOSEST, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.routing_mode.closest"), 216, 196), new CycleSetting<RoutingMode>(RoutingMode.FURTHEST, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.routing_mode.furthest"), 20, 204), new CycleSetting<RoutingMode>(RoutingMode.RANDOM, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.routing_mode.random"), 40, 204), new CycleSetting<RoutingMode>(RoutingMode.ROUND_ROBIN, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.routing_mode.round_robin"), 60, 204));
    public static final List<CycleSetting<OversendingMode>> OVERSENDING_MODE = ImmutableList.of(new CycleSetting<OversendingMode>(OversendingMode.PREVENT_OVERSENDING, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.oversending_mode.prevent_oversending"), 196, 196), new CycleSetting<OversendingMode>(OversendingMode.ALLOW_OVERSENDING, (class_2561)class_2561.method_43471((String)"gui.moderndynamics.setting.oversending_mode.allow_oversending"), 176, 196));
    public static final class_2561 REQUIRES_ADVANCED_BEHAVIOR = class_2561.method_43471((String)"gui.moderndynamics.tooltip.requires_advanced_behavior").method_10862(class_2583.field_24360.method_10977(class_124.field_1079));

    public CycleSettingButton(List<CycleSetting<T>> settings, T initialSetting, BiConsumer<T, Boolean> onChange) {
        super(0, 0, 20, 20, (class_2561)class_2561.method_43473(), button -> {});
        this.settings = settings;
        this.setValue(initialSetting);
        this.onChange = onChange;
    }

    public CycleSettingButton<T> requiresAdvancedBehavior() {
        this.advancedBehavior = true;
        return this;
    }

    public void setValue(T newValue) {
        for (int i = 0; i < this.settings.size(); ++i) {
            if (this.settings.get(i).value() != newValue) continue;
            this.currentSetting = i;
            break;
        }
    }

    public void method_25306() {
        if (!this.method_37303()) {
            return;
        }
        this.currentSetting = (this.currentSetting + 1) % this.settings.size();
        this.onChange.accept(this.getCurrentSetting().value(), true);
    }

    private CycleSetting<T> getCurrentSetting() {
        return this.settings.get(this.method_37303() ? this.currentSetting : 0);
    }

    public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)ItemAttachedIoScreen.TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
        CycleSetting<T> setting = this.getCurrentSetting();
        int y = setting.spriteY();
        if (!this.method_37303()) {
            y += 40;
        } else if (this.field_22762) {
            y += 20;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.method_25302(poseStack, this.field_22760, this.field_22761, setting.spriteX(), y, this.field_22758, this.field_22759);
        if (this.field_22762) {
            ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
            tooltip.add(setting.tooltip());
            if (this.advancedBehavior && !this.method_37303()) {
                tooltip.add(REQUIRES_ADVANCED_BEHAVIOR);
            }
            class_310.method_1551().field_1755.method_32634(poseStack, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }
}

