/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.fluid;

import com.google.common.collect.Iterators;
import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.IoAttachmentItem;
import dev.technici4n.moderndynamics.attachment.IoAttachmentType;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.AttachedIo;
import dev.technici4n.moderndynamics.attachment.attached.FluidAttachedIo;
import dev.technici4n.moderndynamics.network.NetworkManager;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.network.fluid.ConnectedFluidStorage;
import dev.technici4n.moderndynamics.network.fluid.FluidCache;
import dev.technici4n.moderndynamics.network.shared.TransferLimits;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.TransferUtil;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.FilteringStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class FluidHost
extends NodeHost {
    private static final NetworkManager<FluidHost, FluidCache> MANAGER = NetworkManager.get(FluidCache.class, FluidCache::new);
    private FluidVariant variant = FluidVariant.blank();
    private long amount = 0L;
    private final TransferLimits extractorLimit = new TransferLimits(side -> {
        FluidAttachedIo io;
        AttachedAttachment patt2838$temp = this.getAttachment(side);
        if (!(patt2838$temp instanceof FluidAttachedIo) || (io = (FluidAttachedIo)patt2838$temp).getType() != IoAttachmentType.EXTRACTOR) {
            return 0L;
        }
        return io.getFluidMaxIo();
    }, 81000L);
    private final Storage<FluidVariant>[] caps = new Storage[6];

    public FluidHost(PipeBlockEntity pipe) {
        super(pipe);
        for (int i = 0; i < 6; ++i) {
            final class_2350 dir = class_2350.method_10143((int)i);
            this.caps[i] = new FilteringStorage<FluidVariant>(this::getInternalNetworkStorage){

                protected boolean canInsert(FluidVariant resource) {
                    return FluidHost.this.canMoveOutsideToNetwork(dir, resource);
                }

                protected boolean canExtract(FluidVariant resource) {
                    return FluidHost.this.canMoveNetworkToOutside(dir, resource);
                }
            };
        }
    }

    @Override
    public NetworkManager<FluidHost, FluidCache> getManager() {
        return MANAGER;
    }

    @Override
    @Nullable
    public Object getApiInstance(BlockApiLookup<?, class_2350> lookup, class_2350 side) {
        if (lookup == FluidStorage.SIDED && (this.pipe.connectionBlacklist & 1 << side.method_10146()) == 0) {
            return this.caps[side.method_10146()];
        }
        return null;
    }

    public long getAmount() {
        return this.amount;
    }

    public FluidVariant getVariant() {
        return this.variant;
    }

    public void setContents(FluidVariant variant, long nodeFluid) {
        if (!variant.equals(this.variant) || nodeFluid != this.amount) {
            this.variant = variant;
            this.amount = nodeFluid;
            this.pipe.method_5431();
            this.pipe.sync(false);
        }
    }

    @Override
    protected void doUpdate() {
        this.updateConnections();
    }

    @Override
    public boolean acceptsAttachment(AttachmentItem attachment, class_1799 stack) {
        return attachment instanceof IoAttachmentItem;
    }

    @Override
    public boolean canConnectTo(class_2350 connectionDirection, NodeHost adjacentHost) {
        AttachedAttachment attachment = this.getAttachment(connectionDirection);
        if (attachment instanceof AttachedIo) {
            return false;
        }
        return super.canConnectTo(connectionDirection, adjacentHost) && this.hasCompatibleFluid(adjacentHost);
    }

    private boolean hasCompatibleFluid(NodeHost other) {
        return FluidCache.areCompatible(((FluidHost)other).variant, this.variant);
    }

    @Override
    public void onConnectedTo(NodeHost other) {
        if (other instanceof FluidHost) {
            FluidHost fh = (FluidHost)other;
            if (!fh.variant.isBlank()) {
                this.variant = fh.variant;
                this.pipe.method_5431();
            }
        }
    }

    @Override
    public void onConnectionRejectedTo(class_2350 direction, NodeHost other) {
        if (this.getAttachment(direction) instanceof AttachedIo || other.getAttachment(direction.method_10153()) instanceof AttachedIo) {
            return;
        }
        if (!this.hasCompatibleFluid(other)) {
            this.pipe.connectionBlacklist |= 1 << direction.method_10146();
            this.pipe.method_5431();
        }
    }

    public void gatherCapabilities(@Nullable List<ConnectedFluidStorage> out) {
        int oldConnections = this.inventoryConnections;
        for (int i = 0; i < 6; ++i) {
            if ((this.inventoryConnections & 1 << i) <= 0 || (this.pipeConnections & 1 << i) != 0) continue;
            final class_2350 dir = class_2350.method_10143((int)i);
            Storage adjacentCap = (Storage)FluidStorage.SIDED.find(this.pipe.method_10997(), this.pipe.method_11016().method_10093(dir), (Object)dir.method_10153());
            if (adjacentCap != null) {
                FluidAttachedIo io;
                FluidAttachedIo attachment;
                if (out == null) continue;
                AttachedAttachment attachedAttachment = this.getAttachment(dir);
                FluidAttachedIo fluidAttachedIo = attachment = attachedAttachment instanceof FluidAttachedIo ? (io = (FluidAttachedIo)attachedAttachment) : null;
                if (attachment == null) {
                    out.add(new ConnectedFluidStorage((Storage<FluidVariant>)adjacentCap, null, null));
                    continue;
                }
                if (!attachment.isEnabledViaRedstone(this.pipe)) continue;
                FilteringStorage<FluidVariant> filteredStorage = new FilteringStorage<FluidVariant>(adjacentCap){

                    protected boolean canExtract(FluidVariant resource) {
                        return FluidHost.this.canMoveOutsideToNetwork(dir, resource);
                    }

                    protected boolean canInsert(FluidVariant resource) {
                        return FluidHost.this.canMoveNetworkToOutside(dir, resource);
                    }
                };
                ExtractorStorage extractorRateLimit = attachment.getType() == IoAttachmentType.EXTRACTOR ? new ExtractorStorage((Storage<FluidVariant>)filteredStorage, i) : null;
                out.add(new ConnectedFluidStorage((Storage<FluidVariant>)filteredStorage, attachment, extractorRateLimit));
                continue;
            }
            this.inventoryConnections ^= 1 << i;
        }
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
        }
    }

    public void updateConnections() {
        int oldConnections = this.inventoryConnections;
        this.inventoryConnections = 63 - (this.pipeConnections | this.pipe.connectionBlacklist);
        this.gatherCapabilities(null);
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
        }
    }

    @Override
    public void writeNbt(class_2487 tag) {
        super.writeNbt(tag);
        tag.method_10544("amount", this.amount);
        tag.method_10566("variant", (class_2520)this.variant.toNbt());
    }

    @Override
    public void readNbt(class_2487 tag) {
        super.readNbt(tag);
        this.variant = FluidVariant.fromNbt((class_2487)tag.method_10562("variant"));
        this.amount = Math.max(0L, Math.min(tag.method_10537("amount"), 81000L));
        if (this.variant.isBlank()) {
            this.amount = 0L;
        }
    }

    @Override
    public void writeClientNbt(class_2487 tag) {
        super.writeClientNbt(tag);
        tag.method_10544("amount", this.amount);
        tag.method_10566("variant", (class_2520)this.variant.toNbt());
    }

    @Override
    public void readClientNbt(class_2487 tag) {
        super.readClientNbt(tag);
        this.variant = FluidVariant.fromNbt((class_2487)tag.method_10562("variant"));
        this.amount = tag.method_10537("amount");
    }

    private boolean canMoveNetworkToOutside(class_2350 side, FluidVariant variant) {
        AttachedAttachment attachedAttachment = this.getAttachment(side);
        if (attachedAttachment instanceof FluidAttachedIo) {
            FluidAttachedIo io = (FluidAttachedIo)attachedAttachment;
            return io.matchesFilter(variant) && io.isEnabledViaRedstone(this.pipe) && io.getType() != IoAttachmentType.EXTRACTOR;
        }
        return true;
    }

    private boolean canMoveOutsideToNetwork(class_2350 side, FluidVariant variant) {
        AttachedAttachment attachedAttachment = this.getAttachment(side);
        if (attachedAttachment instanceof FluidAttachedIo) {
            FluidAttachedIo io = (FluidAttachedIo)attachedAttachment;
            return io.matchesFilter(variant) && io.isEnabledViaRedstone(this.pipe) && io.getType() != IoAttachmentType.ATTRACTOR;
        }
        return true;
    }

    private SingleSlotStorage<FluidVariant> getInternalNetworkStorage() {
        NetworkNode node = this.findNode();
        if (node != null && node.getHost() == this) {
            return ((FluidCache)node.getNetworkCache()).getOrCreateStorage();
        }
        return TransferUtil.EMPTY_SLOT;
    }

    private class ExtractorStorage
    implements Storage<FluidVariant> {
        private final int directionId;
        private final Storage<FluidVariant> delegate;

        ExtractorStorage(Storage<FluidVariant> delegate, int directionId) {
            this.delegate = delegate;
            this.directionId = directionId;
        }

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            throw new UnsupportedOperationException("Should not be used to insert, only to extract!");
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if ((maxAmount = FluidHost.this.extractorLimit.limit(this.directionId, maxAmount)) <= 0L) {
                return 0L;
            }
            long transferred = this.delegate.extract((Object)resource, maxAmount, transaction);
            FluidHost.this.extractorLimit.use(this.directionId, transferred, transaction);
            return transferred;
        }

        public Iterator<StorageView<FluidVariant>> iterator() {
            return Iterators.transform((Iterator)this.delegate.iterator(), x$0 -> new View((StorageView<FluidVariant>)x$0));
        }

        private class View
        implements StorageView<FluidVariant> {
            private final StorageView<FluidVariant> view;

            private View(StorageView<FluidVariant> view) {
                this.view = view;
            }

            public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
                if ((maxAmount = FluidHost.this.extractorLimit.limit(ExtractorStorage.this.directionId, maxAmount)) <= 0L) {
                    return 0L;
                }
                long transferred = this.view.extract((Object)resource, maxAmount, transaction);
                FluidHost.this.extractorLimit.use(ExtractorStorage.this.directionId, transferred, transaction);
                return transferred;
            }

            public boolean isResourceBlank() {
                return this.view.isResourceBlank();
            }

            public FluidVariant getResource() {
                return (FluidVariant)this.view.getResource();
            }

            public long getAmount() {
                return this.view.getAmount();
            }

            public long getCapacity() {
                return this.view.getCapacity();
            }

            public StorageView<FluidVariant> getUnderlyingView() {
                return this.view.getUnderlyingView();
            }
        }
    }
}

