/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.item;

import com.google.common.base.Preconditions;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.ItemAttachedIo;
import dev.technici4n.moderndynamics.network.NetworkCache;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.item.ItemHost;
import dev.technici4n.moderndynamics.network.item.ItemPath;
import dev.technici4n.moderndynamics.network.item.ItemPathCache;
import dev.technici4n.moderndynamics.network.item.MaxParticipant;
import dev.technici4n.moderndynamics.network.item.SimulatedInsertionTarget;
import dev.technici4n.moderndynamics.network.item.TravelingItem;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ItemCache
extends NetworkCache<ItemHost, ItemCache> {
    private boolean inserting = false;
    protected final ItemPathCache pathCache = new ItemPathCache();

    protected ItemCache(class_3218 level, List<NetworkNode<ItemHost, ItemCache>> networkNodes) {
        super(level, networkNodes);
    }

    @Override
    protected void doTick() {
        for (NetworkNode node : this.nodes) {
            if (!((ItemHost)node.getHost()).isTicking()) continue;
            ((ItemHost)node.getHost()).tickMovingItems();
        }
        for (NetworkNode node : this.nodes) {
            if (!((ItemHost)node.getHost()).isTicking()) continue;
            ((ItemHost)node.getHost()).tickAttachments();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long insertList(NetworkNode<ItemHost, ItemCache> startingPoint, Iterable<ItemPath> paths, ItemVariant variant, long maxAmount, TransactionContext transaction, double speedMultiplier, @Nullable MaxParticipant checkedPathsConsumer) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)variant, (long)maxAmount);
        Preconditions.checkArgument((startingPoint.getNetworkCache() == this ? 1 : 0) != 0, (Object)"Tried to insert into another network!");
        if (this.inserting) {
            return 0L;
        }
        this.inserting = true;
        try {
            long totalInserted = 0L;
            int nextPathIndex = 0;
            for (ItemPath path : paths) {
                SimulatedInsertionTarget simulatedTarget;
                ItemAttachedIo io;
                AttachedAttachment attachedAttachment;
                ++nextPathIndex;
                if (!path.getEndFilter(this.level).test(variant) || (attachedAttachment = path.getEndAttachment(this.level)) instanceof ItemAttachedIo && (io = (ItemAttachedIo)attachedAttachment).isStuffed() || (totalInserted += (simulatedTarget = path.getInsertionTarget(startingPoint.getHost().getPipe().method_10997())).insert(variant, maxAmount - totalInserted, transaction, (v, amount) -> {
                    TravelingItem travelingItem = path.makeTravelingItem(v, amount, speedMultiplier);
                    ((ItemHost)startingPoint.getHost()).addTravelingItem(travelingItem);
                })) != maxAmount) continue;
                break;
            }
            if (checkedPathsConsumer != null) {
                checkedPathsConsumer.addEntry(nextPathIndex, transaction);
            }
            long l = totalInserted;
            return l;
        }
        finally {
            this.inserting = false;
        }
    }
}

