/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.item;

import com.google.common.collect.Lists;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.AttachedInhibitor;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.item.ItemCache;
import dev.technici4n.moderndynamics.network.item.ItemHost;
import dev.technici4n.moderndynamics.network.item.ItemPath;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class ItemPathCache {
    private final Map<SidedNode, List<ItemPath>> cache = new HashMap<SidedNode, List<ItemPath>>();

    public List<ItemPath> getPaths(NetworkNode<ItemHost, ItemCache> startingPoint, class_2350 startingSide) {
        return this.cache.computeIfAbsent(new SidedNode(startingPoint, startingSide), ItemPathCache::computePaths);
    }

    public void invalidate() {
        this.cache.clear();
    }

    private static List<ItemPath> computePaths(SidedNode startingPoint) {
        PriorityQueue<PqNode> pq = new PriorityQueue<PqNode>(Comparator.comparingLong(PqNode::distance));
        Reference2LongOpenHashMap distance = new Reference2LongOpenHashMap();
        IdentityHashMap prevDirection = new IdentityHashMap();
        IdentityHashMap prevNode = new IdentityHashMap();
        PriorityQueue<PqSidedNode> targets = new PriorityQueue<PqSidedNode>(Comparator.comparingLong(PqSidedNode::distance));
        pq.add(new PqNode(startingPoint.node, 0L));
        distance.put(startingPoint.node, 0L);
        while (!pq.isEmpty()) {
            PqNode currentPqNode = pq.poll();
            long currentDistance = currentPqNode.distance;
            NetworkNode<ItemHost, ItemCache> currentNode = currentPqNode.node;
            if (currentDistance != distance.getLong(currentNode)) continue;
            for (class_2350 class_23502 : currentNode.getHost().getInventoryConnections()) {
                AttachedAttachment attachment = currentNode.getHost().getAttachment(class_23502);
                if (attachment != null && !attachment.allowsItemConnection()) continue;
                long edgeWeight = 1L;
                if (currentNode.getHost().getAttachment(class_23502) instanceof AttachedInhibitor) {
                    edgeWeight += 1000L;
                }
                targets.add(new PqSidedNode(new SidedNode(currentNode, class_23502), currentDistance + edgeWeight));
            }
            for (NetworkNode.Connection connection : currentNode.getConnections()) {
                long edgeWeight = 1L;
                if (currentNode.getHost().getAttachment(connection.direction()) instanceof AttachedInhibitor) {
                    edgeWeight += 1000L;
                }
                if (((ItemHost)connection.target().getHost()).getAttachment(connection.direction().method_10153()) instanceof AttachedInhibitor) {
                    edgeWeight += 1000L;
                }
                long newDistance = currentDistance + edgeWeight;
                if (distance.getOrDefault(connection.target(), Long.MAX_VALUE) <= newDistance) continue;
                distance.put(connection.target(), newDistance);
                pq.add(new PqNode(connection.target(), newDistance));
                prevDirection.put(connection.target(), connection.direction());
                prevNode.put(connection.target(), currentNode);
            }
        }
        ArrayList<ItemPath> computedPaths = new ArrayList<ItemPath>(targets.size());
        for (PqSidedNode pqTarget : targets) {
            SidedNode target = pqTarget.sidedNode;
            class_2350 side = target.side;
            if (target.node == startingPoint.node && side == startingPoint.side.method_10153()) continue;
            class_2338 class_23382 = target.node.getHost().getPipe().method_11016().method_10093(side);
            ArrayList<class_2350> reversedPath = new ArrayList<class_2350>();
            NetworkNode current = target.node;
            class_2350 currentDir = side;
            while (current != null) {
                reversedPath.add(currentDir);
                currentDir = (class_2350)prevDirection.get(current);
                current = (NetworkNode)prevNode.get(current);
            }
            reversedPath.add(startingPoint.side);
            class_2350[] path = (class_2350[])Lists.reverse(reversedPath).toArray(class_2350[]::new);
            class_2338 startPos = startingPoint.node.getHost().getPipe().method_11016().method_10093(startingPoint.side.method_10153());
            computedPaths.add(new ItemPath(startPos, class_23382, path));
        }
        return Collections.unmodifiableList(computedPaths);
    }

    private record SidedNode(NetworkNode<ItemHost, ItemCache> node, class_2350 side) {
    }

    private record PqNode(NetworkNode<ItemHost, ItemCache> node, long distance) {
    }

    private record PqSidedNode(SidedNode sidedNode, long distance) {
    }
}

