/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.mienergy;

import dev.technici4n.moderndynamics.network.NetworkCache;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.energy.EnergyCache;
import dev.technici4n.moderndynamics.network.mienergy.MICableTier;
import dev.technici4n.moderndynamics.network.mienergy.MIEnergyHost;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_3218;
import team.reborn.energy.api.EnergyStorage;

public class MIEnergyCache
extends NetworkCache<MIEnergyHost, MIEnergyCache> {
    private long energy = 0L;
    private long maxEnergy = 0L;

    protected MIEnergyCache(class_3218 level, List<NetworkNode<MIEnergyHost, MIEnergyCache>> networkNodes) {
        super(level, networkNodes);
    }

    @Override
    protected void doCombine() {
        this.maxEnergy = 0L;
        this.energy = 0L;
        for (NetworkNode node : this.nodes) {
            this.energy += ((MIEnergyHost)node.getHost()).getEnergy();
            this.maxEnergy += ((MIEnergyHost)node.getHost()).getMaxEnergy();
        }
    }

    @Override
    protected void doSeparate() {
        int remainingNodes = this.nodes.size();
        for (NetworkNode node : this.nodes) {
            MIEnergyHost host = (MIEnergyHost)node.getHost();
            long nodeEnergy = Math.min(host.getMaxEnergy(), this.energy / (long)remainingNodes);
            host.setEnergy(nodeEnergy);
            this.energy -= nodeEnergy;
            --remainingNodes;
        }
    }

    @Override
    protected void doTick() {
        this.combine();
        ArrayList<EnergyStorage> storages = new ArrayList<EnergyStorage>();
        for (NetworkNode node : this.nodes) {
            if (!((MIEnergyHost)node.getHost()).isTicking()) continue;
            ((MIEnergyHost)node.getHost()).gatherCapabilities(storages);
        }
        MICableTier tier = ((MIEnergyHost)((NetworkNode)this.nodes.get((int)0)).getHost()).tier;
        try (Transaction tx = Transaction.openOuter();){
            this.energy += EnergyCache.transferForTargets(EnergyStorage::extract, storages, Math.min(this.maxEnergy - this.energy, tier.getMax()), tx);
            this.energy -= EnergyCache.transferForTargets(EnergyStorage::insert, storages, Math.min(this.energy, tier.getMax()), tx);
            tx.commit();
        }
    }
}

