/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.pipe;

import com.google.common.base.Preconditions;
import dev.technici4n.moderndynamics.MdBlockEntity;
import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.model.AttachmentModelData;
import dev.technici4n.moderndynamics.model.PipeModelData;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.network.TickHelper;
import dev.technici4n.moderndynamics.pipe.PipeBoundingBoxes;
import dev.technici4n.moderndynamics.util.DropHelper;
import dev.technici4n.moderndynamics.util.ShapeHelper;
import dev.technici4n.moderndynamics.util.WrenchHelper;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1262;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public abstract class PipeBlockEntity
extends MdBlockEntity
implements RenderAttachmentBlockEntity {
    private NodeHost[] hosts;
    private boolean hostsRegistered = false;
    public int connectionBlacklist = 0;
    private class_265 cachedShape = PipeBoundingBoxes.CORE_SHAPE;
    private PipeModelData clientModelData = null;
    private int clientSideConnections = 0;

    public PipeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected abstract NodeHost[] createHosts();

    public final NodeHost[] getHosts() {
        if (this.hosts == null) {
            this.hosts = this.createHosts();
        }
        return this.hosts;
    }

    private boolean hasAttachment(class_2350 side) {
        if (this.isClientSide()) {
            return this.clientModelData != null && this.clientModelData.attachments()[side.method_10146()] != null;
        }
        return this.getAttachment(side) != null;
    }

    public final AttachedAttachment getAttachment(class_2350 side) {
        Preconditions.checkState((!this.isClientSide() ? 1 : 0) != 0, (Object)"Attachments don't exist on the client.");
        for (NodeHost host : this.getHosts()) {
            AttachedAttachment attachment = host.getAttachment(side);
            if (attachment == null) continue;
            return attachment;
        }
        return null;
    }

    @Override
    public void sync() {
        super.sync();
        this.updateCachedShape(this.getPipeConnections(), this.getInventoryConnections());
    }

    @Override
    public void toClientTag(class_2487 tag) {
        tag.method_10567("connectionBlacklist", (byte)this.connectionBlacklist);
        tag.method_10567("connections", (byte)this.getPipeConnections());
        tag.method_10567("inventoryConnections", (byte)this.getInventoryConnections());
        for (NodeHost host : this.getHosts()) {
            host.writeClientNbt(tag);
        }
        class_2499 attachments = new class_2499();
        for (class_2350 direction : class_2350.values()) {
            AttachedAttachment attachment = this.getAttachment(direction);
            if (attachment != null) {
                attachments.add((Object)attachment.getModelData().write(new class_2487()));
                continue;
            }
            attachments.add((Object)new class_2487());
        }
        tag.method_10566("attachments", (class_2520)attachments);
    }

    @Override
    public void fromClientTag(class_2487 tag) {
        this.connectionBlacklist = tag.method_10571("connectionBlacklist");
        byte connections = tag.method_10571("connections");
        byte inventoryConnections = tag.method_10571("inventoryConnections");
        class_2371 attachmentStacks = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, (class_2371)attachmentStacks);
        for (NodeHost host : this.getHosts()) {
            host.readClientNbt(tag);
        }
        if (tag.method_10577("#c") || this.clientModelData == null) {
            class_2499 attachmentTags = tag.method_10554("attachments", 10);
            AttachmentModelData[] attachments = new AttachmentModelData[6];
            for (class_2350 direction : class_2350.values()) {
                class_2487 attachmentTag = attachmentTags.method_10602(direction.method_10146());
                attachments[direction.method_10146()] = AttachmentModelData.from(attachmentTag);
            }
            this.clientModelData = new PipeModelData(connections, inventoryConnections, attachments);
            this.clientSideConnections = connections | inventoryConnections;
            this.updateCachedShape(connections, inventoryConnections);
        }
    }

    @Nullable
    public Object getRenderAttachmentData() {
        return this.clientModelData;
    }

    @Override
    public void toTag(class_2487 nbt) {
        nbt.method_10567("connectionBlacklist", (byte)this.connectionBlacklist);
        if (!this.field_11863.method_8608()) {
            for (NodeHost host : this.getHosts()) {
                if (this.hostsRegistered) {
                    host.separateNetwork();
                }
                host.writeNbt(nbt);
            }
        }
    }

    @Override
    public void fromTag(class_2487 nbt) {
        this.connectionBlacklist = nbt.method_10571("connectionBlacklist");
        for (NodeHost host : this.getHosts()) {
            if (this.hostsRegistered) {
                host.separateNetwork();
            }
            host.readNbt(nbt);
        }
    }

    public void scheduleHostUpdates() {
        for (NodeHost host : this.getHosts()) {
            host.scheduleUpdate();
        }
    }

    public void method_10996() {
        super.method_10996();
        if (!this.field_11863.method_8608() && !this.hostsRegistered) {
            TickHelper.runLater(() -> {
                if (!this.hostsRegistered && !this.method_11015()) {
                    this.hostsRegistered = true;
                    for (NodeHost host : this.getHosts()) {
                        host.addSelf();
                    }
                }
            });
        }
    }

    public void method_11012() {
        super.method_11012();
        if (!this.field_11863.method_8608() && this.hostsRegistered) {
            this.hostsRegistered = false;
            for (NodeHost host : this.getHosts()) {
                host.removeSelf();
            }
        }
    }

    public void refreshHosts() {
        if (this.hostsRegistered) {
            for (NodeHost host : this.getHosts()) {
                host.refreshSelf();
            }
        }
    }

    @Nullable
    public Object getApiInstance(BlockApiLookup<?, class_2350> direction, class_2350 side) {
        for (NodeHost host : this.getHosts()) {
            Object api = host.getApiInstance(direction, side);
            if (api == null) continue;
            return api;
        }
        return null;
    }

    protected int getPipeConnections() {
        int pipeConnections = 0;
        for (NodeHost host : this.getHosts()) {
            pipeConnections |= host.pipeConnections;
        }
        return pipeConnections;
    }

    protected int getInventoryConnections() {
        int inventoryConnections = 0;
        for (NodeHost host : this.getHosts()) {
            inventoryConnections |= host.inventoryConnections;
        }
        return inventoryConnections;
    }

    public class_265 getCachedShape() {
        return this.cachedShape;
    }

    public void updateCachedShape(int pipeConnections, int inventoryConnections) {
        int attachments = 0;
        for (class_2350 direction : class_2350.values()) {
            if (!this.hasAttachment(direction)) continue;
            attachments |= 1 << direction.method_10146();
        }
        this.cachedShape = PipeBoundingBoxes.getPipeShape(pipeConnections, inventoryConnections, attachments);
    }

    protected void updateConnection(class_2350 side, boolean addConnection) {
        if (this.field_11863.method_8608()) {
            throw new IllegalStateException("updateConnections() should not be called client-side.");
        }
        this.connectionBlacklist = addConnection ? (this.connectionBlacklist &= ~(1 << side.method_10146())) : (this.connectionBlacklist |= 1 << side.method_10146());
        class_2586 be = this.field_11863.method_8321(this.field_11867.method_10093(side));
        if (be instanceof PipeBlockEntity) {
            PipeBlockEntity neighborPipe = (PipeBlockEntity)be;
            neighborPipe.connectionBlacklist = addConnection ? (neighborPipe.connectionBlacklist &= ~(1 << side.method_10153().method_10146())) : (neighborPipe.connectionBlacklist |= 1 << side.method_10153().method_10146());
            neighborPipe.method_5431();
        }
        this.refreshHosts();
        this.scheduleHostUpdates();
        this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
        this.method_5431();
    }

    public class_1269 onUse(class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_2350 hitSide;
        class_1792 side;
        class_1799 stack = player.method_5998(hand);
        class_243 posInBlock = hitResult.method_17784().method_1023((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
        if (WrenchHelper.isWrench(stack)) {
            if (ShapeHelper.shapeContains(PipeBoundingBoxes.CORE_SHAPE, posInBlock) && (this.connectionBlacklist & 1 << hitResult.method_17780().method_10146()) > 0) {
                if (!this.field_11863.method_8608()) {
                    this.updateConnection(hitResult.method_17780(), true);
                }
                return class_1269.method_29236((boolean)this.field_11863.method_8608());
            }
            for (int i = 0; i < 6; ++i) {
                if (!ShapeHelper.shapeContains(PipeBoundingBoxes.INVENTORY_CONNECTIONS[i], posInBlock)) continue;
                side = class_2350.method_10143((int)i);
                if (this.hasAttachment((class_2350)side)) {
                    if (this.field_11863.method_8608()) {
                        return class_1269.field_5812;
                    }
                    for (NodeHost host : this.getHosts()) {
                        AttachedAttachment attachment = host.removeAttachment((class_2350)side);
                        if (attachment == null) continue;
                        if (!player.method_7337()) {
                            DropHelper.dropStacks(this, attachment.getDrops());
                        }
                        this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
                        this.refreshHosts();
                        this.scheduleHostUpdates();
                        this.method_5431();
                        this.sync();
                        return class_1269.field_21466;
                    }
                    continue;
                }
                if (this.field_11863.method_8608()) {
                    if ((this.clientSideConnections & 1 << i) <= 0) continue;
                    return class_1269.field_5812;
                }
                if ((this.getPipeConnections() & 1 << i) <= 0 && (this.getInventoryConnections() & 1 << i) <= 0) continue;
                this.updateConnection(class_2350.method_10143((int)i), false);
                return class_1269.field_21466;
            }
        }
        if ((side = stack.method_7909()) instanceof AttachmentItem) {
            AttachmentItem attachmentItem = (AttachmentItem)side;
            class_2350 hitSide2 = null;
            if (ShapeHelper.shapeContains(PipeBoundingBoxes.CORE_SHAPE, posInBlock)) {
                hitSide2 = hitResult.method_17780();
            }
            for (int i = 0; i < 6; ++i) {
                if (!ShapeHelper.shapeContains(PipeBoundingBoxes.INVENTORY_CONNECTIONS[i], posInBlock)) continue;
                hitSide2 = class_2350.method_10143((int)i);
            }
            if (hitSide2 != null && !this.hasAttachment(hitSide2)) {
                for (NodeHost host : this.getHosts()) {
                    if (!host.acceptsAttachment(attachmentItem, stack)) continue;
                    if (!this.field_11863.field_9236) {
                        class_2487 initialData = stack.method_7969();
                        if (initialData == null) {
                            initialData = new class_2487();
                        }
                        host.setAttachment(hitSide2, attachmentItem, initialData);
                        host.getAttachment(hitSide2).onPlaced(player);
                        this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
                        this.refreshHosts();
                        this.scheduleHostUpdates();
                        this.method_5431();
                        this.sync();
                    }
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    return class_1269.method_29236((boolean)this.field_11863.field_9236);
                }
            }
        }
        if ((hitSide = this.hitTestAttachments(posInBlock)) != null) {
            AttachedAttachment attachment;
            if (!this.isClientSide() && (attachment = this.getAttachment(hitSide)) != null && attachment.hasMenu()) {
                player.method_17355(attachment.createMenu(this, hitSide));
            }
            return class_1269.method_29236((boolean)this.isClientSide());
        }
        return class_1269.field_5811;
    }

    @Nullable
    public class_2350 hitTestAttachments(class_243 posInBlock) {
        for (int i = 0; i < 6; ++i) {
            class_2350 direction = class_2350.method_10143((int)i);
            if (!this.hasAttachment(direction) || !ShapeHelper.shapeContains(PipeBoundingBoxes.CONNECTOR_SHAPES[i], posInBlock)) continue;
            return direction;
        }
        return null;
    }

    public class_1799 overridePickBlock(class_239 hitResult) {
        class_243 posInBlock = hitResult.method_17784().method_1023((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
        class_2350 side = this.hitTestAttachments(posInBlock);
        return side != null ? new class_1799((class_1935)this.clientModelData.attachments()[side.method_10146()].item()) : class_1799.field_8037;
    }

    public void onRemoved() {
        for (NodeHost host : this.getHosts()) {
            host.onRemoved();
        }
    }

    public int getClientSideConnections() {
        Preconditions.checkState((boolean)this.isClientSide());
        return this.clientSideConnections;
    }

    public void clientTick() {
        for (NodeHost host : this.getHosts()) {
            host.clientTick();
        }
    }
}

