/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.test.framework;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.FluidAttachedIo;
import dev.technici4n.moderndynamics.attachment.attached.ItemAttachedIo;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.test.framework.MdGameTestHelper;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;

public class PipeBuilder {
    private final MdGameTestHelper helper;
    private final PipeBlockEntity pipe;

    public PipeBuilder(MdGameTestHelper helper, PipeBlockEntity pipe) {
        this.helper = helper;
        this.pipe = pipe;
    }

    public PipeBuilder attachment(class_2350 direction, AttachmentItem attachment) {
        class_1799 stack = attachment.method_7854();
        for (NodeHost host : this.pipe.getHosts()) {
            if (!host.acceptsAttachment(attachment, stack)) continue;
            class_2487 initialData = stack.method_7969();
            if (initialData == null) {
                initialData = new class_2487();
            }
            host.setAttachment(direction, attachment, initialData);
            this.helper.method_35943().method_8408(this.pipe.method_11016(), this.pipe.method_11010().method_26204());
            this.pipe.refreshHosts();
            this.pipe.scheduleHostUpdates();
            this.pipe.method_5431();
            this.pipe.sync();
            return this;
        }
        this.helper.method_35997("Failed to add attachment " + attachment + " to pipe", this.pipe.method_11016());
        throw new UnsupportedOperationException();
    }

    public PipeBuilder configureFluidIo(class_2350 direction, Consumer<FluidAttachedIo> config) {
        AttachedAttachment attachedAttachment = this.pipe.getAttachment(direction);
        if (attachedAttachment instanceof FluidAttachedIo) {
            FluidAttachedIo fluidIo = (FluidAttachedIo)attachedAttachment;
            config.accept(fluidIo);
            return this;
        }
        this.helper.method_35997("Failed to find fluid io from pipe", this.pipe.method_11016());
        throw new UnsupportedOperationException();
    }

    public PipeBuilder configureItemIo(class_2350 direction, Consumer<ItemAttachedIo> config) {
        AttachedAttachment attachedAttachment = this.pipe.getAttachment(direction);
        if (attachedAttachment instanceof ItemAttachedIo) {
            ItemAttachedIo itemIo = (ItemAttachedIo)attachedAttachment;
            config.accept(itemIo);
            return this;
        }
        this.helper.method_35997("Failed to find item io from pipe", this.pipe.method_11016());
        throw new UnsupportedOperationException();
    }
}

