/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.api;

import aztech.modern_industrialization.definition.FluidLike;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class FluidFuelRegistry {
    private static final Map<class_2960, Integer> fluidEus = new HashMap<class_2960, Integer>();

    public static void register(FluidLike fluid, int eu) {
        FluidFuelRegistry.register(fluid.asFluid(), eu);
    }

    public static void register(class_3611 fluid, int eu) {
        if (fluid == null || fluid == class_3612.field_15906) {
            throw new RuntimeException("May not register a null or empty fluid!");
        }
        FluidFuelRegistry.register(class_2378.field_11154.method_10221((Object)fluid), eu);
    }

    public static void register(class_2960 fluidId, int eu) {
        Objects.requireNonNull(fluidId);
        if (eu <= 0) {
            throw new RuntimeException("Fluids must have a positive eu amount!");
        }
        if (fluidEus.containsKey(fluidId)) {
            throw new RuntimeException("May not re-register a fluid fuel!");
        }
        fluidEus.put(fluidId, eu);
    }

    public static int getEu(class_3611 fluid) {
        return fluidEus.getOrDefault(class_2378.field_11154.method_10221((Object)fluid), 0);
    }

    public static List<class_3611> getRegisteredFluids() {
        ArrayList<class_2960> fluidIds = new ArrayList<class_2960>(fluidEus.keySet());
        fluidIds.sort(Comparator.comparing(fluidEus::get));
        return fluidIds.stream().map(arg_0 -> ((class_2348)class_2378.field_11154).method_10223(arg_0)).filter(fluid -> fluid != class_3612.field_15906).toList();
    }
}

