/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.ae2;

import appeng.api.features.P2PTunnelAttunement;
import appeng.api.inventories.PartApiLookup;
import appeng.api.parts.PartModels;
import appeng.api.util.AEColor;
import appeng.items.parts.PartItem;
import appeng.items.parts.PartModelsHelper;
import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.compat.ae2.EnergyP2PTunnelPart;
import aztech.modern_industrialization.compat.ae2.pipe.MENetwork;
import aztech.modern_industrialization.compat.ae2.pipe.MENetworkData;
import aztech.modern_industrialization.compat.ae2.pipe.MENetworkNode;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.PipeColor;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class MIAEAddon {
    public static final class_1792 ENERGY_P2P_TUNNEL;
    public static final List<PipeNetworkType> PIPES;

    public static void init() {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(EnergyP2PTunnelPart.class));
        class_1792 item = (class_1792)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new MIIdentifier("energy_p2p_tunnel"), (Object)ENERGY_P2P_TUNNEL);
        P2PTunnelAttunement.registerAttunementTag((class_1935)item);
        PartApiLookup.register(EnergyApi.SIDED, (part, context) -> (MIEnergyStorage)part.getExposedApi(), EnergyP2PTunnelPart.class);
    }

    public static void onInitializePipes() {
        for (PipeColor color : PipeColor.values()) {
            MIAEAddon.registerMEPipeType(color);
        }
        TagsToGenerate.markTagOptional(MITags.ME_WIRES);
    }

    private static void registerMEPipeType(PipeColor color) {
        AEColor aeColor = switch (color) {
            case PipeColor.REGULAR -> AEColor.TRANSPARENT;
            default -> {
                for (AEColor candidate : AEColor.values()) {
                    if (!candidate.registryPrefix.equals(color.name)) continue;
                    yield candidate;
                }
                throw new UnsupportedOperationException("No AE color for " + color.name);
            }
        };
        String pipeId = color.prefix + "me_wire";
        PipeNetworkType type = PipeNetworkType.register(new MIIdentifier(pipeId), (id, data) -> new MENetwork((int)id, (PipeNetworkData)data, aeColor), MENetworkNode::new, color.color, false);
        PIPES.add(type);
        ItemDefinition<PipeItem> itemDef = MIItem.itemNoModel(color.englishNamePrefix + "ME Wire", pipeId, prop -> new PipeItem((class_1792.class_1793)prop, type, new MENetworkData()), SortOrder.PIPES);
        PipeItem item = itemDef.method_8389();
        MIPipes.INSTANCE.register(type, item);
        MIPipes.ITEM_PIPE_MODELS.add(new MIIdentifier("item/" + pipeId));
        TagsToGenerate.generateTag(MITags.ME_WIRES, (class_1792)item, "ME Wires");
    }

    static {
        if (!MIConfig.loadAe2Compat()) {
            throw new RuntimeException("AE2 compat is disabled. How did this get loaded?");
        }
        ENERGY_P2P_TUNNEL = new PartItem(new FabricItemSettings().method_7892(ModernIndustrialization.ITEM_GROUP), EnergyP2PTunnelPart.class, EnergyP2PTunnelPart::new);
        PIPES = new ArrayList<PipeNetworkType>();
    }
}

