/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.ae2.pipe;

import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.util.AEColor;
import appeng.me.GridConnection;
import aztech.modern_industrialization.compat.ae2.pipe.INetworkInternalNode;
import aztech.modern_industrialization.compat.ae2.pipe.MENetworkData;
import aztech.modern_industrialization.compat.ae2.pipe.MENetworkNode;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeNetwork;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class MENetwork
extends PipeNetwork {
    final AEColor color;

    public MENetwork(int id, PipeNetworkData data, AEColor color) {
        super(id, data == null ? new MENetworkData() : data);
        this.color = color;
    }

    @Override
    public void setNode(class_2338 pos, @Nullable PipeNetworkNode maybeNode) {
        if (maybeNode instanceof MENetworkNode) {
            MENetworkNode node = (MENetworkNode)maybeNode;
            IManagedGridNode aeManagedNode = node.mainNode;
            if (aeManagedNode != null && aeManagedNode.isReady()) {
                MENetworkData meData;
                PipeNetworkData connection2;
                for (PipeNetworkData connection2 : aeManagedNode.getNode().getConnections()) {
                    IGridNode otherSide = connection2.getOtherSide(aeManagedNode.getNode());
                    if (otherSide.getService(INetworkInternalNode.class) == null) continue;
                    connection2.destroy();
                    break;
                }
                if ((connection2 = this.data) instanceof MENetworkData && (meData = (MENetworkData)connection2).getMainNode().isReady()) {
                    try {
                        GridHelper.createGridConnection((IGridNode)meData.getMainNode().getNode(), (IGridNode)aeManagedNode.getNode());
                    }
                    catch (FailedConnectionException e) {
                        node.connections.clear();
                        node.updateNode();
                    }
                }
            }
        }
        super.setNode(pos, maybeNode);
    }

    @Override
    public void onRemove() {
        PipeNetworkData pipeNetworkData = this.data;
        if (pipeNetworkData instanceof MENetworkData) {
            MENetworkData meData = (MENetworkData)pipeNetworkData;
            meData.getMainNode().destroy();
        }
        for (PipeNetworkNode node : this.getRawNodeMap().values()) {
            if (node == null) continue;
            node.onUnload();
        }
    }

    @Override
    public void tick(class_3218 world) {
        IManagedGridNode mainNode = ((MENetworkData)this.data).getMainNode();
        if (!mainNode.isReady()) {
            mainNode.create((class_1937)world, null);
        }
        for (PipeNetwork.PosNode posNode : this.iterateTickingNodes()) {
            MENetworkNode node = (MENetworkNode)posNode.getNode();
            if (node.connectDelay-- > 0) continue;
            node.connectDelay = 100;
            node.updateNode();
            if (node.mainNode == null) continue;
            boolean wasReady = node.mainNode.isReady();
            boolean hasInternalConnection = false;
            if (node.mainNode.isReady()) {
                for (IGridConnection conn : node.mainNode.getNode().getConnections()) {
                    if (conn.getOtherSide(node.mainNode.getNode()).getService(INetworkInternalNode.class) == null) continue;
                    hasInternalConnection = true;
                    break;
                }
            } else {
                node.mainNode.setVisualRepresentation((class_1935)MIPipes.INSTANCE.getPipeItem(this.manager.getType()));
                node.mainNode.create((class_1937)world, posNode.getPos());
            }
            if (!wasReady || !hasInternalConnection) {
                try {
                    GridHelper.createGridConnection((IGridNode)mainNode.getNode(), (IGridNode)node.mainNode.getNode());
                }
                catch (FailedConnectionException e) {
                    node.connections.clear();
                    node.updateNode();
                    world.method_8524(posNode.getPos());
                    world.method_14178().method_14128(posNode.getPos());
                    continue;
                }
            }
            HashSet<class_2350> failedConnections = new HashSet<class_2350>();
            for (class_2350 missingConnection : Sets.difference(node.connections, (Set)node.mainNode.getNode().getConnectedSides())) {
                IGridNode otherNode = GridHelper.getExposedNode((class_1937)world, (class_2338)posNode.getPos().method_10093(missingConnection), (class_2350)missingConnection.method_10153());
                if (otherNode == null) continue;
                if (!MENetworkNode.areColorsCompatible(this.color, otherNode.getGridColor())) {
                    failedConnections.add(missingConnection);
                    continue;
                }
                try {
                    GridConnection.create((IGridNode)node.mainNode.getNode(), (IGridNode)otherNode, (class_2350)missingConnection);
                }
                catch (FailedConnectionException e) {
                    failedConnections.add(missingConnection);
                }
            }
            node.connections.removeAll(failedConnections);
            node.updateNode();
            world.method_8524(posNode.getPos());
            world.method_14178().method_14128(posNode.getPos());
        }
    }

    @Override
    public PipeNetworkData merge(PipeNetwork other) {
        throw new UnsupportedOperationException("Unreachable!");
    }
}

