/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.abstraction;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.util.Rectangle;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class ViewerCategory<D> {
    public final Class<D> dataClass;
    public final class_2960 id;
    public final class_2561 title;
    public final Icon icon;
    public final int width;
    public final int height;

    protected ViewerCategory(Class<D> dataClass, class_2960 id, class_2561 title, class_1799 icon, int width, int height) {
        this(dataClass, id, title, new Icon.Stack(icon), width, height);
    }

    protected ViewerCategory(Class<D> dataClass, class_2960 id, class_2561 title, Icon icon, int width, int height) {
        this.dataClass = dataClass;
        this.id = id;
        this.title = title;
        this.icon = icon;
        this.width = width;
        this.height = height;
    }

    public abstract void buildWorkstations(WorkstationConsumer var1);

    public abstract void buildRecipes(class_1863 var1, Consumer<D> var2);

    public abstract void buildLayout(D var1, LayoutBuilder var2);

    public abstract void buildWidgets(D var1, WidgetList var2);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Environment(value=EnvType.CLIENT)
    public static interface Icon {

        @Environment(value=EnvType.CLIENT)
        public record Texture(class_2960 loc, int u, int v) implements Icon
        {
        }

        @Environment(value=EnvType.CLIENT)
        public record Stack(class_1799 stack) implements Icon
        {
        }
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface DrawableWidget {
        public void draw(class_4587 var1);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum TextAlign {
        LEFT,
        CENTER,
        RIGHT;

    }

    @Environment(value=EnvType.CLIENT)
    public static interface WidgetList {
        public void text(class_2561 var1, float var2, float var3, TextAlign var4, boolean var5, boolean var6, @Nullable class_2561 var7);

        default public void secondaryText(class_2561 text, float x, float y) {
            this.text(text, x, y, TextAlign.LEFT, false, true, null);
        }

        public void arrow(int var1, int var2);

        public void texture(class_2960 var1, int var2, int var3, int var4, int var5, int var6, int var7);

        default public void rectangle(Rectangle rectangle, int fillColor) {
            this.drawable(s -> class_332.method_25294((class_4587)s, (int)rectangle.x(), (int)rectangle.y(), (int)(rectangle.x() + rectangle.w()), (int)(rectangle.y() + rectangle.h()), (int)fillColor));
        }

        public void drawable(DrawableWidget var1);

        public void item(double var1, double var3, double var5, double var7, class_1935 var9);

        public void tooltip(int var1, int var2, int var3, int var4, List<class_2561> var5);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface SlotBuilder {
        public SlotBuilder variant(TransferVariant<?> var1);

        public SlotBuilder fluid(FluidVariant var1, long var2, float var4);

        default public SlotBuilder item(class_1799 stack) {
            return this.item(stack, 1.0f);
        }

        public SlotBuilder item(class_1799 var1, float var2);

        public SlotBuilder ingredient(class_1856 var1, long var2, float var4);

        public SlotBuilder removeBackground();

        public SlotBuilder markCatalyst();
    }

    @Environment(value=EnvType.CLIENT)
    public static interface LayoutBuilder {
        public SlotBuilder inputSlot(int var1, int var2);

        public SlotBuilder outputSlot(int var1, int var2);

        public void invisibleOutput(class_1799 var1);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface WorkstationConsumer {
        public void accept(class_1935 ... var1);

        default public void accept(String ... itemPath) {
            for (String item : itemPath) {
                this.accept((class_1935)class_2378.field_11142.method_10223((class_2960)new MIIdentifier(item)));
            }
        }
    }
}

