/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.jei;

import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.compat.viewer.impl.MachineScreenPredicateTest;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.gui.MachineMenuClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.util.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_3611;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
record MachineGuiContainerHandler(Supplier<IJeiRuntime> jeiRuntime) implements IGuiContainerHandler<MachineScreen>
{
    public List<class_768> getGuiExtraAreas(MachineScreen screen) {
        return screen.getExtraBoxes().stream().map(r -> new class_768(r.x(), r.y(), r.w(), r.h())).toList();
    }

    public Collection<IGuiClickableArea> getGuiClickableAreas(MachineScreen screen, double guiMouseX, double guiMouseY) {
        MachineMenuClient screenHandler = (MachineMenuClient)screen.method_17577();
        String blockId = screenHandler.guiParams.blockId;
        List categories = ReiMachineRecipes.machineToClickAreaCategory.getOrDefault(blockId, Collections.emptyList());
        final Rectangle rectangle = ReiMachineRecipes.machineToClickArea.get(blockId);
        if (categories.size() > 0 && rectangle != null && MachineGuiContainerHandler.contains(rectangle, guiMouseX, guiMouseY)) {
            boolean foundSome = false;
            final ArrayList<RecipeType> result = new ArrayList<RecipeType>();
            for (ReiMachineRecipes.ClickAreaCategory cac : categories) {
                IRecipeManager recipeManager;
                RecipeType recipeType;
                if (!MachineScreenPredicateTest.test(cac.predicate, screen) || (recipeType = (RecipeType)(recipeManager = this.jeiRuntime.get().getRecipeManager()).getRecipeType(cac.category).orElse(null)) == null || !recipeManager.createRecipeLookup(recipeType).get().anyMatch(t -> true)) continue;
                result.add(recipeType);
                foundSome = true;
            }
            if (foundSome) {
                return List.of(new IGuiClickableArea(){

                    public class_768 getArea() {
                        return new class_768(rectangle.x(), rectangle.y(), rectangle.w(), rectangle.h());
                    }

                    public void onClick(IFocusFactory focusFactory, IRecipesGui recipesGui) {
                        recipesGui.showTypes((List)result);
                    }
                });
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    public Object getIngredientUnderMouse(MachineScreen screen, double mouseX, double mouseY) {
        ConfigurableItemStack stack;
        class_1735 slot = screen.getFocusedSlot();
        if (slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot) {
            class_3611 fluid;
            IPlatformFluidHelper fluidHelper = this.jeiRuntime.get().getJeiHelpers().getPlatformFluidHelper();
            ConfigurableFluidStack stack2 = ((ConfigurableFluidStack.ConfigurableFluidSlot)slot).getConfStack();
            if (stack2.getAmount() > 0L) {
                class_3611 fluid2 = ((FluidVariant)stack2.getResource()).getFluid();
                if (fluid2 != null) {
                    return fluidHelper.create(fluid2, 1L);
                }
            } else if (stack2.getLockedInstance() != null && (fluid = (class_3611)stack2.getLockedInstance()) != null) {
                return fluidHelper.create(fluid, 1L);
            }
        } else if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot && (stack = ((ConfigurableItemStack.ConfigurableItemSlot)slot).getConfStack()).getLockedInstance() != null) {
            return ((class_1792)stack.getLockedInstance()).method_7854();
        }
        return null;
    }

    private static boolean contains(Rectangle rectangle, double x, double y) {
        return (double)rectangle.x() <= x && x <= (double)(rectangle.x() + rectangle.w()) && (double)rectangle.y() <= y && y <= (double)(rectangle.y() + rectangle.h());
    }
}

