/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.usage;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.blocks.forgehammer.ForgeHammerScreen;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.items.ForgeTool;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import java.util.Comparator;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class ForgeHammerCategory
extends ViewerCategory<MachineRecipe> {
    public static final class_2960 ID = new MIIdentifier("forge_hammer");
    private final int startPointX;
    private final int startPointY;

    protected ForgeHammerCategory() {
        super(MachineRecipe.class, ID, (class_2561)MIBlock.FORGE_HAMMER.asBlock().method_9518(), MIBlock.FORGE_HAMMER.method_8389().method_7854(), 150, 40);
        this.startPointX = this.width / 2 - 25;
        this.startPointY = this.height / 2 - 18;
    }

    @Override
    public void buildWorkstations(ViewerCategory.WorkstationConsumer consumer) {
        consumer.accept(MIBlock.FORGE_HAMMER);
    }

    @Override
    public void buildRecipes(class_1863 recipeManager, Consumer<MachineRecipe> consumer) {
        recipeManager.method_30027((class_3956)MIMachineRecipeTypes.FORGE_HAMMER).stream().sorted(Comparator.comparing(MachineRecipe::method_8114)).forEach(consumer);
    }

    @Override
    public void buildLayout(MachineRecipe recipe, ViewerCategory.LayoutBuilder builder) {
        MachineRecipe.ItemInput input = recipe.itemInputs.get(0);
        MachineRecipe.ItemOutput output = recipe.itemOutputs.get(0);
        builder.inputSlot(this.startPointX + 5, this.startPointY + 6).ingredient(input.ingredient, input.amount, 1.0f);
        if (recipe.eu > 0) {
            builder.inputSlot(this.startPointX - 23, this.startPointY + 6).ingredient(class_1856.method_8106(ForgeTool.TAG), 1L, 1.0f).removeBackground().markCatalyst();
        }
        builder.outputSlot(this.startPointX + 62, this.startPointY + 6).item(output.getStack());
    }

    @Override
    public void buildWidgets(MachineRecipe recipe, ViewerCategory.WidgetList widgets) {
        widgets.arrow(this.startPointX + 27, this.startPointY + 4);
        widgets.texture(ForgeHammerScreen.FORGE_HAMMER_GUI, this.startPointX - 24, this.startPointY + 5, 7, 32, 18, 18);
        class_5250 text = recipe.eu > 0 ? MIText.DurabilityCost.text(recipe.eu) : MIText.NoToolRequired.text();
        widgets.secondaryText((class_2561)text, this.startPointX - 24, 28.0f);
    }
}

