/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.waila.server;

import aztech.modern_industrialization.compat.waila.holder.CrafterComponentHolder;
import aztech.modern_industrialization.compat.waila.holder.EnergyComponentHolder;
import aztech.modern_industrialization.compat.waila.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.compat.waila.holder.FluidStorageComponentHolder;
import aztech.modern_industrialization.compat.waila.holder.MultiblockInventoryComponentHolder;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.FluidStorageComponent;
import aztech.modern_industrialization.machines.components.MultiblockInventoryComponent;
import com.google.common.primitives.Ints;
import java.util.List;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.data.EnergyData;
import mcp.mobius.waila.api.data.FluidData;
import mcp.mobius.waila.api.data.ItemData;
import mcp.mobius.waila.api.data.ProgressData;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;

public class MachineComponentProvider
implements IDataProvider<MachineBlockEntity> {
    public void appendData(IDataWriter data, IServerAccessor<MachineBlockEntity> accessor, IPluginConfig config) {
        MachineBlockEntity machine = (MachineBlockEntity)accessor.getTarget();
        data.add(EnergyData.class, res -> {
            if (machine instanceof EnergyListComponentHolder) {
                EnergyListComponentHolder holder = (EnergyListComponentHolder)((Object)machine);
                List<EnergyComponent> components = holder.getEnergyComponents();
                if (!components.isEmpty()) {
                    long stored = 0L;
                    long capacity = 0L;
                    for (EnergyComponent component : components) {
                        stored += component.getEu();
                        capacity += component.getCapacity();
                    }
                    res.add((IData)EnergyData.of((double)stored, (double)capacity));
                }
            } else if (machine instanceof EnergyComponentHolder) {
                EnergyComponentHolder holder = (EnergyComponentHolder)((Object)machine);
                EnergyComponent component = holder.getEnergyComponent();
                res.add((IData)EnergyData.of((double)component.getEu(), (double)component.getCapacity()));
            }
            res.block();
        });
        data.add(FluidData.class, res -> {
            if (machine instanceof MultiblockInventoryComponentHolder) {
                MultiblockInventoryComponentHolder holder = (MultiblockInventoryComponentHolder)((Object)machine);
                MultiblockInventoryComponent component = holder.getMultiblockInventoryComponent();
                List<ConfigurableFluidStack> inputs = component.getFluidInputs();
                List<ConfigurableFluidStack> outputs = component.getFluidOutputs();
                if (!inputs.isEmpty() || !outputs.isEmpty()) {
                    FluidData fluidData = FluidData.of((FluidData.Unit)FluidData.Unit.DROPLETS, (int)(inputs.size() + outputs.size()));
                    this.addFluids(fluidData, inputs);
                    this.addFluids(fluidData, outputs);
                    res.add((IData)fluidData);
                }
            } else if (machine instanceof FluidStorageComponentHolder) {
                FluidStorageComponentHolder holder = (FluidStorageComponentHolder)((Object)machine);
                FluidStorageComponent component = holder.getFluidStorageComponent();
                if (component != null) {
                    FluidVariant fluid = component.getFluid();
                    res.add((IData)FluidData.of((FluidData.Unit)FluidData.Unit.DROPLETS).add(fluid.getFluid(), fluid.getNbt(), (double)component.getAmount(), (double)component.getCapacity()));
                }
            } else {
                List<ConfigurableFluidStack> stacks = machine.getInventory().getFluidStacks();
                FluidData fluidData = FluidData.of((FluidData.Unit)FluidData.Unit.DROPLETS, (int)stacks.size());
                this.addFluids(fluidData, stacks);
                res.add((IData)fluidData);
            }
            res.block();
        });
        data.add(ItemData.class, res -> {
            if (machine instanceof MultiblockInventoryComponentHolder) {
                MultiblockInventoryComponentHolder holder = (MultiblockInventoryComponentHolder)((Object)machine);
                MultiblockInventoryComponent component = holder.getMultiblockInventoryComponent();
                List<ConfigurableItemStack> inputs = component.getItemInputs();
                List<ConfigurableItemStack> outputs = component.getItemOutputs();
                if (!inputs.isEmpty() || !outputs.isEmpty()) {
                    ItemData itemData = ItemData.of((IPluginConfig)config);
                    this.addItems(itemData, inputs);
                    this.addItems(itemData, outputs);
                    res.add((IData)itemData);
                }
            } else {
                ItemData itemData = ItemData.of((IPluginConfig)config);
                this.addItems(itemData, machine.getInventory().getItemStacks());
                res.add((IData)itemData);
            }
            res.block();
        });
        data.add(ProgressData.class, res -> {
            CrafterComponentHolder holder;
            CrafterComponent component;
            float progress;
            if (machine instanceof CrafterComponentHolder && (progress = (component = (holder = (CrafterComponentHolder)((Object)machine)).getCrafterComponent()).getProgress()) > 0.0f) {
                CrafterComponent.Inventory inventory = component.getInventory();
                ProgressData progressData = ProgressData.ratio((float)progress);
                for (ConfigurableItemStack stack : inventory.getItemInputs()) {
                    progressData.input(this.toStack(stack));
                }
                for (ConfigurableItemStack stack : inventory.getItemOutputs()) {
                    progressData.output(this.toStack(stack));
                }
                res.add((IData)progressData);
            }
            res.block();
        });
    }

    private void addFluids(FluidData data, List<ConfigurableFluidStack> stacks) {
        for (ConfigurableFluidStack stack : stacks) {
            data.add(((FluidVariant)stack.getResource()).getFluid(), ((FluidVariant)stack.getResource()).getNbt(), (double)stack.getAmount(), (double)stack.getCapacity());
        }
    }

    private void addItems(ItemData data, List<ConfigurableItemStack> stacks) {
        data.ensureSpace(stacks.size());
        for (ConfigurableItemStack stack : stacks) {
            data.add(this.toStack(stack));
        }
    }

    private class_1799 toStack(ConfigurableItemStack stack) {
        return ((ItemVariant)stack.getResource()).toStack(Ints.saturatedCast((long)stack.getAmount()));
    }
}

