/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.recipe;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.compat.ae2.AECompatCondition;
import aztech.modern_industrialization.datagen.recipe.MIRecipesProvider;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.materials.MIMaterials;
import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.MaterialRegistry;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.recipe.json.MIRecipeJson;
import aztech.modern_industrialization.recipe.json.RecipeJson;
import aztech.modern_industrialization.recipe.json.ShapedRecipeJson;
import aztech.modern_industrialization.recipe.json.compat.IRCompressRecipeJson;
import aztech.modern_industrialization.recipe.json.compat.TRCompressorRecipeJson;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.minecraft.class_1767;
import net.minecraft.class_2444;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class CompatRecipesProvider
extends MIRecipesProvider {
    private Consumer<class_2444> consumer;
    private String currentCompatModid;
    private ConditionJsonProvider[] conditions = null;

    public CompatRecipesProvider(FabricDataGenerator dataGenerator) {
        super(dataGenerator);
    }

    protected void generateRecipes(Consumer<class_2444> consumer) {
        this.consumer = consumer;
        this.startCompat("techreborn");
        this.generateTrCompat();
        this.startCompat("ae2");
        this.generateAe2Compat();
        this.startCompat("indrev");
        this.generateIndrevCompat();
    }

    private void startCompat(String modid) {
        this.currentCompatModid = modid;
        this.conditions = new ConditionJsonProvider[]{DefaultResourceConditions.allModsLoaded((String[])new String[]{modid})};
    }

    private void generateTrCompat() {
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:advanced_alloy_ingot", "techreborn:advanced_alloy_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "#c:brass_ingots", "techreborn:brass_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:carbon_mesh", "techreborn:carbon_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:lazurite_dust", "techreborn:lazurite_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "minecraft:obsidian", "techreborn:obsidian_plate", 9);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:obsidian_dust", "techreborn:obsidian_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "#c:peridot_dusts", "techreborn:peridot_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:plantball", "techreborn:compressed_plantball", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "minecraft:prismarine_crystals", "minecraft:prismarine_shard", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:red_garnet_dust", "techreborn:red_garnet_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "minecraft:redstone_block", "techreborn:redstone_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "#c:ruby_dusts", "techreborn:ruby_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "#c:sapphire_dusts", "techreborn:sapphire_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:tungstensteel_ingot", "techreborn:tungstensteel_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "#minecraft:planks", "techreborn:wood_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:yellow_garnet_dust", "techreborn:yellow_garnet_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "#c:zinc_ingots", "techreborn:zinc_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:refined_iron_ingot", "techreborn:refined_iron_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:andesite", "techreborn:andesite_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:basalt", "techreborn:basalt_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:brass_ingots", "techreborn:brass_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:charcoal", "techreborn:charcoal_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:cinnabar_ores", "techreborn:cinnabar_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:clay_ball", "techreborn:clay_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:diorite", "techreborn:diorite_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:ender_eye", "techreborn:ender_eye_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:ender_pearl", "techreborn:ender_pearl_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:end_stone", "techreborn:endstone_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:flint", "techreborn:flint_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:galena_ores", "techreborn:galena_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:granite", "techreborn:granite_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:netherrack", "techreborn:netherrack_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "techreborn:peridot_gem", "techreborn:peridot_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:peridot_ores", "techreborn:peridot_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:pyrite_ores", "techreborn:pyrite_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "techreborn:red_garnet_gem", "techreborn:red_garnet_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "techreborn:ruby_gem", "modern_industrialization:ruby_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:ruby_ores", "modern_industrialization:ruby_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "techreborn:sapphire_gem", "techreborn:sapphire_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:sapphire_ores", "techreborn:sapphire_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:sodalite_ores", "techreborn:sodalite_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "techreborn:yellow_garnet_gem", "techreborn:yellow_garnet_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:zinc_ingots", "techreborn:zinc_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:silver_ores", "techreborn:raw_silver", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:sphalerite_ores", "techreborn:sphalerite_dust", 2);
        for (Material material : MaterialRegistry.getMaterials().values()) {
            if (!material.getParts().containsKey(MIParts.CURVED_PLATE.key())) continue;
            String plate = material.name;
            this.addCompatRecipe("%s_curved_plate".formatted(plate), new TRCompressorRecipeJson("c:%s_plates".formatted(plate), "modern_industrialization:%s_curved_plate".formatted(plate)));
        }
        List<Material> plateCompatMaterials = List.of(MIMaterials.ANNEALED_COPPER, MIMaterials.BATTERY_ALLOY, MIMaterials.BERYLLIUM, MIMaterials.BLASTPROOF_ALLOY, MIMaterials.CADMIUM, MIMaterials.CUPRONICKEL, MIMaterials.KANTHAL, MIMaterials.SILICON, MIMaterials.STAINLESS_STEEL, MIMaterials.SUPERCONDUCTOR);
        for (Material material : plateCompatMaterials) {
            String tag = material.getPart(MIParts.INGOT).getTaggedItemId();
            Preconditions.checkArgument((boolean)tag.startsWith("#"));
            tag = tag.substring(1);
            this.addCompatRecipe(material.name + "_plate", new TRCompressorRecipeJson(tag, material.getPart(MIParts.PLATE).getItemId()).scaleTime(material.get(MaterialProperty.HARDNESS)));
        }
    }

    private void generateAe2Compat() {
        this.addMiRecipe(MIMachineRecipeTypes.ELECTROLYZER, "ae2:certus_quartz_crystal", "ae2:charged_certus_quartz_crystal", 1, 8, 60);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:certus_quartz", "ae2:certus_quartz_dust", 1, 2, 100);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:ender_pearl", "ae2:ender_dust", 1, 2, 100);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "ae2:fluix_crystal", "ae2:fluix_dust", 1, 2, 100);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "ae2:sky_stone_block", "ae2:sky_dust", 1, 2, 100);
        this.addCompatRecipe("mixer/fluix", (RecipeJson)((MIRecipeJson)((MIRecipeJson)((MIRecipeJson)MIRecipeJson.create(MIMachineRecipeTypes.MIXER, 8, 100).addItemInput("minecraft:quartz", 1).addItemInput("ae2:charged_certus_quartz_crystal", 1)).addItemInput("minecraft:redstone", 1)).addFluidInput((class_3611)class_3612.field_15910, 1000, 0.0)).addItemOutput("ae2:fluix_crystal", 2));
        for (Map.Entry<String, String> entry : Map.of("calculation", "ae2:certus_quartz_crystal", "engineering", "#c:diamonds", "logic", "#c:gold_ingots").entrySet()) {
            String type = entry.getKey();
            String ingredient = entry.getValue();
            this.addCompatRecipe("printed_" + type + "_processor", (RecipeJson)((MIRecipeJson)MIRecipeJson.create(MIMachineRecipeTypes.PACKER, 8, 200).addItemInput(ingredient, 1).addItemInput("ae2:" + type + "_processor_press", 1, 0.0)).addItemOutput("ae2:printed_" + type + "_processor", 1));
            this.addCompatRecipe(type + "_processor", (RecipeJson)((MIRecipeJson)((MIRecipeJson)MIRecipeJson.create(MIMachineRecipeTypes.ASSEMBLER, 8, 200).addItemInput("ae2:printed_" + type + "_processor", 1).addItemInput("ae2:printed_silicon", 1)).addFluidInput(MIFluids.MOLTEN_REDSTONE, 100)).addItemOutput("ae2:" + type + "_processor", 1));
        }
        this.addCompatRecipe("printed_silicon", (RecipeJson)((MIRecipeJson)MIRecipeJson.create(MIMachineRecipeTypes.PACKER, 8, 200).addItemInput("#c:silicon", 1).addItemInput("ae2:silicon_press", 1, 0.0)).addItemOutput("ae2:printed_silicon", 1));
        this.addCompatRecipe("printed_silicon_from_ingot", (RecipeJson)((MIRecipeJson)MIRecipeJson.create(MIMachineRecipeTypes.PACKER, 8, 200).addItemInput(MIMaterials.SILICON.getPart(MIParts.INGOT), 1).addItemInput("ae2:silicon_press", 1, 0.0)).addItemOutput("ae2:printed_silicon", 1));
        this.conditions = new ConditionJsonProvider[]{AECompatCondition.PROVIDER};
        for (class_1767 color : class_1767.values()) {
            ShapedRecipeJson meWiresDirect = new ShapedRecipeJson("modern_industrialization:" + color.method_7792() + "_me_wire", 16, "qCq", "GdG", "qCq").addInput('C', "modern_industrialization:bronze_curved_plate").addInput('G', "#ae2:glass_cable").addInput('d', "#c:" + color.method_7792() + "_dyes").addInput('q', "ae2:quartz_fiber");
            this.addCompatRecipe("dyes/" + color.method_7792() + "/craft/me_wire_direct", meWiresDirect);
            this.addCompatRecipe("dyes/" + color.method_7792() + "/assembler/me_wire_direct", meWiresDirect.exportToAssembler());
            ShapedRecipeJson eightMeWires = new ShapedRecipeJson("modern_industrialization:" + color.method_7792() + "_me_wire", 8, "ppp", "pdp", "ppp").addInput('d', "#c:" + color.method_7792() + "_dyes").addInput('p', "#modern_industrialization:me_wires");
            this.addCompatRecipe("dyes/" + color.method_7792() + "/craft/me_wire_8", eightMeWires);
            this.addCompatRecipe("dyes/" + color.method_7792() + "/mixer/me_wire_8", eightMeWires.exportToMachine(MIMachineRecipeTypes.MIXER, 2, 100, 1));
            this.addCompatRecipe("dyes/" + color.method_7792() + "/craft/me_wire_1", new ShapedRecipeJson("modern_industrialization:" + color.method_7792() + "_me_wire", 1, "pd").addInput('d', "#c:" + color.method_7792() + "_dyes").addInput('p', "#modern_industrialization:me_wires"));
        }
        this.addCompatRecipe("dyes/decolor/craft/me_wire_8", new ShapedRecipeJson("modern_industrialization:me_wire", 8, "ppp", "pbp", "ppp").addInput('b', "minecraft:water_bucket").addInput('p', "#modern_industrialization:me_wires"));
        this.addCompatRecipe("dyes/decolor/craft/me_wire_1", new ShapedRecipeJson("modern_industrialization:me_wire", 1, "pb").addInput('b', "minecraft:water_bucket").addInput('p', "#modern_industrialization:me_wires"));
        this.addCompatRecipe("dyes/decolor/mixer/me_wire", (RecipeJson)((MIRecipeJson)MIRecipeJson.create(MIMachineRecipeTypes.MIXER, 2, 100).addItemInput("#modern_industrialization:me_wires", 1).addFluidInput((class_3611)class_3612.field_15910, 125)).addItemOutput("modern_industrialization:me_wire", 1));
        ShapedRecipeJson meWiresDirect = new ShapedRecipeJson("modern_industrialization:me_wire", 16, "qCq", "G G", "qCq").addInput('C', "modern_industrialization:bronze_curved_plate").addInput('G', "#ae2:glass_cable").addInput('q', "ae2:quartz_fiber");
        this.addCompatRecipe("craft/me_wire_direct", meWiresDirect);
        this.addCompatRecipe("assembler/me_wire_direct", meWiresDirect.exportToAssembler());
    }

    private void generateIndrevCompat() {
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "indrev:nikolite_ore", "indrev:nikolite_dust", 7);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "indrev:deepslate_nikolite_ore", "indrev:nikolite_dust", 7);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:silver_ores", "indrev:raw_silver", 2);
        this.addCompatRecipe("quarry_nikolite", (RecipeJson)MIRecipeJson.create(MIMachineRecipeTypes.QUARRY, 16, 600).addItemInput("indrev:cable_mk1", 1, 0.6).addItemOutput("indrev:nikolite_ore", 6, 0.03));
        for (Material material : MaterialRegistry.getMaterials().values()) {
            if (!material.getParts().containsKey(MIParts.CURVED_PLATE.key()) || material.name.equals("tin")) continue;
            String plate = material.name;
            this.addCompatRecipe("%s_curved_plate".formatted(plate), new IRCompressRecipeJson("c:%s_plates".formatted(plate), "modern_industrialization:%s_curved_plate".formatted(plate)));
        }
    }

    private void addMiRecipe(MachineRecipeType machine, String input, String output, int outputAmount) {
        this.addMiRecipe(machine, input, output, outputAmount, 2, 200);
    }

    private void addMiRecipe(MachineRecipeType machine, String input, String output, int outputAmount, int eu, int duration) {
        String id = "%s/%s_to_%s".formatted(machine.getPath(), input.replace('#', '_').replace(':', '_'), output.replace(':', '_'));
        this.addCompatRecipe(id, (RecipeJson)MIRecipeJson.create(machine, eu, duration).addItemInput(input, 1).addItemOutput(output, outputAmount));
    }

    private void addCompatRecipe(String id, RecipeJson recipeJson) {
        id = "compat/%s/%s".formatted(this.currentCompatModid, id);
        recipeJson.offerTo(this.withConditions(this.consumer, this.conditions), id);
    }
}

