/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.armor;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.items.armor.GraviChestPlateItem;
import aztech.modern_industrialization.items.armor.QuantumArmorItem;
import io.github.ladysnake.pal.AbilitySource;
import io.github.ladysnake.pal.Pal;
import io.github.ladysnake.pal.VanillaAbilities;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class MIArmorEffects {
    public static final AbilitySource SRC = Pal.getAbilitySource((class_2960)new MIIdentifier("modernindustrialization"));

    private MIArmorEffects() {
    }

    public static boolean quantumArmorPreventsDamage(class_1309 entity) {
        int parts = 0;
        for (QuantumArmorItem item : QuantumArmorItem.ITEMS) {
            if (entity.method_6118(item.method_7685()).method_7909() != item) continue;
            ++parts;
        }
        return ThreadLocalRandom.current().nextDouble() < (double)parts / 4.0;
    }

    public static boolean allowFlight(class_1657 player) {
        GraviChestPlateItem gsp;
        class_1799 chest = player.method_6118(class_1304.field_6174);
        class_1792 class_17922 = chest.method_7909();
        if (class_17922 instanceof GraviChestPlateItem && (gsp = (GraviChestPlateItem)class_17922).isActivated(chest) && gsp.getEnergy(chest) > 0L) {
            return true;
        }
        return chest.method_7909() == MIItem.QUANTUM_CHESTPLATE.method_8389();
    }

    public static boolean canTankFlyIntoWall(class_1799 helmet) {
        return helmet.method_7909() == MIItem.RUBBER_HELMET.method_8389() || helmet.method_7909() == MIItem.QUANTUM_HELMET.method_8389();
    }

    public static boolean canTankFall(class_1799 boots) {
        return boots.method_7909() == MIItem.RUBBER_BOOTS.method_8389() || boots.method_7909() == MIItem.QUANTUM_BOOTS.method_8389();
    }

    public static void init() {
        ServerTickEvents.START_WORLD_TICK.register(world -> {
            for (class_3222 player : world.method_18456()) {
                if (MIArmorEffects.allowFlight((class_1657)player)) {
                    SRC.grantTo((class_1657)player, VanillaAbilities.ALLOW_FLYING);
                    continue;
                }
                SRC.revokeFrom((class_1657)player, VanillaAbilities.ALLOW_FLYING);
            }
        });
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            class_1799 head;
            if (MIArmorEffects.quantumArmorPreventsDamage(entity)) {
                return false;
            }
            class_1799 tankingStack = null;
            class_1304 es = null;
            if (source == class_1282.field_5843) {
                es = class_1304.field_6169;
                head = entity.method_6118(es);
                if (MIArmorEffects.canTankFlyIntoWall(head)) {
                    tankingStack = head;
                }
            } else if (source == class_1282.field_5868 && MIArmorEffects.canTankFall(head = entity.method_6118(es = class_1304.field_6166))) {
                tankingStack = head;
            }
            if (tankingStack != null) {
                int intAmount = (int)Math.ceil(amount);
                class_1304 equipmentSlot = es;
                tankingStack.method_7956(intAmount, entity, p -> entity.method_20235(equipmentSlot));
                return false;
            }
            return true;
        });
    }
}

