/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.FluidFuelRegistry;
import aztech.modern_industrialization.definition.FluidDefinition;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.util.ItemStackHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.impl.content.registry.FuelRegistryImpl;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;

public class FluidItemConsumerComponent
implements IComponent.ServerOnly {
    protected long euBuffer = 0L;
    public final long maxEuProduction;
    public final EUProductionMap<class_1792> itemEUProductionMap;
    public final EUProductionMap<class_3611> fluidEUProductionMap;

    public FluidItemConsumerComponent(long maxEuProduction, EUProductionMap<class_1792> itemEUProductionMap, EUProductionMap<class_3611> fluidEUProductionMap) {
        this.itemEUProductionMap = itemEUProductionMap;
        this.fluidEUProductionMap = fluidEUProductionMap;
        this.maxEuProduction = maxEuProduction;
    }

    public boolean doAllowMoreThanOne() {
        return this.itemEUProductionMap.getNumberOfFuel() == NumberOfFuel.MANY || this.fluidEUProductionMap.getNumberOfFuel() == NumberOfFuel.MANY;
    }

    public static FluidItemConsumerComponent ofSingleFluid(long maxEuProduction, FluidDefinition acceptedFluid, long fluidEUperMb) {
        return FluidItemConsumerComponent.ofFluid(maxEuProduction, new EuProductionMapBuilder(class_2378.field_11154).add(acceptedFluid.getId(), fluidEUperMb).build());
    }

    public static FluidItemConsumerComponent ofFluidFuels(long maxEuProduction) {
        return new FluidItemConsumerComponent(maxEuProduction, EUProductionMap.empty(), FluidItemConsumerComponent.fluidFuels());
    }

    public static FluidItemConsumerComponent ofFluid(long maxEuProduction, EUProductionMap<class_3611> fluidEUProductionMap) {
        return new FluidItemConsumerComponent(maxEuProduction, EUProductionMap.empty(), fluidEUProductionMap);
    }

    @Override
    public void writeNbt(class_2487 tag) {
        tag.method_10544("euBuffer", this.euBuffer);
    }

    @Override
    public void readNbt(class_2487 tag) {
        this.euBuffer = tag.method_10537("euBuffer");
    }

    public long getEuProduction(List<ConfigurableFluidStack> fluidInputs, List<ConfigurableItemStack> itemInputs, long maxEnergyInsertable) {
        long maxEuProduced = Math.min(maxEnergyInsertable, this.maxEuProduction);
        if (maxEuProduced == 0L) {
            return 0L;
        }
        if (this.euBuffer >= maxEuProduced) {
            this.euBuffer -= maxEuProduced;
            return maxEuProduced;
        }
        long euProduced = 0L;
        for (ConfigurableFluidStack configurableFluidStack : fluidInputs) {
            class_3611 fluid = ((FluidVariant)configurableFluidStack.getResource()).getFluid();
            if (!this.fluidEUProductionMap.accept(fluid) || configurableFluidStack.getAmount() <= 0L) continue;
            long fuelEu = this.fluidEUProductionMap.getEuProduction(fluid);
            long usedDroplets = Math.min((maxEuProduced - euProduced + fuelEu - 1L) / fuelEu * 81L, configurableFluidStack.getAmount());
            configurableFluidStack.decrement(usedDroplets);
            if ((euProduced += usedDroplets * fuelEu / 81L) < maxEuProduced) continue;
            this.euBuffer += euProduced - maxEuProduced;
            return maxEuProduced;
        }
        for (ConfigurableItemStack configurableItemStack : itemInputs) {
            class_1792 fuel = ((ItemVariant)configurableItemStack.getResource()).getItem();
            if (!this.itemEUProductionMap.accept(fuel) || configurableItemStack.getAmount() <= 0L || this.itemEUProductionMap.isStandardFuels() && !ItemStackHelper.consumeFuel(configurableItemStack, true)) continue;
            long fuelEU = this.itemEUProductionMap.getEuProduction(fuel);
            long usedItem = Math.min((maxEuProduced - euProduced + fuelEU - 1L) / fuelEU, configurableItemStack.getAmount());
            euProduced += fuelEU * usedItem;
            if (this.itemEUProductionMap.isStandardFuels()) {
                ItemStackHelper.consumeFuel(configurableItemStack, false);
            } else {
                configurableItemStack.decrement(usedItem);
            }
            if (euProduced < maxEuProduced) continue;
            this.euBuffer += euProduced - maxEuProduced;
            return maxEuProduced;
        }
        return euProduced;
    }

    public List<class_2561> getTooltips() {
        Object entry;
        List<EUProductionMap.InformationEntry<class_3611>> informationEntries;
        ArrayList<class_2561> returnList = new ArrayList<class_2561>();
        returnList.add((class_2561)new MITooltips.Line(MIText.MaxEuProduction).arg(this.maxEuProduction, MITooltips.EU_PER_TICK_PARSER).build());
        if (this.fluidEUProductionMap.getNumberOfFuel() != NumberOfFuel.NONE) {
            if (this.fluidEUProductionMap.isStandardFuels()) {
                returnList.add((class_2561)new MITooltips.Line(MIText.AcceptAnyFluidFuels).build());
            } else {
                informationEntries = this.fluidEUProductionMap.getAllAcceptedWithEU();
                if (informationEntries.size() == 1) {
                    entry = informationEntries.iterator().next();
                    returnList.add((class_2561)new MITooltips.Line(MIText.AcceptSingleFluid).arg(((EUProductionMap.InformationEntry)entry).variant).arg(((EUProductionMap.InformationEntry)entry).eu, MITooltips.EU_PARSER).build());
                } else if (informationEntries.size() > 1) {
                    returnList.add((class_2561)new MITooltips.Line(MIText.ConsumesTheFollowing).build());
                    for (EUProductionMap.InformationEntry<class_3611> entry2 : informationEntries) {
                        returnList.add((class_2561)new MITooltips.Line(MIText.AcceptFollowingFluidEntry).arg(entry2.variant).arg(entry2.eu, MITooltips.EU_PARSER).build());
                    }
                }
            }
        }
        if (this.itemEUProductionMap.getNumberOfFuel() != NumberOfFuel.NONE) {
            if (this.itemEUProductionMap.isStandardFuels()) {
                returnList.add((class_2561)new MITooltips.Line(MIText.AcceptAnyItemFuels).build());
            } else {
                informationEntries = this.itemEUProductionMap.getAllAcceptedWithEU();
                if (informationEntries.size() == 1) {
                    entry = informationEntries.iterator().next();
                    returnList.add((class_2561)new MITooltips.Line(MIText.AcceptSingleItem).arg(((EUProductionMap.InformationEntry)entry).variant).arg(((EUProductionMap.InformationEntry)entry).eu, MITooltips.EU_PARSER).build());
                } else {
                    returnList.add((class_2561)new MITooltips.Line(MIText.ConsumesTheFollowing).build());
                    for (EUProductionMap.InformationEntry<class_3611> entry2 : informationEntries) {
                        returnList.add((class_2561)new MITooltips.Line(MIText.AcceptFollowingItemEntry).arg(entry2.variant).arg(entry2.eu, MITooltips.EU_PARSER).build());
                    }
                }
            }
        }
        return returnList;
    }

    public static EUProductionMap<class_1792> itemFuels() {
        return new EUProductionMap<class_1792>(){

            @Override
            public long getEuProduction(class_1792 variant) {
                Integer eu = (Integer)FuelRegistryImpl.INSTANCE.get((class_1935)variant);
                return eu == null ? 0L : (long)eu.intValue() * 20L;
            }

            @Override
            public boolean isStandardFuels() {
                return true;
            }

            @Override
            public List<class_1792> getAllAccepted() {
                throw new UnsupportedOperationException("The list of accepted items is not available for standard fuels");
            }
        };
    }

    public static EUProductionMap<class_3611> fluidFuels() {
        return new EUProductionMap<class_3611>(){

            @Override
            public long getEuProduction(class_3611 variant) {
                return FluidFuelRegistry.getEu(variant);
            }

            @Override
            public boolean isStandardFuels() {
                return true;
            }

            @Override
            public List<class_3611> getAllAccepted() {
                throw new UnsupportedOperationException("The list of accepted fluids is not available for fluid fuels");
            }
        };
    }

    public static interface EUProductionMap<T> {
        public long getEuProduction(T var1);

        default public boolean isStandardFuels() {
            return false;
        }

        default public boolean accept(T variant) {
            return this.getEuProduction(variant) != 0L;
        }

        default public NumberOfFuel getNumberOfFuel() {
            if (this.isStandardFuels()) {
                return NumberOfFuel.MANY;
            }
            if (this.getAllAccepted().size() == 1) {
                return NumberOfFuel.SINGLE;
            }
            if (this.getAllAccepted().size() == 0) {
                return NumberOfFuel.NONE;
            }
            return NumberOfFuel.MANY;
        }

        public static <T> EUProductionMap<T> empty() {
            return new EUProductionMap<T>(){

                @Override
                public long getEuProduction(T variant) {
                    return 0L;
                }

                @Override
                public List<T> getAllAccepted() {
                    return List.of();
                }
            };
        }

        public List<T> getAllAccepted();

        default public List<InformationEntry<T>> getAllAcceptedWithEU() {
            return this.getAllAccepted().stream().map(variant -> new InformationEntry<Object>(this.getEuProduction(variant), variant)).sorted(Comparator.comparingLong(InformationEntry::eu)).collect(Collectors.toList());
        }

        public record InformationEntry<T>(long eu, T variant) {
        }
    }

    public static enum NumberOfFuel {
        NONE,
        SINGLE,
        MANY;

    }

    public static class EuProductionMapBuilder<T> {
        private final Map<class_2960, Long> map = new HashMap<class_2960, Long>();
        private final class_2348<T> registryAccess;

        public EuProductionMapBuilder(class_2348<T> registryAccess) {
            this.registryAccess = registryAccess;
        }

        public EuProductionMapBuilder<T> add(class_2960 resourceLocation, long eu) {
            this.map.put(resourceLocation, eu);
            return this;
        }

        public EUProductionMap<T> build() {
            return new EUProductionMap<T>(){

                @Override
                public long getEuProduction(T variant) {
                    return map.getOrDefault(registryAccess.method_10221(variant), 0L);
                }

                @Override
                public List<T> getAllAccepted() {
                    return map.keySet().stream().map(arg_0 -> registryAccess.method_10223(arg_0)).collect(Collectors.toList());
                }
            };
        }
    }
}

