/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5819;

public class OverclockComponent
implements IComponent {
    private final List<Catalyst> catalysts;
    private final NavigableMap<Double, MutableTickCount> tickMap = new TreeMap<Double, MutableTickCount>();

    public OverclockComponent(List<Catalyst> catalysts) {
        this.catalysts = catalysts;
    }

    @Override
    public void writeNbt(class_2487 tag) {
        for (Map.Entry entry : this.tickMap.entrySet()) {
            String multiplierKey = String.format("overclock%.2f", (double)((Double)entry.getKey()));
            tag.method_10569(multiplierKey, ((MutableTickCount)entry.getValue()).value);
        }
    }

    @Override
    public void readNbt(class_2487 tag) {
        for (Catalyst catalyst : this.catalysts) {
            String multiplierKey = String.format("overclock%.2f", catalyst.multiplier);
            if (!tag.method_10545(multiplierKey) || this.tickMap.containsKey(catalyst.multiplier)) continue;
            this.tickMap.put(catalyst.multiplier, new MutableTickCount(tag.method_10550(multiplierKey)));
        }
        if (tag.method_10545("overclockGunpowderTick")) {
            this.tickMap.put(2.0, new MutableTickCount(tag.method_10550("overclockGunpowderTick")));
        }
    }

    public int getTicks() {
        Map.Entry<Double, MutableTickCount> lastEntry = this.tickMap.lastEntry();
        if (lastEntry != null) {
            return lastEntry.getValue().value;
        }
        return 0;
    }

    public class_1269 onUse(MachineBlockEntity be, class_1657 player, class_1268 hand) {
        class_1799 stackInHand = player.method_5998(hand);
        class_2960 resourceInHand = class_2378.field_11142.method_10221((Object)stackInHand.method_7909());
        for (Catalyst catalyst : this.catalysts) {
            if (!resourceInHand.equals((Object)catalyst.resourceLocation) || stackInHand.method_7947() < 1) continue;
            if (!player.method_7337()) {
                stackInHand.method_7934(1);
            }
            if (this.tickMap.containsKey(catalyst.multiplier)) {
                MutableTickCount overclockTicks = (MutableTickCount)this.tickMap.get(catalyst.multiplier);
                overclockTicks.value += catalyst.ticks;
            } else {
                this.tickMap.put(catalyst.multiplier, new MutableTickCount(catalyst.ticks));
            }
            be.method_5431();
            if (!be.method_10997().method_8608()) {
                be.sync();
            }
            return class_1269.method_29236((boolean)be.method_10997().field_9236);
        }
        return class_1269.field_5811;
    }

    public void tick(MachineBlockEntity be) {
        Map.Entry<Double, MutableTickCount> lastEntry = this.tickMap.lastEntry();
        if (lastEntry != null) {
            MutableTickCount overclockTicks = lastEntry.getValue();
            --overclockTicks.value;
            if (overclockTicks.value <= 0) {
                this.tickMap.remove(lastEntry.getKey());
            } else if (be.method_10997().method_8608()) {
                for (int iter = 0; iter < 3; ++iter) {
                    class_5819 random = be.method_10997().method_8409();
                    double d = (double)be.method_11016().method_10263() + 0.5;
                    double e = be.method_11016().method_10264();
                    double f = (double)be.method_11016().method_10260() + 0.5;
                    double i = random.method_43058() * 0.6 - 0.3;
                    double k = random.method_43058() * 0.6 - 0.3;
                    be.method_10997().method_8406((class_2394)class_2398.field_11251, d + i, e + 1.05, f + k, 0.15 * (random.method_43058() - 0.5), 0.15, 0.15 * (random.method_43058() - 0.5));
                }
            }
        }
    }

    public List<class_2561> getTooltips() {
        ArrayList<class_2561> tooltips = new ArrayList<class_2561>();
        for (Catalyst catalyst : this.catalysts) {
            class_1792 catalystItem = (class_1792)class_2378.field_11142.method_10223(catalyst.resourceLocation);
            tooltips.add((class_2561)MITooltips.line(MIText.OverclockMachine).arg(catalystItem, MITooltips.ITEM_PARSER).arg(catalyst.multiplier).arg(catalyst.ticks).build());
        }
        return tooltips;
    }

    public long getRecipeEu(int eu) {
        Map.Entry<Double, MutableTickCount> lastEntry = this.tickMap.lastEntry();
        if (lastEntry != null && lastEntry.getValue().value > 0) {
            return Math.round(lastEntry.getKey() * (double)eu);
        }
        return eu;
    }

    public static List<Catalyst> getDefaultCatalysts() {
        return List.of(new Catalyst(2.0, new class_2960("minecraft:gunpowder"), 2400));
    }

    private static class MutableTickCount {
        public int value;

        public MutableTickCount(int value) {
            this.value = value;
        }
    }

    public record Catalyst(double multiplier, class_2960 resourceLocation, int ticks) {
    }
}

