/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.gui;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.client.screen.MIHandledScreen;
import aztech.modern_industrialization.inventory.BackgroundRenderedSlot;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableInventoryPackets;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.gui.MachineMenuClient;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.Rectangle;
import aztech.modern_industrialization.util.RenderHelper;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class MachineScreen
extends MIHandledScreen<MachineMenuClient>
implements ClientComponentRenderer.ButtonContainer {
    public static final class_2960 SLOT_ATLAS = new MIIdentifier("textures/gui/container/slot_atlas.png");
    public static final class_2960 BACKGROUND = new MIIdentifier("textures/gui/container/background.png");
    private final List<ClientComponentRenderer> renderers = new ArrayList<ClientComponentRenderer>();
    private int nextButtonX;
    private static final int BUTTON_Y = 4;

    public MachineScreen(MachineMenuClient handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        for (GuiComponentClient component : handler.components) {
            this.renderers.add(component.createRenderer(this));
        }
        this.field_2779 = handler.guiParams.backgroundHeight;
        this.field_2792 = handler.guiParams.backgroundWidth;
        this.field_25270 = this.field_2779 - 94;
    }

    public int x() {
        return this.field_2776;
    }

    public int y() {
        return this.field_2800;
    }

    private int buttonX() {
        this.nextButtonX -= 22;
        return this.nextButtonX + 22 + this.field_2776;
    }

    private int buttonY() {
        return 4 + this.field_2800;
    }

    protected void method_25426() {
        super.method_25426();
        this.nextButtonX = 152;
        if (((MachineMenuClient)this.field_2797).guiParams.lockButton) {
            this.addLockButton();
        }
        for (ClientComponentRenderer renderer : this.renderers) {
            renderer.addButtons(this);
        }
    }

    public void blitButton(class_4185 button, class_4587 pose, int baseU, int baseV, int selectedOverlayU, int selectedOverlayV, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)SLOT_ATLAS);
        this.method_25302(pose, button.field_22760, button.field_22761, baseU, baseV, button.method_25368(), button.method_25364());
        if (button.method_25367()) {
            this.method_25302(pose, button.field_22760, button.field_22761, selectedOverlayU, selectedOverlayV, button.method_25368(), button.method_25364());
            button.method_25352(pose, mouseX, mouseY);
        }
    }

    public void blitButton(class_4185 button, class_4587 pose, int u, int v, int mouseX, int mouseY) {
        this.blitButton(button, pose, u, v, 60, 18, mouseX, mouseY);
    }

    public void blitButtonSmall(class_4185 button, class_4587 pose, int u, int v, int mouseX, int mouseY) {
        this.blitButton(button, pose, u, v, 138, 58, mouseX, mouseY);
    }

    public void blitButtonNoHighlight(class_4185 button, class_4587 pose, int u, int v, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)SLOT_ATLAS);
        this.method_25302(pose, button.field_22760, button.field_22761, u, v, button.method_25368(), button.method_25364());
        if (button.method_25367()) {
            button.method_25352(pose, mouseX, mouseY);
        }
    }

    @Override
    public MachineButton addButton(int u, Consumer<Integer> pressAction, Supplier<List<class_2561>> tooltipSupplier, Supplier<Boolean> isPressed) {
        return (MachineButton)this.method_37063((class_364)new MachineButton(this.buttonX(), this.buttonY(), 20, 20, b -> pressAction.accept(((MachineMenuClient)this.field_2797).field_7763), (button, matrices, mouseX, mouseY) -> this.method_30901(matrices, (List)tooltipSupplier.get(), mouseX, mouseY), (screen, button, matrices, mouseX, mouseY, delta) -> this.blitButton(button, matrices, u, (Boolean)isPressed.get() != false ? 38 : 18, mouseX, mouseY), () -> true));
    }

    @Override
    public MachineButton addButton(int posX, int posY, int width, int height, Consumer<Integer> pressAction, Supplier<List<class_2561>> tooltipSupplier, ClientComponentRenderer.CustomButtonRenderer renderer, Supplier<Boolean> isButtonPresent) {
        return (MachineButton)this.method_37063((class_364)new MachineButton(posX + this.field_2776, posY + this.field_2800, width, height, b -> pressAction.accept(((MachineMenuClient)this.field_2797).field_7763), (button, matrices, mouseX, mouseY) -> this.method_30901(matrices, (List)tooltipSupplier.get(), mouseX, mouseY), renderer, isButtonPresent));
    }

    private void addLockButton() {
        this.addButton(40, syncId -> {
            if (MachineScreen.method_25442()) {
                boolean lock = ((MachineMenuClient)this.field_2797).hasUnlockedSlot();
                ((MachineMenuClient)this.field_2797).lockAll(lock);
                class_2540 buf = PacketByteBufs.create();
                buf.writeInt(syncId.intValue());
                buf.writeBoolean(lock);
                ClientPlayNetworking.send((class_2960)ConfigurableInventoryPackets.LOCK_ALL, (class_2540)buf);
            } else {
                boolean newLockingMode;
                ((MachineMenuClient)this.field_2797).lockingMode = newLockingMode = !((MachineMenuClient)this.field_2797).lockingMode;
                class_2540 buf = PacketByteBufs.create();
                buf.writeInt(syncId.intValue());
                buf.writeBoolean(newLockingMode);
                ClientPlayNetworking.send((class_2960)ConfigurableInventoryPackets.SET_LOCKING_MODE, (class_2540)buf);
            }
        }, () -> {
            ArrayList<class_5250> lines = new ArrayList<class_5250>();
            if (((MachineMenuClient)this.field_2797).lockingMode) {
                lines.add(MIText.LockingModeOn.text());
                lines.add(MIText.ClickToDisable.text().method_10862(TextHelper.GRAY_TEXT));
            } else {
                lines.add(MIText.LockingModeOff.text());
                lines.add(MIText.ClickToEnable.text().method_10862(TextHelper.GRAY_TEXT));
            }
            lines.add((((MachineMenuClient)this.field_2797).hasUnlockedSlot() ? MIText.ShiftClickToLockAll : MIText.ShiftClickToUnlockAll).text().method_10862(TextHelper.GRAY_TEXT));
            return lines;
        }, () -> ((MachineMenuClient)this.field_2797).lockingMode);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        for (class_4068 element : this.field_33816) {
            if (!(element instanceof MachineButton)) continue;
            MachineButton machineButton = (MachineButton)element;
            machineButton.field_22764 = machineButton.isPresent.get();
        }
        this.method_25420(matrices);
        RenderSystem.enableBlend();
        this.actualDrawBackground(matrices);
        this.renderConfigurableSlotBackgrounds(matrices);
        this.renderFluidSlots(matrices, mouseX, mouseY);
        this.renderLockedItems();
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.renderConfigurableSlotTooltips(matrices, mouseX, mouseY);
        for (ClientComponentRenderer renderer : this.renderers) {
            renderer.renderTooltip(this, matrices, this.field_2776, this.field_2800, mouseX, mouseY);
        }
    }

    private void actualDrawBackground(class_4587 matrices) {
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND);
        int bw = ((MachineMenuClient)this.field_2797).guiParams.backgroundWidth;
        int bh = ((MachineMenuClient)this.field_2797).guiParams.backgroundHeight;
        this.method_25302(matrices, this.field_2776, this.field_2800 + 4, 0, 256 - bh + 4, bw, bh - 4);
        this.method_25302(matrices, this.field_2776, this.field_2800, 0, 0, bw, 4);
        for (ClientComponentRenderer renderer : this.renderers) {
            renderer.renderBackground((class_332)this, matrices, this.field_2776, this.field_2800);
        }
    }

    private void renderConfigurableSlotBackgrounds(class_4587 matrices) {
        RenderSystem.setShaderTexture((int)0, (class_2960)SLOT_ATLAS);
        for (class_1735 slot : ((MachineMenuClient)this.field_2797).field_7761) {
            if (!(slot instanceof BackgroundRenderedSlot)) continue;
            BackgroundRenderedSlot brs = (BackgroundRenderedSlot)slot;
            int px = this.field_2776 + slot.field_7873 - 1;
            int py = this.field_2800 + slot.field_7872 - 1;
            this.method_25302(matrices, px, py, brs.getBackgroundU(), brs.getBackgroundV(), 18, 18);
        }
    }

    private void renderFluidSlots(class_4587 matrices, int mouseX, int mouseY) {
        for (class_1735 slot : ((MachineMenuClient)this.field_2797).field_7761) {
            FluidVariant renderedKey;
            if (!(slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot)) continue;
            int i = this.field_2776 + slot.field_7873;
            int j = this.field_2800 + slot.field_7872;
            ConfigurableFluidStack stack = ((ConfigurableFluidStack.ConfigurableFluidSlot)slot).getConfStack();
            FluidVariant fluidVariant = renderedKey = stack.getLockedInstance() == null ? (FluidVariant)stack.getResource() : FluidVariant.of((class_3611)((class_3611)stack.getLockedInstance()));
            if (!renderedKey.isBlank()) {
                RenderHelper.drawFluidInGui(matrices, renderedKey, i, j);
            }
            if (!this.method_2378(slot.field_7873, slot.field_7872, 16, 16, mouseX, mouseY) || !slot.method_7682()) continue;
            this.field_2787 = slot;
            RenderSystem.disableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.method_25296(matrices, i, j, i + 16, j + 16, -2130706433, -2130706433);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
        }
    }

    private void renderLockedItems() {
        for (class_1735 slot : ((MachineMenuClient)this.field_2797).field_7761) {
            class_1792 item;
            ConfigurableItemStack.ConfigurableItemSlot itemSlot;
            ConfigurableItemStack itemStack;
            if (!(slot instanceof ConfigurableItemStack.ConfigurableItemSlot) || !(itemStack = (itemSlot = (ConfigurableItemStack.ConfigurableItemSlot)slot).getConfStack()).isPlayerLocked() && !itemStack.isMachineLocked() || !((ItemVariant)itemStack.getResource()).isBlank() || (item = (class_1792)itemStack.getLockedInstance()) == class_1802.field_8162) continue;
            this.renderItemInGui(new class_1799((class_1935)item), slot.field_7873 + this.field_2776, slot.field_7872 + this.field_2800, "0");
        }
    }

    public void renderItemInGui(class_1799 itemStack, int x, int y) {
        this.renderItemInGui(itemStack, x, y, null);
    }

    public void renderItemInGui(class_1799 itemStack, int x, int y, String countLabel) {
        this.method_25304(100);
        this.field_22788.field_4730 = 100.0f;
        RenderSystem.enableDepthTest();
        this.field_22788.method_27951((class_1309)this.field_22787.field_1724, itemStack, x, y, 0);
        this.field_22788.method_4022(this.field_22793, itemStack, x, y, countLabel);
        this.field_22788.field_4730 = 0.0f;
        this.method_25304(0);
    }

    public class_918 getItemRenderer() {
        return this.field_22788;
    }

    private void renderConfigurableSlotTooltips(class_4587 matrices, int mouseX, int mouseY) {
        class_1735 slot = this.field_2787;
        if (slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot) {
            ConfigurableFluidStack stack = ((ConfigurableFluidStack.ConfigurableFluidSlot)slot).getConfStack();
            FluidVariant renderedKey = stack.isPlayerLocked() ? FluidVariant.of((class_3611)((class_3611)stack.getLockedInstance())) : (FluidVariant)stack.getResource();
            ArrayList<class_2561> tooltip = new ArrayList<class_2561>(FluidHelper.getTooltipForFluidStorage(renderedKey, stack.getAmount(), stack.getCapacity(), false));
            if (stack.canPlayerInsert()) {
                if (stack.canPlayerExtract()) {
                    tooltip.add((class_2561)MIText.FluidSlotIO.text().method_10862(TextHelper.GRAY_TEXT));
                } else {
                    tooltip.add((class_2561)MIText.FluidSlotInput.text().method_10862(TextHelper.GRAY_TEXT));
                }
            } else if (stack.canPlayerExtract()) {
                tooltip.add((class_2561)MIText.FluidSlotOutput.text().method_10862(TextHelper.GRAY_TEXT));
            }
            this.method_30901(matrices, tooltip, mouseX, mouseY);
        } else if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot) {
            ConfigurableItemStack.ConfigurableItemSlot confSlot = (ConfigurableItemStack.ConfigurableItemSlot)slot;
            this.renderConfigurableItemStackTooltip(matrices, confSlot.getConfStack(), mouseX, mouseY);
        } else if (slot != null && slot.method_7681()) {
            this.method_25409(matrices, slot.method_7677(), mouseX, mouseY);
        }
    }

    private void renderConfigurableItemStackTooltip(class_4587 matrices, ConfigurableItemStack stack, int mouseX, int mouseY) {
        List<class_5250> textTooltip;
        class_1799 vanillaStack;
        class_1799 class_17992 = stack.isEmpty() ? (stack.getLockedInstance() == null ? class_1799.field_8037 : new class_1799((class_1935)stack.getLockedInstance())) : (vanillaStack = ((ItemVariant)stack.getResource()).toStack((int)stack.getAmount()));
        if (vanillaStack.method_7960()) {
            textTooltip = new ArrayList();
            textTooltip.add(MIText.Empty.text());
        } else {
            textTooltip = this.method_25408(vanillaStack);
        }
        Optional data = vanillaStack.method_32347();
        class_5250 capacityText = class_2561.method_43470((String)String.valueOf(stack.getAdjustedCapacity()));
        if (stack.getAdjustedCapacity() != 64) {
            capacityText.method_10862(TextHelper.YELLOW_BOLD);
        }
        textTooltip.add(MIText.ConfigurableSlotCapacity.text(capacityText).method_10862(TextHelper.GRAY_TEXT));
        this.method_32634(matrices, textTooltip, data, mouseX, mouseY);
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        class_1735 class_17352 = this.field_2787;
        if (class_17352 instanceof ConfigurableItemStack.ConfigurableItemSlot) {
            ConfigurableItemStack.ConfigurableItemSlot confSlot = (ConfigurableItemStack.ConfigurableItemSlot)class_17352;
            ConfigurableItemStack stack = confSlot.getConfStack();
            boolean isIncrease = amount > 0.0;
            boolean isShiftDown = MachineScreen.method_25442();
            stack.adjustCapacity(isIncrease, isShiftDown);
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(((MachineMenuClient)this.field_2797).field_7763);
            buf.method_10804(((MachineMenuClient)this.field_2797).field_7761.indexOf((Object)this.field_2787));
            buf.writeBoolean(isIncrease);
            buf.writeBoolean(isShiftDown);
            ClientPlayNetworking.send((class_2960)ConfigurableInventoryPackets.ADJUST_SLOT_CAPACITY, (class_2540)buf);
            return true;
        }
        return false;
    }

    protected boolean method_2381(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return this.getExtraBoxes().stream().noneMatch(r -> r.contains(mouseX, mouseY)) && super.method_2381(mouseX, mouseY, guiLeft, guiTop, mouseButton);
    }

    public MachineGuiParameters getGuiParams() {
        return ((MachineMenuClient)this.field_2797).getGuiParams();
    }

    @Override
    public class_1735 getFocusedSlot() {
        return this.field_2787;
    }

    public List<Rectangle> getExtraBoxes() {
        ArrayList<Rectangle> list = new ArrayList<Rectangle>();
        for (ClientComponentRenderer renderer : this.renderers) {
            renderer.addExtraBoxes(list, this.field_2776, this.field_2800);
        }
        return list;
    }

    @Environment(value=EnvType.CLIENT)
    public class MachineButton
    extends class_4185 {
        final ClientComponentRenderer.CustomButtonRenderer renderer;
        final Supplier<Boolean> isPresent;

        private MachineButton(int x, int y, int width, int height, class_4185.class_4241 onPress, class_4185.class_5316 tooltipSupplier, ClientComponentRenderer.CustomButtonRenderer renderer, Supplier<Boolean> isPresent) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), onPress, (btn, mat, mouseX, mouseY) -> {
                if (((Boolean)isPresent.get()).booleanValue()) {
                    tooltipSupplier.onTooltip(btn, mat, mouseX, mouseY);
                }
            });
            this.renderer = renderer;
            this.isPresent = isPresent;
        }

        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (this.isPresent.get().booleanValue()) {
                this.renderer.renderButton(MachineScreen.this, this, matrices, mouseX, mouseY, delta);
            }
        }

        public void renderVanilla(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (this.isPresent.get().booleanValue()) {
                super.method_25359(matrices, mouseX, mouseY, delta);
            }
        }
    }
}

