/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.MachinePackets;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.util.TextHelper;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class AutoExtractClient
implements GuiComponentClient {
    final boolean displayAsInsert;
    final boolean hasExtractItems;
    final boolean hasExtractFluids;
    boolean[] extractStatus = new boolean[2];

    public AutoExtractClient(class_2540 buf) {
        this.displayAsInsert = buf.readBoolean();
        this.hasExtractItems = buf.readBoolean();
        this.hasExtractFluids = buf.readBoolean();
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(class_2540 buf) {
        this.extractStatus[0] = buf.readBoolean();
        this.extractStatus[1] = buf.readBoolean();
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    @Environment(value=EnvType.CLIENT)
    private class Renderer
    implements ClientComponentRenderer {
        private Renderer() {
        }

        @Override
        public void addButtons(ClientComponentRenderer.ButtonContainer container) {
            if (AutoExtractClient.this.hasExtractFluids) {
                this.addExtractButton(container, false);
            }
            if (AutoExtractClient.this.hasExtractItems) {
                this.addExtractButton(container, true);
            }
        }

        private void addExtractButton(ClientComponentRenderer.ButtonContainer container, boolean isItem) {
            int u = isItem ? 20 : 0;
            String type = isItem ? "item" : "fluid";
            int index = isItem ? 0 : 1;
            String insertOrExtract = AutoExtractClient.this.displayAsInsert ? "insert" : "extract";
            container.addButton(u, syncId -> {
                boolean newExtract;
                AutoExtractClient.this.extractStatus[index] = newExtract = !AutoExtractClient.this.extractStatus[index];
                class_2540 buf = PacketByteBufs.create();
                buf.writeInt(syncId.intValue());
                buf.writeBoolean(isItem);
                buf.writeBoolean(newExtract);
                ClientPlayNetworking.send((class_2960)MachinePackets.C2S.SET_AUTO_EXTRACT, (class_2540)buf);
            }, () -> {
                ArrayList<class_5250> lines = new ArrayList<class_5250>();
                if (AutoExtractClient.this.extractStatus[index]) {
                    class_5250 component = isItem ? (AutoExtractClient.this.displayAsInsert ? MIText.ItemAutoInsertOn.text() : MIText.ItemAutoExtractOn.text()) : (AutoExtractClient.this.displayAsInsert ? MIText.FluidAutoInsertOn.text() : MIText.FluidAutoExtractOn.text());
                    lines.add(component);
                    lines.add(MIText.ClickToDisable.text().method_10862(TextHelper.GRAY_TEXT));
                } else {
                    class_5250 component = isItem ? (AutoExtractClient.this.displayAsInsert ? MIText.ItemAutoInsertOff.text() : MIText.ItemAutoExtractOff.text()) : (AutoExtractClient.this.displayAsInsert ? MIText.FluidAutoInsertOff.text() : MIText.FluidAutoExtractOff.text());
                    lines.add(component);
                    lines.add(MIText.ClickToEnable.text().method_10862(TextHelper.GRAY_TEXT));
                }
                return lines;
            }, () -> AutoExtractClient.this.extractStatus[index]);
        }

        @Override
        public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
        }
    }
}

