/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes;

import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.api.PipeRenderer;
import aztech.modern_industrialization.pipes.fluid.FluidPipeScreen;
import aztech.modern_industrialization.pipes.impl.ClientPipePackets;
import aztech.modern_industrialization.pipes.impl.PipeBlock;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeColorProvider;
import aztech.modern_industrialization.pipes.impl.PipeMeshCache;
import aztech.modern_industrialization.pipes.impl.PipeModelProvider;
import aztech.modern_industrialization.pipes.impl.PipePackets;
import aztech.modern_industrialization.pipes.impl.PipeVoxelShape;
import aztech.modern_industrialization.pipes.item.ItemPipeScreen;
import aztech.modern_industrialization.util.InGameMouseScrollCallback;
import aztech.modern_industrialization.util.RenderHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.minecraft.class_1058;
import net.minecraft.class_1268;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3929;
import net.minecraft.class_3965;
import net.minecraft.class_4730;

@Environment(value=EnvType.CLIENT)
public class MIPipesClient {
    public static volatile boolean transparentCamouflage = false;
    private static final PipeRenderer.Factory ITEM_RENDERER = MIPipesClient.makeRenderer(Arrays.asList("item", "item_item", "item_in", "item_in_out", "item_out"), false);
    private static final PipeRenderer.Factory FLUID_RENDERER = MIPipesClient.makeRenderer(Arrays.asList("fluid", "fluid_item", "fluid_in", "fluid_in_out", "fluid_out"), true);
    private static final PipeRenderer.Factory ELECTRICITY_RENDERER = MIPipesClient.makeRenderer(Arrays.asList("electricity", "electricity_blocks"), false);
    public static final Collection<PipeRenderer.Factory> RENDERERS = new LinkedHashSet<PipeRenderer.Factory>();

    public void setupClient() {
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(rm -> new PipeModelProvider());
        ColorProviderRegistry.BLOCK.register((Object)new PipeColorProvider(), (Object[])new class_2248[]{MIPipes.BLOCK_PIPE});
        class_3929.method_17542(MIPipes.SCREEN_HANDLER_TYPE_ITEM_PIPE, ItemPipeScreen::new);
        class_3929.method_17542(MIPipes.SCREEN_HANDLER_TYPE_FLUID_PIPE, FluidPipeScreen::new);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PipePackets.SET_PRIORITY, (ClientPlayNetworking.PlayChannelHandler)ClientPipePackets.ON_SET_PRIORITY);
        this.registerRenderers();
        WorldRenderEvents.BLOCK_OUTLINE.register((wrc, boc) -> {
            PipeVoxelShape shape;
            PipeBlockEntity pipe;
            class_2586 patt4187$temp = wrc.world().method_8321(boc.blockPos());
            if (patt4187$temp instanceof PipeBlockEntity && !(pipe = (PipeBlockEntity)patt4187$temp).hasCamouflage() && (shape = PipeBlock.getHitPart((class_1937)wrc.world(), boc.blockPos(), (class_3965)class_310.method_1551().field_1765)) != null) {
                class_2338 pos = boc.blockPos();
                class_243 camPos = wrc.camera().method_19326();
                RenderHelper.renderVoxelShape(wrc.matrixStack(), wrc.consumers().getBuffer(class_1921.method_23594()), shape.shape, (double)pos.method_10263() - camPos.method_10216(), (double)pos.method_10264() - camPos.method_10214(), (double)pos.method_10260() - camPos.method_10215(), 0.0f, 0.0f, 0.0f, 0.4f);
                return false;
            }
            return true;
        });
        ClientPickBlockGatherCallback.EVENT.register((player, result) -> {
            class_3965 bhr;
            class_2586 patt5164$temp;
            if (result instanceof class_3965 && (patt5164$temp = player.field_6002.method_8321((bhr = (class_3965)result).method_17777())) instanceof PipeBlockEntity) {
                PipeBlockEntity pipe = (PipeBlockEntity)patt5164$temp;
                if (pipe.hasCamouflage()) {
                    return pipe.getCamouflageStack();
                }
                PipeVoxelShape targetedPart = PipeBlock.getHitPart(player.field_6002, bhr.method_17777(), bhr);
                return new class_1799((class_1935)(targetedPart == null ? class_1802.field_8162 : MIPipes.INSTANCE.getPipeItem(targetedPart.type)));
            }
            return class_1799.field_8037;
        });
        InGameMouseScrollCallback.EVENT.register((player, direction) -> {
            if (player.method_5715() && MIItem.CONFIG_CARD.is(player.method_5998(class_1268.field_5808))) {
                transparentCamouflage = !transparentCamouflage;
                class_310.method_1551().field_1769.method_3279();
                MIText miText = transparentCamouflage ? MIText.TransparentCamouflageEnabled : MIText.TransparentCamouflageDisabled;
                player.method_7353((class_2561)miText.text(), true);
                return false;
            }
            return true;
        });
        BlockRenderLayerMap.INSTANCE.putBlock(MIPipes.BLOCK_PIPE, class_1921.method_23581());
    }

    private static PipeRenderer.Factory makeRenderer(final List<String> sprites, final boolean innerQuads) {
        return new PipeRenderer.Factory(){

            @Override
            public Collection<class_4730> getSpriteDependencies() {
                return sprites.stream().map(n -> new class_4730(class_1723.field_21668, (class_2960)new MIIdentifier("block/pipes/" + n))).collect(Collectors.toList());
            }

            @Override
            public PipeRenderer create(Function<class_4730, class_1058> textureGetter) {
                class_4730[] ids = (class_4730[])sprites.stream().map(n -> new class_4730(class_1723.field_21668, (class_2960)new MIIdentifier("block/pipes/" + n))).toArray(class_4730[]::new);
                return new PipeMeshCache(textureGetter, ids, innerQuads);
            }
        };
    }

    private void registerRenderers() {
        for (PipeNetworkType type : PipeNetworkType.getTypes().values()) {
            if (type.getIdentifier().method_12832().endsWith("item_pipe")) {
                PipeRenderer.register(type, ITEM_RENDERER);
                continue;
            }
            if (type.getIdentifier().method_12832().endsWith("fluid_pipe")) {
                PipeRenderer.register(type, FLUID_RENDERER);
                continue;
            }
            if (!type.getIdentifier().method_12832().endsWith("cable")) continue;
            PipeRenderer.register(type, ELECTRICITY_RENDERER);
        }
        if (MIConfig.loadAe2Compat()) {
            try {
                Class.forName("aztech.modern_industrialization.compat.ae2.MIAEAddonClient").getMethod("registerPipeRenderers", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        for (PipeNetworkType value : PipeNetworkType.getTypes().values()) {
            RENDERERS.add(PipeRenderer.get(value));
        }
    }
}

