/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen;

import com.mojang.serialization.Codec;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.common.world.feature.config.RadiusMatcher;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class Spike
extends class_3031<NoisySphereConfig> {
    protected static FastNoise fastNoise;
    protected long seed;

    public Spike(Codec<NoisySphereConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<NoisySphereConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.method_33652(), featurePlaceContext.method_33653(), featurePlaceContext.method_33654(), featurePlaceContext.method_33655(), (NoisySphereConfig)featurePlaceContext.method_33656());
    }

    public boolean place(class_5281 world, class_2794 chunkGenerator, class_5819 random, class_2338 position, NoisySphereConfig config) {
        this.setSeed(world.method_8412(), config.noiseFrequency());
        boolean use2D = random.method_43058() < config.noise2DChance();
        RadiusMatcher radiusMatcher = config.radiusMatcher();
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10101((class_2382)position);
        class_2338.class_2339 mutable2 = new class_2338.class_2339().method_10101((class_2382)mutable);
        NoisySphereConfig.RadiusSettings radiusSettings = config.radiusSettings();
        int xRadius = (int)((double)radiusSettings.xRadius().method_35008(random) / 2.0);
        int yRadius = radiusMatcher == RadiusMatcher.ALL ? xRadius : (int)((double)(radiusSettings.yRadius().method_35008(random) / 2));
        int zRadius = radiusMatcher == RadiusMatcher.ALL || radiusMatcher == RadiusMatcher.XZ ? xRadius : (int)((double)(radiusSettings.zRadius().method_35008(random) / 2));
        int lowestX = position.method_10263();
        int lowestY = position.method_10264();
        int lowestZ = position.method_10260();
        boolean verifiedHeight = !config.verfiesHeight();
        float perlin = fastNoise.GetPerlin(position.method_10263(), position.method_10264(), position.method_10260());
        double scaledNoise = perlin * 8.0f;
        double centerHeight = class_3532.method_16436((double)scaledNoise, (double)2.0, (double)7.0) + 10.0;
        int stackHeight = config.stackHeight().method_35008(random);
        int[][] built = new int[xRadius * 2 + 1][zRadius * 2 + 1];
        int stackIDX = 0;
        while (stackIDX <= stackHeight) {
            for (int x = -xRadius; x <= xRadius; ++x) {
                mutable2.method_33097(mutable.method_10263() + x);
                double xFract = (double)x / (double)xRadius;
                for (int z = -zRadius; z <= zRadius; ++z) {
                    mutable2.method_33099(mutable.method_10260() + z);
                    double zFract = (double)z / (double)zRadius;
                    if (verifiedHeight) {
                        double addedHeight;
                        double d = addedHeight = config.useScaledNoiseHeight() ? this.getScaledNoiseExtensionHeight(mutable2, centerHeight) : 1.0;
                        if (!(addedHeight > (double)built[x + xRadius][z + zRadius])) continue;
                        for (double y = (double)(-yRadius); y <= (double)yRadius; y += 1.0) {
                            double yFract = y / (double)yRadius;
                            mutable2.method_33098((int)((double)mutable.method_10264() + y));
                            double distanceSquaredFromCenter = xFract * xFract + yFract * yFract + zFract * zFract;
                            double yDistSquared = yFract * yFract;
                            float noise = use2D ? fastNoise.GetNoise(mutable2.method_10263(), mutable2.method_10260()) : fastNoise.GetNoise(mutable2.method_10263(), mutable2.method_10264(), mutable2.method_10260());
                            float threshold = 1.0f + 0.7f * noise;
                            double factor = yDistSquared / (double)threshold;
                            if (factor >= 1.0) {
                                distanceSquaredFromCenter /= factor;
                                distanceSquaredFromCenter -= Math.copySign((double)noise * 0.2, distanceSquaredFromCenter);
                            }
                            double density = stackIDX == stackHeight && config.pointed() ? (y + (double)yRadius + 1.0) / (double)(yRadius * 2 + 1) : 0.0;
                            double squaredDistance = (double)(x * x + z * z) / class_3532.method_15390((double)0.1, (double)1.0, (double)(1.0 - density));
                            if (config.checkSquareDistance() && squaredDistance >= (double)(xRadius * zRadius)) continue;
                            class_2338.class_2339 mutable3 = new class_2338.class_2339().method_10101((class_2382)mutable2);
                            int noiseExtensionY = 0;
                            while ((double)noiseExtensionY < addedHeight) {
                                int minY = Math.min(position.method_10264(), world.method_8624(class_2902.class_2903.field_13195, mutable3.method_10263(), mutable3.method_10260()));
                                boolean belowSurfaceDepth = minY - mutable3.method_10264() < config.belowSurfaceDepth().method_35008(random);
                                world.method_8652((class_2338)mutable3, config.topBlockProvider().method_23455(random, (class_2338)mutable3), 2);
                                world.method_8652(mutable3.method_10093(class_2350.field_11033), config.blockProvider().method_23455(random, (class_2338)mutable3), 2);
                                mutable3.method_10098(class_2350.field_11036);
                                ++noiseExtensionY;
                            }
                            built[x + xRadius][z + zRadius] = Math.max(mutable3.method_10264(), built[x + xRadius][z + zRadius]);
                            lowestX = Math.min(lowestX, mutable2.method_10263());
                            lowestY = Math.min(lowestY, mutable2.method_10264());
                            lowestZ = Math.min(lowestZ, mutable2.method_10260());
                        }
                        continue;
                    }
                    int oceanFloor = world.method_8624(class_2902.class_2903.field_13195, mutable2.method_10263(), mutable2.method_10260());
                    if (!world.method_31601(oceanFloor - 1) && position.method_10264() - oceanFloor <= 15) continue;
                    return false;
                }
            }
            if (verifiedHeight) {
                mutable.method_33098(mutable.method_10264() + yRadius);
                ++stackIDX;
            }
            verifiedHeight = true;
        }
        for (class_6880 spawningFeature : config.spawningFeatures()) {
            ((class_6796)spawningFeature.comp_349()).method_39644(world, chunkGenerator, random, new class_2338(lowestX, lowestY, lowestZ));
        }
        return true;
    }

    private double getScaledNoiseExtensionHeight(class_2338.class_2339 mutable2, double centerHeight) {
        float perlin1 = Math.abs(fastNoise.GetPerlin(mutable2.method_10263(), mutable2.method_10260()));
        double height = class_3532.method_16439((float)perlin1, (float)2.0f, (float)5.0f);
        return class_3532.method_16436((double)perlin1, (double)height, (double)(centerHeight + 25.0));
    }

    public void setSeed(long seed, float noiseFreq) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Cellular);
            this.seed = seed;
        }
        fastNoise.SetFrequency(noiseFreq);
    }
}

