/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2919;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3543;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6677;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.world.feature.config.SimpleBlockProviderConfig;

public class WideLake
extends class_3031<SimpleBlockProviderConfig> {
    protected static final Set<class_3614> unacceptableSolidMaterials = ImmutableSet.of((Object)class_3614.field_15946, (Object)class_3614.field_15938, (Object)class_3614.field_15923, (Object)class_3614.field_15913, (Object)class_3614.field_15925, (Object)class_3614.field_15949, (Object[])new class_3614[]{class_3614.field_15954, class_3614.field_15937, class_3614.field_15930, class_3614.field_15952, class_3614.field_15937});
    protected long noiseSeed;
    protected class_3543 noiseGen;

    public void setSeed(long seed) {
        class_2919 sharedseedrandom = new class_2919((class_5819)new class_6677(seed));
        if (this.noiseSeed != seed || this.noiseGen == null) {
            this.noiseGen = new class_3543((class_5819)sharedseedrandom, (List)ImmutableList.of((Object)0));
        }
        this.noiseSeed = seed;
    }

    public WideLake(Codec<SimpleBlockProviderConfig> configFactory) {
        super(configFactory);
    }

    public boolean method_13151(class_5821<SimpleBlockProviderConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.method_33652(), featurePlaceContext.method_33653(), featurePlaceContext.method_33654(), featurePlaceContext.method_33655(), (SimpleBlockProviderConfig)featurePlaceContext.method_33656());
    }

    public boolean place(class_5281 world, class_2794 chunkSettings, class_5819 random, class_2338 position, SimpleBlockProviderConfig config) {
        this.setSeed(world.method_8412());
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10101((class_2382)position.method_10087(2));
        for (int x = -2; x < 18; ++x) {
            for (int z = -2; z < 18; ++z) {
                int xTemp = x - 10;
                int zTemp = z - 10;
                if (xTemp * xTemp + zTemp * zTemp >= 64) continue;
                double samplePerlin1 = (this.noiseGen.method_16451((double)position.method_10263() + (double)x * 0.05, (double)position.method_10260() + (double)z * 0.05, true) + 1.0) * 3.0;
                int y = 0;
                while ((double)y > -samplePerlin1) {
                    mutable.method_10101((class_2382)position).method_10100(x, y, z);
                    boolean containedFlag = this.checkIfValidSpot((class_1936)world, mutable, samplePerlin1);
                    if (containedFlag) {
                        class_2680 configState = config.getBlockProvider().method_23455(random, (class_2338)mutable);
                        world.method_8652((class_2338)mutable, configState, 3);
                        if (configState == class_2246.field_10382.method_9564()) {
                            world.method_39281((class_2338)mutable, (class_3611)class_3612.field_15910, 0);
                        } else if (configState == class_2246.field_10164.method_9564()) {
                            world.method_39281((class_2338)mutable, (class_3611)class_3612.field_15908, 0);
                        }
                        class_2680 blockState = world.method_8320((class_2338)mutable.method_10098(class_2350.field_11036));
                        class_3614 material = blockState.method_26207();
                        if (material == class_3614.field_15935 && blockState.method_26204() != class_2246.field_10588 && blockState.method_26204() != BYGBlocks.ENDER_LILY.get() && blockState.method_26204() != BYGBlocks.TINY_LILYPADS.get()) {
                            world.method_8652((class_2338)mutable, class_2246.field_10124.method_9564(), 2);
                            while (mutable.method_10264() < world.method_31600() && world.method_8320((class_2338)mutable.method_10098(class_2350.field_11036)) == class_2246.field_10424.method_9564()) {
                                world.method_8652((class_2338)mutable, class_2246.field_10124.method_9564(), 2);
                            }
                        }
                        if (material == class_3614.field_15956 && blockState.method_26204() != class_2246.field_10597) {
                            world.method_8652((class_2338)mutable, class_2246.field_10124.method_9564(), 2);
                            world.method_8652(mutable.method_10084(), class_2246.field_10124.method_9564(), 2);
                        }
                    }
                    --y;
                }
            }
        }
        return true;
    }

    private boolean checkIfValidSpot(class_1936 world, class_2338.class_2339 blockpos$Mutable, double noise) {
        class_2338.class_2339 temp = new class_2338.class_2339().method_10101((class_2382)blockpos$Mutable);
        class_2680 blockState = world.method_8320(temp.method_10084());
        while (!blockState.method_26227().method_15769() && temp.method_10264() < world.method_31600()) {
            temp.method_10098(class_2350.field_11036);
        }
        if (!blockState.method_26215() && blockState.method_26227().method_15769()) {
            return false;
        }
        blockState = world.method_8320(blockpos$Mutable.method_10074());
        class_3614 material = blockState.method_26207();
        if ((!material.method_15799() || unacceptableSolidMaterials.contains(material) || blockState.method_26164(class_3481.field_15471)) && blockState.method_26227().method_15769() && blockState.method_26227() != class_3612.field_15910.method_15729(false)) {
            return false;
        }
        if (noise < 2.0 && world.method_8320(blockpos$Mutable.method_10084()).method_26215()) {
            int open = 0;
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_3614 material2 = world.method_8320(blockpos$Mutable.method_10093(direction)).method_26207();
                if (unacceptableSolidMaterials.contains(material2)) {
                    return false;
                }
                if (!world.method_8320(blockpos$Mutable.method_10093(direction)).method_26215()) continue;
                ++open;
            }
            if (open == 1) {
                return true;
            }
        }
        for (int x2 = -1; x2 < 2; ++x2) {
            for (int z2 = -1; z2 < 2; ++z2) {
                blockState = world.method_8320(blockpos$Mutable.method_10069(x2, 0, z2));
                material = blockState.method_26207();
                if (material.method_15799() && !unacceptableSolidMaterials.contains(material) && !blockState.method_26164(class_3481.field_15471) || !blockState.method_26227().method_15769() || blockState.method_26227() == class_3612.field_15910.method_15729(false)) continue;
                return false;
            }
        }
        return true;
    }
}

