/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.core;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingContext;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.BiomeModificationContext;
import fuzs.puzzleslib.core.ContentRegistrationFlags;
import fuzs.puzzleslib.core.ModConstructor;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.biome.BiomeLoadingContextFabric;
import fuzs.puzzleslib.impl.biome.ClimateSettingsContextFabric;
import fuzs.puzzleslib.impl.biome.GenerationSettingsContextFabric;
import fuzs.puzzleslib.impl.biome.MobSpawnSettingsContextFabric;
import fuzs.puzzleslib.impl.biome.SpecialEffectsContextFabric;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.biome.v1.BiomeModification;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1317;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_44;
import net.minecraft.class_5132;
import net.minecraft.class_5135;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_60;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.util.Strings;

public class FabricModConstructor {
    private static final Map<BiomeLoadingPhase, ModificationPhase> MODIFICATION_PHASE_CONVERSIONS = Maps.immutableEnumMap((Map)new HashMap<BiomeLoadingPhase, ModificationPhase>(){
        {
            this.put(BiomeLoadingPhase.ADDITIONS, ModificationPhase.ADDITIONS);
            this.put(BiomeLoadingPhase.REMOVALS, ModificationPhase.REMOVALS);
            this.put(BiomeLoadingPhase.MODIFICATIONS, ModificationPhase.REPLACEMENTS);
            this.put(BiomeLoadingPhase.POST_PROCESSING, ModificationPhase.POST_PROCESSING);
        }
    });

    private FabricModConstructor(ModConstructor constructor) {
        constructor.onConstructMod();
    }

    private void registerEntityAttribute(class_1299<? extends class_1309> type, class_5132.class_5133 builder) {
        if (class_5135.method_26875(type)) {
            throw new IllegalStateException("Duplicate DefaultAttributes entry: " + type);
        }
        FabricDefaultAttributeRegistry.register(type, (class_5132.class_5133)builder);
    }

    private void modifyEntityAttribute(class_1299<? extends class_1309> type, class_1320 attribute, double attributeValue) {
        class_5132 supplier = class_5135.method_26873(type);
        Map<class_1320, Double> attributeToBaseValueMap = class_2378.field_23781.method_10220().filter(arg_0 -> ((class_5132)supplier).method_27310(arg_0)).map(attribute1 -> supplier.method_26863(instance -> {}, attribute1)).filter(Objects::nonNull).collect(Collectors.toMap(class_1324::method_6198, class_1324::method_6201));
        attributeToBaseValueMap.put(attribute, attributeValue);
        class_5132.class_5133 builder = class_5132.method_26861();
        attributeToBaseValueMap.forEach((arg_0, arg_1) -> ((class_5132.class_5133)builder).method_26868(arg_0, arg_1));
        FabricDefaultAttributeRegistry.register(type, (class_5132.class_5133)builder);
    }

    private void registerFuelItem(class_1792 item, int burnTime) {
        if (burnTime > 0 && item != null) {
            FuelRegistry.INSTANCE.add((class_1935)item, (Object)burnTime);
        }
    }

    private ModConstructor.LootTablesReplaceContext getLootTablesReplaceContext(class_60 lootManager, class_2960 id, class_52 original, final MutableObject<class_52> replacement) {
        return new ModConstructor.LootTablesReplaceContext(lootManager, id, original){

            @Override
            public void setLootTable(class_52 table) {
                replacement.setValue((Object)table);
            }
        };
    }

    private ModConstructor.LootTablesModifyContext getLootTablesModifyContext(class_60 lootManager, class_2960 id, final class_52.class_53 tableBuilder) {
        return new ModConstructor.LootTablesModifyContext(lootManager, id){

            @Override
            public void addLootPool(class_55 pool) {
                tableBuilder.pool(pool);
            }

            @Override
            public boolean removeLootPool(int index) {
                MutableInt counter = new MutableInt();
                MutableBoolean result = new MutableBoolean();
                tableBuilder.modifyPools(builder -> {
                    if (index == counter.getAndIncrement()) {
                        builder.method_352((class_5658)class_44.method_32448((float)0.0f));
                        builder.method_35509((class_5658)class_44.method_32448((float)0.0f));
                        result.setTrue();
                    }
                });
                return result.booleanValue();
            }
        };
    }

    private void registerBiomeModification(BiomeModification biomeModification, BiomeLoadingPhase phase, Predicate<BiomeLoadingContext> selector, Consumer<BiomeModificationContext> modifier) {
        ModificationPhase modificationPhase = MODIFICATION_PHASE_CONVERSIONS.get((Object)phase);
        biomeModification.add(modificationPhase, selectionContext -> selector.test(BiomeLoadingContextFabric.create(selectionContext)), (selectionContext, modificationContext) -> modifier.accept(FabricModConstructor.getBiomeModificationContext(modificationContext, selectionContext.getBiome())));
    }

    private static BiomeModificationContext getBiomeModificationContext(net.fabricmc.fabric.api.biome.v1.BiomeModificationContext modificationContext, class_1959 biome) {
        ClimateSettingsContextFabric climateSettings = new ClimateSettingsContextFabric(biome, modificationContext.getWeather());
        SpecialEffectsContextFabric specialEffects = new SpecialEffectsContextFabric(biome.method_24377(), modificationContext.getEffects());
        GenerationSettingsContextFabric generationSettings = new GenerationSettingsContextFabric(biome.method_30970(), modificationContext.getGenerationSettings());
        MobSpawnSettingsContextFabric mobSpawnSettings = new MobSpawnSettingsContextFabric(biome.method_30966(), modificationContext.getSpawnSettings());
        return new BiomeModificationContext(climateSettings, specialEffects, generationSettings, mobSpawnSettings);
    }

    public static void construct(ModConstructor constructor, String modId, ContentRegistrationFlags ... contentRegistrations) {
        if (Strings.isBlank((String)modId)) {
            throw new IllegalArgumentException("mod id cannot be empty");
        }
        PuzzlesLib.LOGGER.info("Constructing common components for mod {}", (Object)modId);
        FabricModConstructor fabricModConstructor = new FabricModConstructor(constructor);
        constructor.onCommonSetup(Runnable::run);
        constructor.onRegisterSpawnPlacements(class_1317::method_20637);
        constructor.onEntityAttributeCreation(fabricModConstructor::registerEntityAttribute);
        constructor.onEntityAttributeModification(fabricModConstructor::modifyEntityAttribute);
        constructor.onRegisterFuelBurnTimes((burnTime, items) -> {
            if (class_3532.method_15340((int)burnTime, (int)1, (int)Short.MAX_VALUE) != burnTime) {
                throw new IllegalArgumentException("fuel burn time is out of bounds");
            }
            Objects.requireNonNull(items, "items is null");
            for (class_1935 item : items) {
                Objects.requireNonNull(item, "item is null");
                FuelRegistry.INSTANCE.add((class_1935)item.method_8389(), (Object)burnTime);
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, context, environment) -> constructor.onRegisterCommands(new ModConstructor.RegisterCommandsContext((CommandDispatcher<class_2168>)dispatcher, context, environment)));
        LootTableEvents.REPLACE.register((resourceManager, lootManager, id, original, source) -> {
            if (source != LootTableSource.DATA_PACK) {
                MutableObject replacement = new MutableObject();
                constructor.onLootTableReplacement(fabricModConstructor.getLootTablesReplaceContext(lootManager, id, original, (MutableObject<class_52>)replacement));
                return (class_52)replacement.getValue();
            }
            return null;
        });
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            if (source != LootTableSource.DATA_PACK) {
                constructor.onLootTableModification(fabricModConstructor.getLootTablesModifyContext(lootManager, id, tableBuilder));
            }
        });
        BiomeModification biomeModification = BiomeModifications.create((class_2960)new class_2960(modId, "biome_modifiers"));
        constructor.onRegisterBiomeModifications((phase, selector, modifier) -> fabricModConstructor.registerBiomeModification(biomeModification, phase, selector, modifier));
        constructor.onRegisterFlammableBlocks((encouragement, flammability, blocks) -> {
            Objects.requireNonNull(blocks, "blocks is null");
            for (class_2248 block : blocks) {
                Objects.requireNonNull(block, "block is null");
                FlammableBlockRegistry.getDefaultInstance().add(block, flammability, encouragement);
            }
        });
    }
}

