/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.networking;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.networking.v3.serialization.MessageSerializers;
import fuzs.puzzleslib.impl.networking.NetworkHandlerRegistry;
import fuzs.puzzleslib.proxy.FabricProxy;
import fuzs.puzzleslib.proxy.Proxy;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;

public class NetworkHandlerFabric
implements NetworkHandlerRegistry {
    private final Map<Class<?>, class_2960> messageChannelNames = Maps.newIdentityHashMap();
    private final String modId;
    private final AtomicInteger discriminator = new AtomicInteger();

    private NetworkHandlerFabric(String modId) {
        this.modId = modId;
    }

    @Override
    public <T extends Record> void registerClientbound(Class<?> clazz) {
        this.register(clazz, ((FabricProxy)Proxy.INSTANCE)::registerClientReceiverV2);
    }

    @Override
    public <T extends Record> void registerServerbound(Class<?> clazz) {
        this.register(clazz, ((FabricProxy)Proxy.INSTANCE)::registerServerReceiverV2);
    }

    private <T> void register(Class<T> clazz, BiConsumer<class_2960, Function<class_2540, T>> register) {
        if (!clazz.isRecord()) {
            throw new IllegalArgumentException("Message of type %s is not a record".formatted(clazz));
        }
        class_2960 channelName = this.nextIdentifier();
        if (this.messageChannelNames.put(clazz, channelName) != null) {
            throw new IllegalStateException("Duplicate message of type %s".formatted(clazz));
        }
        register.accept(channelName, MessageSerializers.findByType(clazz)::read);
    }

    private class_2960 nextIdentifier() {
        return new class_2960(this.modId, "play/" + this.discriminator.getAndIncrement());
    }

    @Override
    public <T extends Record> class_2596<?> toClientboundPacket(T message) {
        return this.toPacket(ServerPlayNetworking::createS2CPacket, message);
    }

    @Override
    public <T extends Record> class_2596<?> toServerboundPacket(T message) {
        return this.toPacket(ClientPlayNetworking::createC2SPacket, message);
    }

    private <T extends Record> class_2596<?> toPacket(BiFunction<class_2960, class_2540, class_2596<?>> packetFactory, T message) {
        Class<?> clazz = message.getClass();
        if (!clazz.isRecord()) {
            throw new IllegalArgumentException("Message of type %s is not a record".formatted(clazz));
        }
        class_2540 byteBuf = PacketByteBufs.create();
        MessageSerializers.findByType(clazz).write(byteBuf, message);
        class_2960 channelName = this.messageChannelNames.get(clazz);
        Objects.requireNonNull(channelName, "Unknown message of type %s".formatted(clazz));
        return packetFactory.apply(channelName, byteBuf);
    }

    public static class FabricBuilderImpl
    extends NetworkHandlerRegistry.BuilderImpl {
        public FabricBuilderImpl(String modId) {
            super(modId);
        }

        @Override
        protected NetworkHandlerRegistry getHandler() {
            return new NetworkHandlerFabric(this.modId);
        }
    }
}

