/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.init;

import fuzs.puzzleslib.core.ModLoader;
import fuzs.puzzleslib.init.RegistryReference;
import fuzs.puzzleslib.init.builder.ExtendedModMenuSupplier;
import fuzs.puzzleslib.init.builder.ModBlockEntityTypeBuilder;
import fuzs.puzzleslib.init.builder.ModMenuSupplier;
import fuzs.puzzleslib.init.builder.ModPoiTypeBuilder;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public interface RegistryManager {
    public String namespace();

    public RegistryManager whenOn(ModLoader ... var1);

    default public RegistryManager whenNotOn(ModLoader ... forbiddenModLoaders) {
        ModLoader[] allowedModLoaders = (ModLoader[])Stream.of(ModLoader.values()).filter(modLoader -> !ArrayUtils.contains((Object[])forbiddenModLoaders, (Object)modLoader)).toArray(ModLoader[]::new);
        return this.whenOn(allowedModLoaders);
    }

    default public void applyRegistration() {
    }

    default public <T> RegistryReference<T> placeholder(class_5321<? extends class_2378<? super T>> registryKey, String path) {
        return RegistryReference.placeholder(registryKey, this.makeKey(path));
    }

    public <T> RegistryReference<T> register(class_5321<? extends class_2378<? super T>> var1, String var2, Supplier<T> var3);

    default public RegistryReference<class_2248> registerBlock(String path, Supplier<class_2248> entry) {
        return this.register(class_2378.field_25105, path, entry);
    }

    default public RegistryReference<class_2248> registerBlockWithItem(String path, Supplier<class_2248> entry, class_1761 creativeTab) {
        return this.registerBlockWithItem(path, entry, new class_1792.class_1793().method_7892(creativeTab));
    }

    default public RegistryReference<class_2248> registerBlockWithItem(String path, Supplier<class_2248> entry, class_1792.class_1793 properties) {
        RegistryReference<class_2248> block = this.registerBlock(path, entry);
        this.registerBlockItem(path, properties);
        return block;
    }

    default public RegistryReference<class_3611> registerFluid(String path, Supplier<class_3611> entry) {
        return this.register(class_2378.field_25103, path, entry);
    }

    default public RegistryReference<class_1792> registerItem(String path, Function<class_1792.class_1793, class_1792> entry, class_1761 creativeTab) {
        return this.registerItem(path, () -> (class_1792)entry.apply(new class_1792.class_1793().method_7892(creativeTab)));
    }

    default public RegistryReference<class_1792> registerItem(String path, Supplier<class_1792> entry) {
        return this.register(class_2378.field_25108, path, entry);
    }

    default public RegistryReference<class_1792> registerBlockItem(String path, class_1761 creativeTab) {
        return this.registerBlockItem(path, new class_1792.class_1793().method_7892(creativeTab));
    }

    default public RegistryReference<class_1792> registerBlockItem(String path, class_1792.class_1793 properties) {
        return this.registerItem(path, () -> {
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(this.makeKey(path));
            Objects.requireNonNull(block, "Can't register item for null block");
            return new class_1747(block, properties);
        });
    }

    default public RegistryReference<class_1291> registerMobEffect(String path, Supplier<class_1291> entry) {
        return this.register(class_2378.field_25104, path, entry);
    }

    default public RegistryReference<class_3414> registerRawSoundEvent(String path) {
        return this.registerSoundEvent(path, () -> new class_3414(this.makeKey(path)));
    }

    default public RegistryReference<class_3414> registerSoundEvent(String path, Supplier<class_3414> entry) {
        return this.register(class_2378.field_25102, path, entry);
    }

    default public RegistryReference<class_1842> registerPotion(String path, Supplier<class_1842> entry) {
        return this.register(class_2378.field_25109, path, entry);
    }

    default public RegistryReference<class_1887> registerEnchantment(String path, Supplier<class_1887> entry) {
        return this.register(class_2378.field_25106, path, entry);
    }

    default public <T extends class_1297> RegistryReference<class_1299<T>> registerEntityType(String path, Supplier<class_1299<T>> entry) {
        return this.register(class_2378.field_25107, path, entry);
    }

    default public <T extends class_1297> RegistryReference<class_1299<T>> registerEntityTypeBuilder(String path, Supplier<class_1299.class_1300<T>> entry) {
        return this.registerEntityType(path, () -> ((class_1299.class_1300)entry.get()).method_5905(path));
    }

    default public <T extends class_2586> RegistryReference<class_2591<T>> registerBlockEntityType(String path, Supplier<class_2591<T>> entry) {
        return this.register(class_2378.field_25073, path, entry);
    }

    public <T extends class_2586> RegistryReference<class_2591<T>> registerBlockEntityTypeBuilder(String var1, Supplier<ModBlockEntityTypeBuilder<T>> var2);

    default public <T extends class_1703> RegistryReference<class_3917<T>> registerMenuType(String path, Supplier<class_3917<T>> entry) {
        return this.register(class_2378.field_25083, path, entry);
    }

    public <T extends class_1703> RegistryReference<class_3917<T>> registerMenuTypeSupplier(String var1, Supplier<ModMenuSupplier<T>> var2);

    public <T extends class_1703> RegistryReference<class_3917<T>> registerExtendedMenuTypeSupplier(String var1, Supplier<ExtendedModMenuSupplier<T>> var2);

    public RegistryReference<class_4158> registerPoiTypeBuilder(String var1, Supplier<ModPoiTypeBuilder> var2);

    default public <T extends class_1860<?>> RegistryReference<class_3956<T>> registerRecipeType(final String path) {
        return this.register(class_2378.field_25084, path, () -> new class_3956<T>(){
            private final String id;
            {
                this.id = RegistryManager.this.makeKey(path).toString();
            }

            public String toString() {
                return this.id;
            }
        });
    }

    default public class_2960 makeKey(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Can't register object without name");
        }
        return new class_2960(this.namespace(), path);
    }
}

