/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.network;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.network.Message;
import fuzs.puzzleslib.network.MessageDirection;
import fuzs.puzzleslib.network.NetworkHandler;
import fuzs.puzzleslib.proxy.FabricProxy;
import fuzs.puzzleslib.proxy.Proxy;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;

public class FabricNetworkHandler
implements NetworkHandler {
    private static final Map<String, FabricNetworkHandler> MOD_TO_NETWORK = Maps.newConcurrentMap();
    private final Map<Class<? extends Message<?>>, MessageData> messages = Maps.newIdentityHashMap();
    private final String modId;
    private final AtomicInteger discriminator = new AtomicInteger();

    private FabricNetworkHandler(String modId) {
        this.modId = modId;
    }

    @Override
    public <T extends Message<T>> void register(Class<? extends T> clazz, Supplier<T> supplier, MessageDirection direction) {
        class_2960 channelName = this.nextIdentifier();
        this.messages.put(clazz, new MessageData(clazz, channelName, direction));
        Function<class_2540, Message> decode = buf -> (Message)class_156.method_654((Object)((Message)supplier.get()), message -> message.read((class_2540)buf));
        switch (direction) {
            case TO_CLIENT: {
                ((FabricProxy)Proxy.INSTANCE).registerClientReceiver(channelName, decode);
                break;
            }
            case TO_SERVER: {
                ((FabricProxy)Proxy.INSTANCE).registerServerReceiver(channelName, decode);
            }
        }
    }

    private class_2960 nextIdentifier() {
        return new class_2960(this.modId, "play/" + this.discriminator.getAndIncrement());
    }

    @Override
    public class_2596<?> toServerboundPacket(Message<?> message) {
        if (this.messages.get(message.getClass()).direction() != MessageDirection.TO_SERVER) {
            throw new IllegalStateException("Attempted sending message to wrong side, expected %s, was %s".formatted(new Object[]{MessageDirection.TO_SERVER, MessageDirection.TO_CLIENT}));
        }
        return this.toPacket(ClientPlayNetworking::createC2SPacket, message);
    }

    @Override
    public class_2596<?> toClientboundPacket(Message<?> message) {
        if (this.messages.get(message.getClass()).direction() != MessageDirection.TO_CLIENT) {
            throw new IllegalStateException("Attempted sending message to wrong side, expected %s, was %s".formatted(new Object[]{MessageDirection.TO_CLIENT, MessageDirection.TO_SERVER}));
        }
        return this.toPacket(ServerPlayNetworking::createS2CPacket, message);
    }

    private class_2596<?> toPacket(BiFunction<class_2960, class_2540, class_2596<?>> packetFactory, Message<?> message) {
        class_2960 identifier = this.messages.get(message.getClass()).identifier();
        class_2540 byteBuf = PacketByteBufs.create();
        message.write(byteBuf);
        return packetFactory.apply(identifier, byteBuf);
    }

    public static synchronized NetworkHandler of(String modId) {
        return MOD_TO_NETWORK.computeIfAbsent(modId, FabricNetworkHandler::new);
    }

    private record MessageData(Class<? extends Message<?>> clazz, class_2960 identifier, MessageDirection direction) {
    }
}

