/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.transfer.simple;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.ClientInternals;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public interface SimpleTransferHandler
extends TransferHandler {
    public static <C extends class_1703, D extends Display> SimpleTransferHandler create(final Class<? extends C> containerClass, final CategoryIdentifier<D> categoryIdentifier, final IntRange inputSlots) {
        return new SimpleTransferHandler(){

            @Override
            public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
                if (!containerClass.isInstance(context.getMenu()) || !categoryIdentifier.equals(context.getDisplay().getCategoryIdentifier()) || context.getContainerScreen() == null) {
                    return TransferHandler.ApplicabilityResult.createNotApplicable();
                }
                return TransferHandler.ApplicabilityResult.createApplicable();
            }

            @Override
            public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context context) {
                return IntStream.range(inputSlots.min, inputSlots.maxExclusive).mapToObj(id -> SlotAccessor.fromSlot(context.getMenu().method_7611(id))).toList();
            }

            @Override
            public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context context) {
                class_746 player = context.getMinecraft().field_1724;
                class_1661 inventory = player.method_31548();
                return IntStream.range(0, inventory.field_7547.size()).mapToObj(index -> SlotAccessor.fromPlayerInventory((class_1657)player, index)).collect(Collectors.toList());
            }
        };
    }

    public static <C extends class_1263, D extends Display> SimpleTransferHandler create(final Class<? extends C> containerClass, final CategoryIdentifier<D> categoryIdentifier, final IntRange inputSlots, final IntRange inventorySlots) {
        return new SimpleTransferHandler(){

            @Override
            public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
                if (!containerClass.isInstance(context.getMenu()) || !categoryIdentifier.equals(context.getDisplay().getCategoryIdentifier()) || context.getContainerScreen() == null) {
                    return TransferHandler.ApplicabilityResult.createNotApplicable();
                }
                return TransferHandler.ApplicabilityResult.createApplicable();
            }

            @Override
            public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context context) {
                return IntStream.range(inputSlots.min, inputSlots.maxExclusive).mapToObj(id -> SlotAccessor.fromSlot(context.getMenu().method_7611(id))).toList();
            }

            @Override
            public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context context) {
                return IntStream.range(inventorySlots.min, inventorySlots.maxExclusive).mapToObj(id -> SlotAccessor.fromSlot(context.getMenu().method_7611(id))).toList();
            }
        };
    }

    public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context var1);

    public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context var1);

    default public List<InputIngredient<class_1799>> getInputsIndexed(TransferHandler.Context context) {
        if (context.getDisplay() == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.map(context.getDisplay().getInputIngredients(context.getMenu(), (class_1657)context.getMinecraft().field_1724), entry -> InputIngredient.withType(entry, VanillaEntryTypes.ITEM));
    }

    default public void renderMissingInput(TransferHandler.Context context, List<InputIngredient<class_1799>> inputs, List<InputIngredient<class_1799>> missing, IntSet missingIndices, class_4587 matrices, int mouseX, int mouseY, float delta, List<Widget> widgets, Rectangle bounds) {
        int i = 0;
        for (Widget widget : widgets) {
            if (!(widget instanceof Slot) || ((Slot)widget).getNoticeMark() != 1 || !missingIndices.contains(i++)) continue;
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 50.0);
            Rectangle innerBounds = ((Slot)widget).getInnerBounds();
            class_332.method_25294((class_4587)matrices, (int)innerBounds.x, (int)innerBounds.y, (int)innerBounds.getMaxX(), (int)innerBounds.getMaxY(), (int)0x40FF0000);
            matrices.method_22909();
        }
    }

    default public MissingInputRenderer getMissingInputRenderer() {
        return this::renderMissingInput;
    }

    @Override
    default public TransferHandler.Result handle(TransferHandler.Context context) {
        return this.handleSimpleTransfer(context, this.getMissingInputRenderer(), this.getInputsIndexed(context), this.getInputSlots(context), this.getInventorySlots(context));
    }

    default public TransferHandler.Result handleSimpleTransfer(TransferHandler.Context context, MissingInputRenderer missingInputRenderer, List<InputIngredient<class_1799>> inputs, Iterable<SlotAccessor> inputSlots, Iterable<SlotAccessor> inventorySlots) {
        return ClientInternals.getSimpleTransferHandler().handle(context, missingInputRenderer, inputs, inputSlots, inventorySlots);
    }

    public record IntRange(int min, int maxExclusive) {
    }

    public static interface MissingInputRenderer {
        public void renderMissingInput(TransferHandler.Context var1, List<InputIngredient<class_1799>> var2, List<InputIngredient<class_1799>> var3, IntSet var4, class_4587 var5, int var6, int var7, float var8, List<Widget> var9, Rectangle var10);
    }
}

