/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import dev.architectury.platform.Platform;
import dev.architectury.utils.value.BooleanValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.search.method.InputMethod;
import me.shedaniel.rei.api.client.search.method.InputMethodRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.modules.MenuAccess;
import me.shedaniel.rei.impl.client.gui.modules.entries.SeparatorMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.SubMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import me.shedaniel.rei.impl.client.gui.screen.ConfigReloadingScreen;
import me.shedaniel.rei.impl.client.search.method.DefaultInputMethod;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.class_1162;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_918;

public class CraftableFilterButtonWidget {
    public static final UUID FILTER_MENU_UUID = UUID.fromString("2839e998-1679-4f9e-a257-37411d16f1e6");

    public static Widget create(ScreenOverlayImpl overlay) {
        Rectangle bounds = CraftableFilterButtonWidget.getCraftableFilterBounds();
        MenuAccess access = overlay.menuAccess();
        class_918 itemRenderer = class_310.method_1551().method_1480();
        class_1799 icon = new class_1799((class_1935)class_2246.field_9980);
        Button filterButton = Widgets.createButton(bounds, (class_2561)class_2561.method_43473()).focusable(false).onClick(button -> {
            ConfigManager.getInstance().toggleCraftableOnly();
            ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        }).onRender((matrices, button) -> {
            button.setTint(ConfigManager.getInstance().isCraftableOnlyEnabled() ? 939579655 : 956235776);
            access.openOrClose(FILTER_MENU_UUID, button.getBounds(), () -> CraftableFilterButtonWidget.menuEntries(access));
        }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && overlay.isNotInExclusionZones(point.x, point.y)).tooltipLineSupplier(button -> class_2561.method_43471((String)(ConfigManager.getInstance().isCraftableOnlyEnabled() ? "text.rei.showing_craftable" : "text.rei.showing_all")));
        Widget overlayWidget = Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            class_1162 vector = new class_1162((float)(bounds.x + 2), (float)(bounds.y + 2), (float)(helper.method_25305() - 10), 1.0f);
            vector.method_22674(matrices.method_23760().method_23761());
            itemRenderer.field_4730 = vector.method_4957();
            itemRenderer.method_4010(icon, (int)vector.method_4953(), (int)vector.method_4956());
            itemRenderer.field_4730 = 0.0f;
        });
        return Widgets.concat(filterButton, overlayWidget);
    }

    private static Collection<FavoriteMenuEntry> menuEntries(MenuAccess access) {
        ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
        ArrayList<FavoriteMenuEntry> entries = new ArrayList<FavoriteMenuEntry>(List.of(new SubMenuEntry((class_2561)class_2561.method_43471((String)"text.rei.config.menu.search_field.position"), Arrays.stream(SearchFieldLocation.values()).map(location -> ToggleMenuEntry.of((class_2561)class_2561.method_43470((String)location.toString()), () -> config.getSearchFieldLocation() == location, bool -> config.setSearchFieldLocation((SearchFieldLocation)((Object)location))).withActive(() -> config.getSearchFieldLocation() != location)).toList())));
        List<Map.Entry<class_2960, InputMethod<?>>> applicableInputMethods = CraftableFilterButtonWidget.getApplicableInputMethods();
        if (applicableInputMethods.size() > 1) {
            entries.add(new SubMenuEntry((class_2561)class_2561.method_43471((String)"text.rei.config.menu.search_field.input_method"), CraftableFilterButtonWidget.createInputMethodEntries(access, applicableInputMethods)));
        }
        return entries;
    }

    public static List<Map.Entry<class_2960, InputMethod<?>>> getApplicableInputMethods() {
        String languageCode = class_310.method_1551().field_1690.field_1883;
        return InputMethodRegistry.getInstance().getAll().entrySet().stream().filter(entry -> CollectionUtils.anyMatch(((InputMethod)entry.getValue()).getMatchingLocales(), locale -> locale.code().equals(languageCode))).toList();
    }

    public static List<FavoriteMenuEntry> createInputMethodEntries(MenuAccess access, List<Map.Entry<class_2960, InputMethod<?>>> applicableInputMethods) {
        List<FavoriteMenuEntry> optionsMenuEntries;
        ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
        List<FavoriteMenuEntry> entries = applicableInputMethods.stream().map(pair -> ToggleMenuEntry.of(((InputMethod)pair.getValue()).getName(), () -> Objects.equals(config.getInputMethodId(), pair.getKey()), bool -> {
            ExecutorService service = Executors.newSingleThreadExecutor();
            InputMethod<?> active = InputMethod.active();
            ((CompletableFuture)active.dispose(service).whenComplete((unused, throwable) -> {
                if (throwable != null) {
                    InternalLogger.getInstance().error("Failed to dispose input method", (Throwable)throwable);
                }
                ConfigManagerImpl.getInstance().getConfig().setInputMethodId(new class_2960("rei:default"));
            })).join();
            double[] progress = new double[]{0.0};
            CompletionStage future = ((InputMethod)pair.getValue()).prepare(service, p -> {
                progress[0] = class_3532.method_15350((double)p, (double)0.0, (double)1.0);
            }).whenComplete((unused, throwable) -> {
                if (throwable != null) {
                    InternalLogger.getInstance().error("Failed to prepare input method", (Throwable)throwable);
                    ConfigManagerImpl.getInstance().getConfig().setInputMethodId(new class_2960("rei:default"));
                } else {
                    ConfigManagerImpl.getInstance().getConfig().setInputMethodId((class_2960)pair.getKey());
                }
            });
            class_437 screen = class_310.method_1551().field_1755;
            ConfigReloadingScreen reloadingScreen = new ConfigReloadingScreen((class_2561)class_2561.method_43471((String)"text.rei.input.methods.initializing"), () -> CraftableFilterButtonWidget.lambda$createInputMethodEntries$16((CompletableFuture)future), () -> class_310.method_1551().method_1507(screen), () -> CraftableFilterButtonWidget.lambda$createInputMethodEntries$18(screen, (CompletableFuture)future, service));
            reloadingScreen.setSubtitle(() -> class_2561.method_43469((String)"text.rei.input.methods.reload.progress", (Object[])new Object[]{String.format("%.2f", progress[0] * 100.0)}));
            class_310.method_1551().method_1507((class_437)reloadingScreen);
            access.close();
            ((CompletableFuture)future).whenComplete((unused, throwable) -> {
                service.shutdown();
                if (throwable != null) {
                    return;
                }
                ScreenOverlayImpl.getInstance().getHintsContainer().addHint(12, () -> new Point(CraftableFilterButtonWidget.getCraftableFilterBounds().getCenterX(), CraftableFilterButtonWidget.getCraftableFilterBounds().getCenterY()), "text.rei.hint.input.methods", List.of(class_2561.method_43471((String)"text.rei.hint.input.methods")));
            });
        }).withActive(() -> !Objects.equals(config.getInputMethodId(), pair.getKey())).withTooltip(() -> Tooltip.create(Widget.mouse(), ((InputMethod)pair.getValue()).getDescription()))).collect(Collectors.toList());
        InputMethod<?> active = InputMethod.active();
        if (!(active instanceof DefaultInputMethod)) {
            entries.add(0, new SeparatorMenuEntry());
            entries.add(0, FavoriteMenuEntry.createToggle((class_2561)class_2561.method_43471((String)"text.rei.input.methods.tooltip.hints"), new BooleanValue(){

                public void accept(boolean t) {
                    ConfigManagerImpl.getInstance().getConfig().setDoDisplayIMEHints(!this.getAsBoolean());
                }

                public boolean getAsBoolean() {
                    return ConfigObject.getInstance().doDisplayIMEHints();
                }
            }));
        }
        if (!(optionsMenuEntries = active.getOptionsMenuEntries()).isEmpty()) {
            entries.add(new SeparatorMenuEntry());
            entries.addAll(optionsMenuEntries);
        }
        return entries;
    }

    private static Rectangle getCraftableFilterBounds() {
        Rectangle area = REIRuntimeImpl.getSearchField().getBounds().clone();
        area.setLocation(area.x + area.width + 4, area.y - 1);
        area.setSize(20, 20);
        return area;
    }

    private static /* synthetic */ void lambda$createInputMethodEntries$18(class_437 screen, CompletableFuture future, ExecutorService service) {
        class_310.method_1551().method_1507(screen);
        InternalLogger.getInstance().error("Failed to prepare input method: cancelled");
        ConfigManagerImpl.getInstance().getConfig().setInputMethodId(new class_2960("rei:default"));
        future.cancel(Platform.isFabric());
        service.shutdown();
    }

    private static /* synthetic */ boolean lambda$createInputMethodEntries$16(CompletableFuture future) {
        return !future.isDone();
    }
}

