/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.transfer;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import me.shedaniel.rei.api.common.plugins.REIServerPlugin;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessorRegistry;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class SlotAccessorRegistryImpl
implements SlotAccessorRegistry {
    private final Map<class_2960, SlotAccessorRegistry.Serializer> map = new HashMap<class_2960, SlotAccessorRegistry.Serializer>();

    @Override
    public void startReload() {
        this.map.clear();
    }

    @Override
    public void endReload() {
        InternalLogger.getInstance().debug("Registered %d slot accessor serializers", this.map.size());
    }

    @Override
    public void acceptPlugin(REIServerPlugin plugin) {
        plugin.registerSlotAccessors(this);
    }

    @Override
    public void register(class_2960 id, final Predicate<SlotAccessor> accessorPredicate, final SlotAccessorRegistry.Serializer serializer) {
        this.map.put(id, new SlotAccessorRegistry.Serializer(){

            @Override
            public SlotAccessor read(class_1703 menu, class_1657 player, class_2487 tag) {
                return serializer.read(menu, player, tag);
            }

            @Override
            @Nullable
            public class_2487 save(class_1703 menu, class_1657 player, SlotAccessor accessor) {
                if (!accessorPredicate.test(accessor)) {
                    return null;
                }
                return serializer.save(menu, player, accessor);
            }
        });
        InternalLogger.getInstance().debug("Added slot accessor serializer: %s [%s]", serializer, id);
    }

    @Override
    @Nullable
    public SlotAccessorRegistry.Serializer get(class_2960 id) {
        return this.map.get(id);
    }

    @Override
    public class_2487 save(class_1703 menu, class_1657 player, SlotAccessor accessor) {
        for (Map.Entry<class_2960, SlotAccessorRegistry.Serializer> entry : this.map.entrySet()) {
            class_2487 tag = entry.getValue().save(menu, player, accessor);
            if (tag == null) continue;
            tag.method_10582("id", entry.getKey().toString());
            return tag;
        }
        return null;
    }

    @Override
    public SlotAccessor read(class_1703 menu, class_1657 player, class_2487 tag) {
        String id = tag.method_10558("id");
        SlotAccessorRegistry.Serializer serializer = this.map.get(new class_2960(id));
        if (serializer == null) {
            throw new NullPointerException("No serializer found for " + id);
        }
        return serializer.read(menu, player, tag);
    }
}

