/*
 * Decompiled with CFR 0.152.
 */
package net.elidhan.anim_guns.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import net.elidhan.anim_guns.AnimatedGuns;
import net.elidhan.anim_guns.AnimatedGunsClient;
import net.elidhan.anim_guns.entity.projectile.BulletProjectileEntity;
import net.elidhan.anim_guns.util.BulletUtil;
import net.elidhan.anim_guns.util.InventoryUtil;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.network.GeckoLibNetwork;
import software.bernie.geckolib3.network.ISyncable;
import software.bernie.geckolib3.util.GeckoLibUtil;

public abstract class GunItem
extends class_1792
implements FabricItem,
IAnimatable,
ISyncable {
    public final Random random;
    public AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public static final String controllerName = "controller";
    private final String gunID;
    private final String animationID;
    private final float gunDamage;
    private final int rateOfFire;
    private final int magSize;
    public final class_1792 ammoType;
    private final int reloadCooldown;
    private final float[] bulletSpread;
    private final float[] gunRecoil;
    private final int pelletCount;
    private final LoadingType loadingType;
    private final class_3414 reloadSoundStart;
    private final class_3414 reloadSoundMagOut;
    private final class_3414 reloadSoundMagIn;
    private final class_3414 reloadSoundEnd;
    private final class_3414 shootSound;
    private final int reloadCycles;
    private final boolean isScoped;
    private final boolean unscopeAfterShot;
    private final int reloadStage1;
    private final int reloadStage2;
    private final int reloadStage3;
    private final Multimap<class_1320, class_1322> attributeModifiers;

    public GunItem(class_1792.class_1793 settings, String gunID, String animationID, float gunDamage, int rateOfFire, int magSize, class_1792 ammoType, int reloadCooldown, float[] bulletSpread, float[] gunRecoil, int pelletCount, LoadingType loadingType, class_3414 reloadSoundStart, class_3414 reloadSoundMagOut, class_3414 reloadSoundMagIn, class_3414 reloadSoundEnd, class_3414 shootSound, int reloadCycles, boolean isScoped, boolean unscopeAfterShot, int reloadStage1, int reloadStage2, int reloadStage3) {
        super(settings.method_7895(magSize * 10 + 1));
        GeckoLibNetwork.registerSyncable((ISyncable)this);
        this.random = new Random();
        this.gunID = gunID;
        this.animationID = animationID;
        this.gunDamage = gunDamage;
        this.rateOfFire = rateOfFire;
        this.magSize = magSize;
        this.ammoType = ammoType;
        this.reloadCooldown = reloadCooldown;
        this.bulletSpread = bulletSpread;
        this.gunRecoil = gunRecoil;
        this.pelletCount = pelletCount;
        this.loadingType = loadingType;
        this.reloadSoundStart = reloadSoundStart;
        this.reloadSoundMagOut = reloadSoundMagOut;
        this.reloadSoundMagIn = reloadSoundMagIn;
        this.reloadSoundEnd = reloadSoundEnd;
        this.shootSound = shootSound;
        this.reloadCycles = reloadCycles;
        this.isScoped = isScoped;
        this.unscopeAfterShot = unscopeAfterShot;
        this.reloadStage1 = reloadStage1;
        this.reloadStage2 = reloadStage2;
        this.reloadStage3 = reloadStage3;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", 16.0, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (hand == class_1268.field_5808 && !user.method_7357().method_7904((class_1792)this) && !user.method_5624() && GunItem.isLoaded(stack)) {
            this.shoot(world, user, stack);
            user.method_7357().method_7906((class_1792)this, this.rateOfFire);
        }
        return class_1271.method_22431((Object)stack);
    }

    public void shoot(class_1937 world, class_1657 user, class_1799 itemStack) {
        itemStack.method_7948().method_10569("reloadTick", 0);
        itemStack.method_7948().method_10556("isReloading", false);
        double h_kick = this.getRecoilX(itemStack);
        float v_kick = this.getRecoilY(itemStack);
        if (!world.method_8608()) {
            for (int i = 0; i < this.pelletCount; ++i) {
                BulletProjectileEntity bullet = new BulletProjectileEntity((class_1309)user, world, this.gunDamage);
                bullet.method_23327(user.method_23317(), user.method_23320(), user.method_23321());
                class_243 vertiSpread = BulletUtil.vertiSpread(user, this.random.nextFloat(-this.bulletSpread[0] * 5.0f, this.bulletSpread[0] * 5.0f));
                class_243 horiSpread = BulletUtil.horiSpread(user, this.random.nextFloat(-this.bulletSpread[1] * 5.0f, this.bulletSpread[1] * 5.0f));
                class_243 result = user.method_5720().method_1019(vertiSpread).method_1019(horiSpread);
                bullet.method_7485(result.method_10216(), result.method_10214(), result.method_10215(), 20.0f, 0.0f);
                bullet.setBaseVel(bullet.method_18798());
                world.method_8649((class_1297)bullet);
            }
            int id = GeckoLibUtil.guaranteeIDForStack((class_1799)itemStack, (class_3218)((class_3218)world));
            GeckoLibNetwork.syncAnimation((class_1657)user, (ISyncable)this, (int)id, (int)(!itemStack.method_7948().method_10577("isScoped") && itemStack.method_7948().method_10577("isAiming") ? 7 : 1));
            for (class_1657 otherPlayer : PlayerLookup.tracking((class_1297)user)) {
                GeckoLibNetwork.syncAnimation((class_1657)otherPlayer, (ISyncable)this, (int)id, (int)(!itemStack.method_7948().method_10577("isScoped") && itemStack.method_7948().method_10577("isAiming") ? 7 : 1));
            }
            class_2540 buf = PacketByteBufs.create();
            buf.writeFloat(v_kick);
            buf.writeDouble(h_kick);
            ServerPlayNetworking.send((class_3222)((class_3222)user), (class_2960)AnimatedGuns.RECOIL_PACKET_ID, (class_2540)buf);
        }
        if (!user.method_31549().field_7477) {
            itemStack.method_7948().method_10569("Clip", itemStack.method_7948().method_10550("Clip") - 1);
            itemStack.method_7956(10, (class_1309)user, e -> e.method_20235(class_1304.field_6173));
        }
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), this.shootSound, class_3419.field_15250, 1.0f, 1.0f);
        if (this.reloadCycles > 1) {
            itemStack.method_7948().method_10569("currentCycle", itemStack.method_7948().method_10550("Clip"));
        }
        if (this.shouldUnscopeAfterShot() && itemStack.method_7948().method_10577("isAiming")) {
            this.toggleAim(itemStack);
        }
    }

    private <P extends class_1792> PlayState predicate(AnimationEvent<P> event) {
        if (event.getController().getCurrentAnimation() == null || event.getController().getAnimationState() == AnimationState.Stopped) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        AnimationController controller = new AnimationController((IAnimatable)this, controllerName, 1.0f, this::predicate);
        controller.registerSoundListener(this::soundListener);
        animationData.addAnimationController(controller);
    }

    public void onAnimationSync(int id, int state) {
        AnimationController controller = GeckoLibUtil.getControllerForID((AnimationFactory)this.factory, (Integer)id, (String)controllerName);
        switch (state) {
            case 0: {
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                break;
            }
            case 1: {
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("firing", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE).addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                break;
            }
            case 2: {
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("reload_start", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                break;
            }
            case 3: {
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("reload_magout", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                break;
            }
            case 4: {
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("reload_magin", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                break;
            }
            case 5: {
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("reload_end", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE).addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                break;
            }
            case 6: {
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("aim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                break;
            }
            case 7: {
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("aim_firing", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE).addAnimation("aim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                break;
            }
            case 8: {
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("aim_reload_start", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                break;
            }
            case 9: {
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("melee", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE).addAnimation("idle"));
                break;
            }
            case 10: {
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("sprinting", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        }
    }

    protected <ENTITY extends IAnimatable> void soundListener(SoundKeyframeEvent<ENTITY> event) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            switch (event.sound) {
                case "reload_start": {
                    player.method_17356(this.reloadSoundStart, class_3419.field_15250, 1.0f, 1.0f);
                    break;
                }
                case "reload_magout": {
                    player.method_17356(this.reloadSoundMagOut, class_3419.field_15250, 1.0f, 1.0f);
                    break;
                }
                case "reload_magin": {
                    player.method_17356(this.reloadSoundMagIn, class_3419.field_15250, 1.0f, 1.0f);
                    break;
                }
                case "reload_end": {
                    player.method_17356(this.reloadSoundEnd, class_3419.field_15250, 1.0f, 1.0f);
                    break;
                }
                case "melee": {
                    player.method_5783(class_3417.field_14840, 1.0f, 1.0f);
                }
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private void setDefaultNBT(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        nbtCompound.method_10569("reloadTick", 0);
        nbtCompound.method_10569("currentCycle", 1);
        nbtCompound.method_10569("Clip", 0);
        nbtCompound.method_10556("isScoped", this.isScoped);
        nbtCompound.method_10556("isReloading", false);
        nbtCompound.method_10556("isAiming", false);
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        this.setDefaultNBT(stack);
        if (world instanceof class_3218) {
            int id = GeckoLibUtil.guaranteeIDForStack((class_1799)stack, (class_3218)((class_3218)world));
            GeckoLibNetwork.syncAnimation((class_1657)player, (ISyncable)this, (int)id, (int)0);
            for (class_1657 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
                GeckoLibNetwork.syncAnimation((class_1657)otherPlayer, (ISyncable)this, (int)id, (int)0);
            }
        }
        super.method_7843(stack, world, player);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)("Ammo: " + stack.method_7948().method_10550("Clip") + "/" + this.magSize)).method_27692(class_124.field_1068));
            tooltip.add((class_2561)class_2561.method_43471((String)("Damage: " + this.gunDamage)).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)("Recoil: " + this.gunRecoil[1])).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)("RPM: " + (int)(20.0f / (float)this.rateOfFire * 60.0f))).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)("Reload Time: " + (float)this.reloadCooldown / 20.0f + "s")).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)"Uses:").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)this.ammoType.method_7876()).method_27692(class_124.field_1054));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)("Ammo: " + stack.method_7948().method_10550("Clip") + "/" + this.magSize)).method_27692(class_124.field_1068));
            tooltip.add((class_2561)class_2561.method_43471((String)"Uses:").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)this.ammoType.method_7876()).method_27692(class_124.field_1054));
            tooltip.add((class_2561)class_2561.method_43471((String)"Press Shift to see stats").method_27692(class_124.field_1075));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_2487 nbtCompound = stack.method_7948();
        boolean isSprinting = entity.method_5624();
        class_1799 mainHandGun = ((class_1657)entity).method_6047();
        if (world.method_8608()) {
            class_2540 buf;
            if (mainHandGun == stack && AnimatedGunsClient.reloadToggle.method_1434() && GunItem.remainingAmmo(stack) < this.magSize && GunItem.reserveAmmoCount((class_1657)entity, this.ammoType) > 0 && !nbtCompound.method_10577("isReloading") && !isSprinting) {
                buf = PacketByteBufs.create();
                buf.writeBoolean(true);
                ClientPlayNetworking.send((class_2960)AnimatedGuns.RELOAD_PACKET_ID, (class_2540)buf);
            }
            if (mainHandGun == stack) {
                while (AnimatedGunsClient.meleeKey.method_1436()) {
                    buf = PacketByteBufs.create();
                    buf.method_10793(stack);
                    ClientPlayNetworking.send((class_2960)AnimatedGuns.GUN_MELEE_PACKET_SERVER_ID, (class_2540)buf);
                }
            }
            if (isSprinting && !mainHandGun.method_7948().method_10577("isAiming") && mainHandGun == stack && GeckoLibUtil.getControllerForStack((AnimationFactory)this.factory, (class_1799)stack, (String)controllerName).getCurrentAnimation() != null && !GeckoLibUtil.getControllerForStack((AnimationFactory)this.factory, (class_1799)stack, (String)controllerName).getCurrentAnimation().animationName.equals("sprinting") && !GeckoLibUtil.getControllerForStack((AnimationFactory)this.factory, (class_1799)stack, (String)controllerName).getCurrentAnimation().animationName.equals("melee")) {
                buf = PacketByteBufs.create();
                buf.method_10793(stack);
                buf.writeBoolean(true);
                ClientPlayNetworking.send((class_2960)AnimatedGuns.GUN_SPRINT_PACKET_ID, (class_2540)buf);
            } else if ((!isSprinting || mainHandGun != stack) && GeckoLibUtil.getControllerForStack((AnimationFactory)this.factory, (class_1799)stack, (String)controllerName).getCurrentAnimation() != null && GeckoLibUtil.getControllerForStack((AnimationFactory)this.factory, (class_1799)stack, (String)controllerName).getCurrentAnimation().animationName.equals("sprinting")) {
                buf = PacketByteBufs.create();
                buf.method_10793(stack);
                buf.writeBoolean(false);
                ClientPlayNetworking.send((class_2960)AnimatedGuns.GUN_SPRINT_PACKET_ID, (class_2540)buf);
            }
        }
        if (nbtCompound.method_10577("isReloading") && !isSprinting) {
            if (mainHandGun != stack || GunItem.reserveAmmoCount((class_1657)entity, this.ammoType) <= 0 && this.reloadCycles <= 1 || nbtCompound.method_10550("reloadTick") >= this.reloadCooldown || GunItem.remainingAmmo(stack) >= this.magSize && this.reloadCycles <= 1) {
                nbtCompound.method_10556("isReloading", false);
            }
            this.doReloadTick(world, nbtCompound, (class_1657)entity, stack);
        } else {
            if (nbtCompound.method_10550("reloadTick") > this.reloadStage3 && nbtCompound.method_10550("reloadTick") <= this.reloadCooldown) {
                this.finishReload((class_1657)entity, stack);
            }
            nbtCompound.method_10556("isReloading", false);
            nbtCompound.method_10569("reloadTick", 0);
        }
    }

    private void doReloadTick(class_1937 world, class_2487 nbtCompound, class_1657 player, class_1799 stack) {
        int rTick = nbtCompound.method_10550("reloadTick");
        if (world instanceof class_3218) {
            if (nbtCompound.method_10550("reloadTick") == this.reloadStage1) {
                int id = GeckoLibUtil.guaranteeIDForStack((class_1799)stack, (class_3218)((class_3218)world));
                GeckoLibNetwork.syncAnimation((class_1657)player, (ISyncable)this, (int)id, (int)3);
                for (class_1657 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
                    GeckoLibNetwork.syncAnimation((class_1657)otherPlayer, (ISyncable)this, (int)id, (int)3);
                }
            } else if (nbtCompound.method_10550("reloadTick") == this.reloadStage2) {
                int id = GeckoLibUtil.guaranteeIDForStack((class_1799)stack, (class_3218)((class_3218)world));
                GeckoLibNetwork.syncAnimation((class_1657)player, (ISyncable)this, (int)id, (int)4);
                for (class_1657 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
                    GeckoLibNetwork.syncAnimation((class_1657)otherPlayer, (ISyncable)this, (int)id, (int)4);
                }
            } else if (nbtCompound.method_10550("reloadTick") == this.reloadStage3) {
                int id = GeckoLibUtil.guaranteeIDForStack((class_1799)stack, (class_3218)((class_3218)world));
                GeckoLibNetwork.syncAnimation((class_1657)player, (ISyncable)this, (int)id, (int)5);
                for (class_1657 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
                    GeckoLibNetwork.syncAnimation((class_1657)otherPlayer, (ISyncable)this, (int)id, (int)5);
                }
            }
        }
        nbtCompound.method_10569("reloadTick", nbtCompound.method_10550("reloadTick") + 1);
        switch (this.loadingType) {
            case MAGAZINE: {
                if (rTick < this.reloadCooldown || GunItem.reserveAmmoCount(player, this.ammoType) <= 0) break;
                nbtCompound.method_10569("currentCycle", 1);
                this.finishReload(player, stack);
                nbtCompound.method_10569("reloadTick", 0);
                break;
            }
            case PER_CARTRIDGE: {
                if (rTick < this.reloadStage3 || nbtCompound.method_10550("currentCycle") >= this.reloadCycles || GunItem.reserveAmmoCount(player, this.ammoType) <= 0) break;
                nbtCompound.method_10569("Clip", nbtCompound.method_10550("Clip") + 1);
                InventoryUtil.removeItemFromInventory(player, this.ammoType, 1);
                if (GunItem.remainingAmmo(stack) < this.magSize && GunItem.reserveAmmoCount(player, this.ammoType) > 0) {
                    nbtCompound.method_10569("reloadTick", this.reloadStage2);
                }
                nbtCompound.method_10569("currentCycle", nbtCompound.method_10550("Clip"));
                stack.method_7974(this.method_7841() - (nbtCompound.method_10550("Clip") * 10 + 1));
            }
        }
    }

    public float getRecoilX(class_1799 stack) {
        boolean rd = this.random.nextBoolean();
        return stack.method_7948().method_10577("isAiming") ? (rd ? this.gunRecoil[0] : -this.gunRecoil[0]) / 2.0f : (rd ? this.gunRecoil[0] : -this.gunRecoil[0]);
    }

    public float getRecoilY(class_1799 stack) {
        return stack.method_7948().method_10577("isAiming") ? this.gunRecoil[1] / 2.0f : this.gunRecoil[1];
    }

    public static boolean isLoaded(class_1799 stack) {
        return GunItem.remainingAmmo(stack) > 0;
    }

    public void finishReload(class_1657 player, class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        int ammoToLoad = this.magSize - nbtCompound.method_10550("Clip");
        if (GunItem.reserveAmmoCount(player, this.ammoType) >= ammoToLoad) {
            nbtCompound.method_10569("Clip", nbtCompound.method_10550("Clip") + ammoToLoad);
            InventoryUtil.removeItemFromInventory(player, this.ammoType, ammoToLoad);
        } else {
            nbtCompound.method_10569("Clip", nbtCompound.method_10550("Clip") + GunItem.reserveAmmoCount(player, this.ammoType));
            InventoryUtil.removeItemFromInventory(player, this.ammoType, GunItem.reserveAmmoCount(player, this.ammoType));
        }
        stack.method_7974(this.method_7841() - (nbtCompound.method_10550("Clip") * 10 + 1));
    }

    public void aimAnimation(class_1799 stack, boolean aim, class_3218 world, class_1657 player) {
        stack.method_7948().method_10556("isAiming", aim);
        stack.method_7948().method_10556("isScoped", this.isScoped);
        if (aim) {
            player.method_5728(false);
        }
        int id = GeckoLibUtil.guaranteeIDForStack((class_1799)stack, (class_3218)world);
        GeckoLibNetwork.syncAnimation((class_1657)player, (ISyncable)this, (int)id, (int)(stack.method_7948().method_10577("isAiming") ? 6 : 0));
        for (class_1657 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
            GeckoLibNetwork.syncAnimation((class_1657)otherPlayer, (ISyncable)this, (int)id, (int)(stack.method_7948().method_10577("isAiming") ? 6 : 0));
        }
    }

    public void toggleSprint(class_1799 stack, boolean sprint, class_3218 world, class_1657 player) {
        int id = GeckoLibUtil.guaranteeIDForStack((class_1799)stack, (class_3218)world);
        GeckoLibNetwork.syncAnimation((class_1657)player, (ISyncable)this, (int)id, (int)(sprint ? 10 : 0));
        for (class_1657 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
            GeckoLibNetwork.syncAnimation((class_1657)otherPlayer, (ISyncable)this, (int)id, (int)(sprint ? 10 : 0));
        }
    }

    public void toggleAim(class_1799 itemStack) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(!itemStack.method_7948().method_10577("isAiming"));
        ClientPlayNetworking.send((class_2960)AnimatedGuns.GUN_AIM_PACKET_ID, (class_2540)buf);
    }

    public static int remainingAmmo(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        return nbtCompound.method_10550("Clip");
    }

    public static int reserveAmmoCount(class_1657 player, class_1792 item) {
        return InventoryUtil.itemCountInInventory(player, item);
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return false;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        if (slot == class_1304.field_6173) {
            return this.attributeModifiers;
        }
        return super.method_7844(slot);
    }

    public int method_31571(class_1799 stack) {
        return class_3532.method_15353((float)0.0f, (float)1.0f, (float)1.0f);
    }

    public int getRateOfFire() {
        return this.rateOfFire;
    }

    public boolean shouldUnscopeAfterShot() {
        return this.unscopeAfterShot;
    }

    public String getID() {
        return this.gunID;
    }

    public String getAnimationID() {
        return this.animationID;
    }

    public static enum LoadingType {
        MAGAZINE,
        PER_CARTRIDGE;

    }
}

