/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.semaphore;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.semaphore.SemaphoreBlockEntity;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRShapes;
import com.railwayteam.railways.registry.CRTags;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class SemaphoreBlock
extends class_2383
implements IBE<SemaphoreBlockEntity>,
IWrenchable {
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    public static final int girderPlacementHelperId = PlacementHelpers.register((IPlacementHelper)new GirderPlacementHelper());
    public static final class_2746 FLIPPED = class_2746.method_11825((String)"flipped");
    public static final class_2746 FULL = class_2746.method_11825((String)"full");
    public static final class_2746 UPSIDE_DOWN = class_2746.method_11825((String)"upside_down");

    public SemaphoreBlock(class_4970.class_2251 pProperties) {
        super(pProperties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FLIPPED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FULL, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(new class_2769[]{field_11177}).method_11667(new class_2769[]{FLIPPED}).method_11667(new class_2769[]{FULL}).method_11667(new class_2769[]{UPSIDE_DOWN}));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 ray) {
        class_1799 heldItem = player.method_5998(hand);
        class_1799 itemInHand = player.method_5998(hand);
        IPlacementHelper helper = PlacementHelpers.get((int)girderPlacementHelperId);
        if (helper.matchesItem(itemInHand)) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (class_1747)itemInHand.method_7909(), player, hand, ray);
        }
        return class_1269.field_5811;
    }

    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        if (state == null) {
            return null;
        }
        class_2350 facing = context.method_8042().method_10153();
        class_243 look = context.method_8036().method_5720();
        class_243 cross = look.method_1036(new class_243(facing.method_23955()));
        boolean flipped = cross.field_1351 < 0.0;
        boolean upside_down = context.method_8038() == class_2350.field_11033 && (Boolean)CRConfigs.server().semaphores.simplifiedPlacement.get() == false;
        return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)field_11177, (Comparable)facing)).method_11657((class_2769)FLIPPED, (Comparable)Boolean.valueOf(flipped))).method_11657((class_2769)UPSIDE_DOWN, (Comparable)Boolean.valueOf(upside_down));
    }

    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_2680 rotated;
        class_1937 world = context.method_8045();
        boolean upsideDownChanged = false;
        if (context.method_8038().method_10166() != class_2350.class_2351.field_11052) {
            if (context.method_8038() == state.method_11654((class_2769)field_11177)) {
                rotated = (class_2680)state.method_28493((class_2769)FLIPPED);
            } else if (context.method_8038() == ((class_2350)state.method_11654((class_2769)field_11177)).method_10153() && !((Boolean)CRConfigs.server().semaphores.simplifiedPlacement.get()).booleanValue()) {
                rotated = (class_2680)state.method_28493((class_2769)UPSIDE_DOWN);
                upsideDownChanged = true;
            } else {
                rotated = (class_2680)state.method_11657((class_2769)field_11177, (Comparable)context.method_8038());
            }
        } else {
            rotated = this.getRotatedBlockState(state, context.method_8038());
        }
        if (!rotated.method_26184((class_4538)world, context.method_8037())) {
            return class_1269.field_5811;
        }
        KineticBlockEntity.switchToBlockState((class_1937)world, (class_2338)context.method_8037(), (class_2680)this.updateAfterWrenched(rotated, context));
        class_2586 te = context.method_8045().method_8321(context.method_8037());
        if (upsideDownChanged) {
            class_2680 rotatedState;
            class_2680 blockState;
            int i;
            class_2338 currentPos = context.method_8037().method_10074();
            for (i = 0; i < 16; ++i) {
                blockState = world.method_8320(currentPos);
                if (CRBlocks.SEMAPHORE.has(blockState)) {
                    rotatedState = (class_2680)blockState.method_11657((class_2769)UPSIDE_DOWN, (Comparable)((Boolean)rotated.method_11654((class_2769)UPSIDE_DOWN)));
                    KineticBlockEntity.switchToBlockState((class_1937)world, (class_2338)currentPos, (class_2680)class_2248.method_9510((class_2680)rotatedState, (class_1936)world, (class_2338)currentPos));
                } else if (!CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState)) break;
                currentPos = currentPos.method_10074();
            }
            currentPos = context.method_8037().method_10084();
            for (i = 0; i < 16; ++i) {
                blockState = world.method_8320(currentPos);
                if (CRBlocks.SEMAPHORE.has(blockState)) {
                    rotatedState = (class_2680)blockState.method_11657((class_2769)UPSIDE_DOWN, (Comparable)((Boolean)rotated.method_11654((class_2769)UPSIDE_DOWN)));
                    KineticBlockEntity.switchToBlockState((class_1937)world, (class_2338)currentPos, (class_2680)class_2248.method_9510((class_2680)rotatedState, (class_1936)world, (class_2338)currentPos));
                } else if (!CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState)) break;
                currentPos = currentPos.method_10084();
            }
        }
        if (world.method_8320(context.method_8037()) != state) {
            this.playRotateSound(world, context.method_8037());
        }
        return class_1269.field_5812;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean isMoving) {
        class_2680 rotatedState;
        class_2680 blockState;
        int i;
        super.method_9615(state, world, pos, oldState, isMoving);
        class_2338 currentPos = pos.method_10074();
        for (i = 0; i < 16; ++i) {
            blockState = world.method_8320(currentPos);
            if (CRBlocks.SEMAPHORE.has(blockState)) {
                rotatedState = (class_2680)blockState.method_11657((class_2769)UPSIDE_DOWN, (Comparable)((Boolean)state.method_11654((class_2769)UPSIDE_DOWN)));
                KineticBlockEntity.switchToBlockState((class_1937)world, (class_2338)currentPos, (class_2680)class_2248.method_9510((class_2680)rotatedState, (class_1936)world, (class_2338)currentPos));
            } else if (!CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState)) break;
            currentPos = currentPos.method_10074();
        }
        currentPos = pos.method_10084();
        for (i = 0; i < 16; ++i) {
            blockState = world.method_8320(currentPos);
            if (CRBlocks.SEMAPHORE.has(blockState)) {
                rotatedState = (class_2680)blockState.method_11657((class_2769)UPSIDE_DOWN, (Comparable)((Boolean)state.method_11654((class_2769)UPSIDE_DOWN)));
                KineticBlockEntity.switchToBlockState((class_1937)world, (class_2338)currentPos, (class_2680)class_2248.method_9510((class_2680)rotatedState, (class_1936)world, (class_2338)currentPos));
            } else if (!CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState)) break;
            currentPos = currentPos.method_10084();
        }
    }

    public Class<SemaphoreBlockEntity> getBlockEntityClass() {
        return SemaphoreBlockEntity.class;
    }

    public class_2591<? extends SemaphoreBlockEntity> getBlockEntityType() {
        return (class_2591)CRBlockEntities.SEMAPHORE.get();
    }

    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return CRShapes.SEMAPHORE.get((class_2350)pState.method_11654((class_2769)field_11177));
    }

    public static class PlacementHelper
    implements IPlacementHelper {
        public Predicate<class_1799> getItemPredicate() {
            return arg_0 -> CRBlocks.SEMAPHORE.isIn(arg_0);
        }

        public Predicate<class_2680> getStatePredicate() {
            return state -> CRBlocks.SEMAPHORE.has(state) || CRTags.AllBlockTags.SEMAPHORE_POLES.matches((class_2680)state);
        }

        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            class_2350 offsetDirection = ray.method_17784().method_1020((class_243)class_243.method_24953((class_2382)pos)).field_1351 < 0.0 ? class_2350.field_11033 : class_2350.field_11036;
            class_2338 newPos = pos.method_10093(offsetDirection);
            class_2680 newState = world.method_8320(newPos);
            if (!newState.method_26207().method_15800()) {
                newPos = pos.method_10093(offsetDirection.method_10153());
                newState = world.method_8320(newPos);
            }
            if (newState.method_26207().method_15800()) {
                class_2350 facing = ray.method_17780();
                if (facing.method_10166() == class_2350.class_2351.field_11052) {
                    return PlacementOffset.fail();
                }
                class_243 look = player.method_5720();
                class_243 cross = look.method_1036(new class_243(facing.method_23955()));
                boolean flipped = cross.field_1351 < 0.0;
                boolean upsideDown = offsetDirection == class_2350.field_11033 && (Boolean)CRConfigs.server().semaphores.simplifiedPlacement.get() == false;
                return PlacementOffset.success((class_2382)newPos, x -> (class_2680)((class_2680)((class_2680)x.method_11657((class_2769)FLIPPED, (Comparable)Boolean.valueOf(flipped))).method_11657((class_2769)class_2383.field_11177, (Comparable)facing)).method_11657((class_2769)UPSIDE_DOWN, (Comparable)Boolean.valueOf(upsideDown)));
            }
            return PlacementOffset.fail();
        }

        public void displayGhost(PlacementOffset offset) {
            if (!offset.hasGhostState()) {
                return;
            }
            CreateClient.GHOST_BLOCKS.showGhostState((Object)this, (class_2680)offset.getTransform().apply((class_2680)offset.getGhostState().method_11657((class_2769)FULL, (Comparable)Boolean.valueOf(true)))).at(offset.getBlockPos()).breathingAlpha();
        }
    }

    public static class GirderPlacementHelper
    implements IPlacementHelper {
        public Predicate<class_1799> getItemPredicate() {
            return CRTags.AllBlockTags.SEMAPHORE_POLES::matches;
        }

        public Predicate<class_2680> getStatePredicate() {
            return arg_0 -> CRBlocks.SEMAPHORE.has(arg_0);
        }

        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            class_2350 offsetDirection = ray.method_17784().method_1020((class_243)class_243.method_24953((class_2382)pos)).field_1351 < 0.0 ? class_2350.field_11033 : class_2350.field_11036;
            class_2338 newPos = pos.method_10093(offsetDirection);
            class_2680 newState = world.method_8320(newPos);
            if (!newState.method_26207().method_15800()) {
                newPos = pos.method_10093(offsetDirection.method_10153());
                newState = world.method_8320(newPos);
            }
            if (newState.method_26207().method_15800()) {
                class_2350 facing = ray.method_17780();
                if (facing.method_10166() == class_2350.class_2351.field_11052) {
                    return PlacementOffset.fail();
                }
                return PlacementOffset.success((class_2382)newPos);
            }
            return PlacementOffset.fail();
        }
    }
}

