/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.railwayteam.railways.mixin_interfaces.IMonorailBezier;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackRenderer;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={BezierConnection.class}, remap=false)
public abstract class MixinBezierConnectionClient
implements IMonorailBezier {
    private IMonorailBezier.MonorailAngles[] bakedMonorails;

    @Shadow
    public abstract int getSegmentCount();

    @Override
    @Environment(value=EnvType.CLIENT)
    public IMonorailBezier.MonorailAngles[] getBakedMonorails() {
        if (this.bakedMonorails != null) {
            return this.bakedMonorails;
        }
        int segmentCount = this.getSegmentCount();
        this.bakedMonorails = new IMonorailBezier.MonorailAngles[segmentCount + 1];
        Couple previousOffsets = null;
        BezierConnection this_ = (BezierConnection)this;
        for (BezierConnection.Segment segment : this_) {
            int i = segment.index;
            boolean end = i == 0 || i == segmentCount;
            IMonorailBezier.MonorailAngles angles = this.bakedMonorails[i] = new IMonorailBezier.MonorailAngles();
            class_243 mainGirder = segment.position;
            class_243 upNormal = segment.derivative.method_1029().method_1036(segment.normal);
            class_243 firstGirderOffset = upNormal.method_1021(0.5);
            class_243 secondGirderOffset = upNormal.method_1021(-0.625);
            class_243 mainTop = segment.position.method_1019(firstGirderOffset);
            class_243 mainBottom = mainTop.method_1019(secondGirderOffset);
            angles.lightPosition = new class_2338(mainGirder);
            Couple offsets = Couple.create((Object)mainTop, (Object)mainBottom);
            if (previousOffsets == null) {
                previousOffsets = offsets;
                continue;
            }
            angles.beam = null;
            angles.beamCaps = Couple.create(null, null);
            float scale = end ? 2.3f : 2.2f;
            class_243 currentBeam = ((class_243)offsets.getFirst()).method_1019((class_243)offsets.getSecond()).method_1021(0.5);
            class_243 previousBeam = ((class_243)previousOffsets.getFirst()).method_1019((class_243)previousOffsets.getSecond()).method_1021(0.5);
            class_243 beamDiff = currentBeam.method_1020(previousBeam);
            class_243 beamAngles = TrackRenderer.getModelAngles((class_243)segment.normal, (class_243)beamDiff);
            class_4587 poseStack = new class_4587();
            ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((class_4587)poseStack).translate(previousBeam)).rotateYRadians(beamAngles.field_1351)).rotateXRadians(beamAngles.field_1352)).rotateZRadians(beamAngles.field_1350)).translate(0.0, (double)(0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f), -0.03125)).scale(1.0f, 1.0f, (float)beamDiff.method_1033() * scale);
            angles.beam = poseStack.method_23760();
            for (boolean top : Iterate.trueAndFalse) {
                class_243 current = (class_243)offsets.get(top);
                class_243 previous = (class_243)previousOffsets.get(top);
                class_243 diff = current.method_1020(previous);
                class_243 capAngles = TrackRenderer.getModelAngles((class_243)segment.normal, (class_243)diff);
                poseStack = new class_4587();
                ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((class_4587)poseStack).translate(previous)).rotateYRadians(capAngles.field_1351)).rotateXRadians(capAngles.field_1352)).rotateZRadians(capAngles.field_1350)).translate(0.0, (double)(0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f), -0.03125)).rotateZ(0.0)).scale(1.0f, 1.0f, (float)diff.method_1033() * scale);
                angles.beamCaps.set(top, (Object)poseStack.method_23760());
            }
            previousOffsets = offsets;
        }
        return this.bakedMonorails;
    }

    @ModifyExpressionValue(method={"getBakedSegments"}, at={@At(value="CONSTANT", args={"doubleValue=0.9649999737739563"})})
    private double modifyRailWidth(double original) {
        BezierConnection this$ = (BezierConnection)this;
        if (this$.getMaterial().trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
            return original + 0.5;
        }
        if (this$.getMaterial().trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE) {
            return original - 0.4375;
        }
        return original;
    }
}

