/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.jozufozu.flywheel.core.PartialModel;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class CRBlockPartials {
    public static final Map<class_1767, PartialModel> TOOLBOX_BODIES = new EnumMap<class_1767, PartialModel>(class_1767.class);
    public static final Map<class_1767, PartialModel> CONDUCTOR_WHISTLE_FLAGS = new EnumMap<class_1767, PartialModel>(class_1767.class);
    public static final Map<String, PartialModel> CUSTOM_CONDUCTOR_CAPS = new HashMap<String, PartialModel>();
    public static final Map<String, PartialModel> CUSTOM_CONDUCTOR_ONLY_CAPS = new HashMap<String, PartialModel>();
    public static final Map<String, class_2960> CUSTOM_CONDUCTOR_SKINS = new HashMap<String, class_2960>();
    public static final Set<String> NO_TILT_CAPS = new HashSet<String>();
    public static final Map<String, class_2960> CUSTOM_CONDUCTOR_SKINS_FOR_NAME = new HashMap<String, class_2960>();
    public static final PartialModel SEMAPHORE_ARM_RED = CRBlockPartials.block("semaphore/red_arm");
    public static final PartialModel SEMAPHORE_ARM_YELLOW = CRBlockPartials.block("semaphore/yellow_arm");
    public static final PartialModel SEMAPHORE_ARM_RED_FLIPPED = CRBlockPartials.block("semaphore/red_arm_flipped");
    public static final PartialModel SEMAPHORE_ARM_YELLOW_FLIPPED = CRBlockPartials.block("semaphore/yellow_arm_flipped");
    public static final PartialModel SEMAPHORE_ARM_RED_UPSIDE_DOWN = CRBlockPartials.block("semaphore/red_arm_down");
    public static final PartialModel SEMAPHORE_ARM_YELLOW_UPSIDE_DOWN = CRBlockPartials.block("semaphore/yellow_arm_down");
    public static final PartialModel SEMAPHORE_ARM_RED_FLIPPED_UPSIDE_DOWN = CRBlockPartials.block("semaphore/red_arm_flipped_down");
    public static final PartialModel SEMAPHORE_ARM_YELLOW_FLIPPED_UPSIDE_DOWN = CRBlockPartials.block("semaphore/yellow_arm_flipped_down");
    public static final PartialModel SEMAPHORE_LAMP_RED = CRBlockPartials.block("semaphore/red_lamp");
    public static final PartialModel SEMAPHORE_LAMP_YELLOW = CRBlockPartials.block("semaphore/yellow_lamp");
    public static final PartialModel SEMAPHORE_LAMP_WHITE = CRBlockPartials.block("semaphore/white_lamp");
    public static final EnumMap<TrackShape, TrackCasingSpec> TRACK_CASINGS = new EnumMap(TrackShape.class);
    public static final PartialModel TRACK_CASING_FLAT = CRBlockPartials.block("track_casing/flat");
    public static final PartialModel TRACK_CASING_FLAT_THICK = CRBlockPartials.block("track_casing/flat_thick");
    private static final PartialModel xo = CRBlockPartials.block("track_casing/xo");
    private static final PartialModel zo = CRBlockPartials.block("track_casing/zo");
    private static final PartialModel pd = CRBlockPartials.block("track_casing/pd");
    private static final PartialModel nd = CRBlockPartials.block("track_casing/nd");
    private static final PartialModel cr_o = CRBlockPartials.block("track_casing/cr_o");
    private static final PartialModel an = CRBlockPartials.block("track_casing/an");
    private static final PartialModel as = CRBlockPartials.block("track_casing/as");
    private static final PartialModel ae = CRBlockPartials.block("track_casing/ae");
    private static final PartialModel aw = CRBlockPartials.block("track_casing/aw");
    private static final PartialModel xo_wide = CRBlockPartials.block("track_casing/xo_wide");
    private static final PartialModel zo_wide = CRBlockPartials.block("track_casing/zo_wide");
    private static final PartialModel pd_wide = CRBlockPartials.block("track_casing/pd_wide");
    private static final PartialModel nd_wide = CRBlockPartials.block("track_casing/nd_wide");
    private static final PartialModel cr_o_wide = CRBlockPartials.block("track_casing/cr_o_wide");
    private static final PartialModel an_wide = CRBlockPartials.block("track_casing/an_wide");
    private static final PartialModel as_wide = CRBlockPartials.block("track_casing/as_wide");
    private static final PartialModel ae_wide = CRBlockPartials.block("track_casing/ae_wide");
    private static final PartialModel aw_wide = CRBlockPartials.block("track_casing/aw_wide");
    private static final PartialModel xo_narrow = CRBlockPartials.block("track_casing/xo_narrow");
    private static final PartialModel zo_narrow = CRBlockPartials.block("track_casing/zo_narrow");
    private static final PartialModel pd_narrow = CRBlockPartials.block("track_casing/pd_narrow");
    private static final PartialModel nd_narrow = CRBlockPartials.block("track_casing/nd_narrow");
    private static final PartialModel cr_o_narrow = CRBlockPartials.block("track_casing/cr_o_narrow");
    private static final PartialModel an_narrow = CRBlockPartials.block("track_casing/an_narrow");
    private static final PartialModel as_narrow = CRBlockPartials.block("track_casing/as_narrow");
    private static final PartialModel ae_narrow = CRBlockPartials.block("track_casing/ae_narrow");
    private static final PartialModel aw_narrow = CRBlockPartials.block("track_casing/aw_narrow");
    public static final PartialModel COUPLER_COUPLE;
    public static final PartialModel COUPLER_DECOUPLE;
    public static final PartialModel COUPLER_BOTH;
    public static final PartialModel COUPLER_NONE;
    public static final PartialModel ANDESITE_SWITCH_FLAG;
    public static final PartialModel ANDESITE_SWITCH_HANDLE;
    public static final PartialModel BRASS_SWITCH_FLAG;
    public static final PartialModel SWITCH_NONE;
    public static final PartialModel SWITCH_RIGHT_STRAIGHT;
    public static final PartialModel SWITCH_RIGHT_TURN;
    public static final PartialModel SWITCH_LEFT_STRAIGHT;
    public static final PartialModel SWITCH_LEFT_TURN;
    public static final PartialModel SWITCH_3WAY_STRAIGHT;
    public static final PartialModel SWITCH_3WAY_LEFT;
    public static final PartialModel SWITCH_3WAY_RIGHT;
    public static final PartialModel SWITCH_2WAY_LEFT;
    public static final PartialModel SWITCH_2WAY_RIGHT;
    public static final PartialModel MONORAIL_SEGMENT_TOP;
    public static final PartialModel MONORAIL_SEGMENT_BOTTOM;
    public static final PartialModel MONORAIL_SEGMENT_MIDDLE;
    public static final PartialModel MONORAIL_TRACK_ASSEMBLING_OVERLAY;
    public static final PartialModel MONOBOGEY_FRAME;
    public static final PartialModel MONOBOGEY_WHEEL;
    public static final PartialModel LONG_SHAFTED_WHEELS;
    public static final PartialModel SINGLEAXLE_FRAME;
    public static final PartialModel LEAFSPRING_FRAME;
    public static final PartialModel COILSPRING_FRAME;
    public static final PartialModel FREIGHT_FRAME;
    public static final PartialModel ARCHBAR_FRAME;
    public static final PartialModel PASSENGER_FRAME;
    public static final PartialModel MODERN_FRAME;
    public static final PartialModel BLOMBERG_FRAME;
    public static final PartialModel Y25_FRAME;
    public static final PartialModel HEAVYWEIGHT_FRAME;
    public static final PartialModel RADIAL_FRAME;
    public static final PartialModel CR_BOGEY_WHEELS;
    public static final PartialModel CR_WIDE_BOGEY_WHEELS;
    public static final PartialModel WIDE_DEFAULT_FRAME;
    public static final PartialModel WIDE_SCOTCH_FRAME;
    public static final PartialModel WIDE_SCOTCH_PINS;
    public static final PartialModel WIDE_SCOTCH_PISTONS;
    public static final PartialModel WIDE_SCOTCH_WHEELS;
    public static final PartialModel WIDE_COMICALLY_LARGE_FRAME;
    public static final PartialModel WIDE_COMICALLY_LARGE_PINS;
    public static final PartialModel WIDE_COMICALLY_LARGE_PISTONS;
    public static final PartialModel WIDE_COMICALLY_LARGE_WHEELS;
    public static final PartialModel NARROW_WHEELS;
    public static final PartialModel NARROW_FRAME;
    public static final PartialModel NARROW_SCOTCH_WHEELS;
    public static final PartialModel NARROW_SCOTCH_WHEEL_PINS;
    public static final PartialModel NARROW_SCOTCH_FRAME;
    public static final PartialModel NARROW_SCOTCH_PISTONS;
    public static final PartialModel NARROW_DOUBLE_SCOTCH_FRAME;
    public static final PartialModel NARROW_DOUBLE_SCOTCH_PISTONS;
    public static final PartialModel HANDCAR_WHEELS;
    public static final PartialModel HANDCAR_COUPLING;
    public static final PartialModel HANDCAR_FRAME;
    public static final PartialModel HANDCAR_HANDLE;
    public static final PartialModel HANDCAR_HANDLE_FIRST_PERSON;
    public static final PartialModel HANDCAR_LARGE_COG;
    public static final PartialModel HANDCAR_SMALL_COG;
    public static final PartialModel PORTABLE_FUEL_INTERFACE_MIDDLE;
    public static final PartialModel PORTABLE_FUEL_INTERFACE_MIDDLE_POWERED;
    public static final PartialModel PORTABLE_FUEL_INTERFACE_TOP;
    public static final PartialModel MEDIUM_SHARED_WHEELS;
    public static final PartialModel MEDIUM_STANDARD_FRAME;
    public static final PartialModel MEDIUM_SINGLE_WHEEL_FRAME;
    public static final PartialModel MEDIUM_TRIPLE_WHEEL_FRAME;
    public static final PartialModel MEDIUM_QUADRUPLE_WHEEL_FRAME;
    public static final PartialModel MEDIUM_QUINTUPLE_WHEEL_FRAME;
    public static final PartialModel MEDIUM_2_0_2_TRAILING_FRAME;
    public static final PartialModel MEDIUM_4_0_4_TRAILING_FRAME;
    public static final PartialModel MEDIUM_6_0_6_TRAILING_FRAME;
    public static final PartialModel MEDIUM_6_0_6_TENDER_FRAME;
    public static final PartialModel MEDIUM_8_0_8_TENDER_FRAME;
    public static final PartialModel MEDIUM_10_0_10_TENDER_FRAME;
    public static final PartialModel LC_STYLE_SEMI_BLIND_WHEELS;
    public static final PartialModel LC_STYLE_FULL_BLIND_WHEELS;
    public static final PartialModel LARGE_CREATE_STYLED_0_4_0_FRAME;
    public static final PartialModel LARGE_CREATE_STYLED_0_4_0_PISTON;
    public static final PartialModel LARGE_CREATE_STYLED_0_6_0_FRAME;
    public static final PartialModel LARGE_CREATE_STYLED_0_6_0_PISTON;
    public static final PartialModel LARGE_CREATE_STYLED_0_8_0_FRAME;
    public static final PartialModel LARGE_CREATE_STYLED_0_8_0_PISTON;
    public static final PartialModel LARGE_CREATE_STYLED_0_10_0_FRAME;
    public static final PartialModel LARGE_CREATE_STYLED_0_10_0_PISTON;
    public static final PartialModel LARGE_CREATE_STYLED_0_12_0_FRAME;
    public static final PartialModel LARGE_CREATE_STYLED_0_12_0_PISTON;
    public static final PartialModel DIESEL_STACK_FAN;
    public static final PartialModel CONDUCTOR_ANTENNA;

    public static void registerCustomCap(String itemName, String modelLoc) {
        CUSTOM_CONDUCTOR_CAPS.put(itemName, new PartialModel(Railways.asResource("item/dev_caps/" + modelLoc)));
    }

    public static void registerCustomCap(String itemName, String modelLoc, boolean preventTilting) {
        CUSTOM_CONDUCTOR_CAPS.put(itemName, new PartialModel(Railways.asResource("item/dev_caps/" + modelLoc)));
        if (preventTilting) {
            NO_TILT_CAPS.add(itemName);
        }
    }

    public static void registerCustomConductorOnlyCap(String itemName, String modelLoc) {
        CUSTOM_CONDUCTOR_ONLY_CAPS.put(itemName, new PartialModel(Railways.asResource("item/dev_caps/" + modelLoc)));
    }

    public static void registerCustomConductorOnlyCap(String itemName, String modelLoc, boolean preventTilting) {
        CUSTOM_CONDUCTOR_ONLY_CAPS.put(itemName, new PartialModel(Railways.asResource("item/dev_caps/" + modelLoc)));
        if (preventTilting) {
            NO_TILT_CAPS.add(itemName);
        }
    }

    public static boolean shouldPreventTiltingCap(String name) {
        return NO_TILT_CAPS.contains(name);
    }

    public static void registerCustomSkin(String itemName, String textureLoc) {
        CUSTOM_CONDUCTOR_SKINS.put(itemName, Railways.asResource("textures/entity/custom_conductors/" + textureLoc));
    }

    public static void registerCustomConductorNameBasedSkin(String conductorName, String textureLoc) {
        CUSTOM_CONDUCTOR_SKINS_FOR_NAME.put(conductorName, Railways.asResource("textures/entity/custom_conductors/" + textureLoc));
    }

    public static void registerCasingSpecs() {
        TRACK_CASINGS.clear();
        TrackCasingSpec spec_5x5 = new TrackCasingSpec(TRACK_CASING_FLAT, 3);
        for (int xOff = -2; xOff <= 2; ++xOff) {
            for (int zOff = -2; zOff <= 2; ++zOff) {
                if (xOff == 0 && zOff == 0) continue;
                spec_5x5.addTransform(xOff, zOff);
            }
        }
        TrackCasingSpec spec_3x3_cross = new TrackCasingSpec(TRACK_CASING_FLAT, 3).addTransform(-1.0, 0.0).addTransform(1.0, 0.0).addTransform(0.0, -1.0).addTransform(0.0, 1.0);
        TrackCasingSpec spec_3x3 = new TrackCasingSpec(TRACK_CASING_FLAT, 3).addTransform(1.0, 1.0).addTransform(0.0, 1.0).addTransform(-1.0, 1.0).addTransform(1.0, 0.0).addTransform(-1.0, 0.0).addTransform(1.0, -1.0).addTransform(0.0, -1.0).addTransform(-1.0, -1.0).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, spec_5x5);
        spec_3x3.withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, spec_3x3.copy().withAltSpec(spec_3x3_cross));
        TrackCasingSpec flat_x = new TrackCasingSpec(TRACK_CASING_FLAT, 3).addTransform(0.0, 1.0).addTransform(0.0, -1.0).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(TRACK_CASING_FLAT, 3).addTransform(0.0, -2.0).addTransform(0.0, -1.0).addTransform(0.0, 1.0).addTransform(0.0, 2.0));
        TrackCasingSpec flat_z = new TrackCasingSpec(TRACK_CASING_FLAT, 3).addTransform(1.0, 0.0).addTransform(-1.0, 0.0).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(TRACK_CASING_FLAT, 3).addTransform(-2.0, 0.0).addTransform(-1.0, 0.0).addTransform(1.0, 0.0).addTransform(2.0, 0.0));
        TRACK_CASINGS.put(TrackShape.XO, new TrackCasingSpec(xo, 8).withAltSpec(flat_x).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(xo_wide, 8)).withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, new TrackCasingSpec(xo_narrow, 8)));
        TRACK_CASINGS.put(TrackShape.ZO, new TrackCasingSpec(zo, 8).withAltSpec(flat_z).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(zo_wide, 8)).withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, new TrackCasingSpec(zo_narrow, 8)));
        TRACK_CASINGS.put(TrackShape.PD, new TrackCasingSpec(pd, 8).withAltSpec(new TrackCasingSpec(TRACK_CASING_FLAT, 3).addTransform(1.0, 0.0).addTransform(1.0, -1.0).addTransform(0.0, 1.0).addTransform(-1.0, 1.0)).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(pd_wide, 8).withAltSpec(new TrackCasingSpec(TRACK_CASING_FLAT, 3).addTransform(1.0, 0.0).addTransform(1.0, -1.0).addTransform(2.0, -1.0).addTransform(0.0, 1.0).addTransform(-1.0, 1.0).addTransform(-1.0, 2.0))).withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, new TrackCasingSpec(pd_narrow, 8)));
        TRACK_CASINGS.put(TrackShape.ND, new TrackCasingSpec(nd, 8).withAltSpec(new TrackCasingSpec(TRACK_CASING_FLAT, 3).addTransform(-1.0, 0.0).addTransform(-1.0, -1.0).addTransform(0.0, 1.0).addTransform(1.0, 1.0)).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(nd_wide, 8).withAltSpec(new TrackCasingSpec(TRACK_CASING_FLAT, 3).addTransform(-1.0, 0.0).addTransform(-1.0, -1.0).addTransform(-2.0, -1.0).addTransform(0.0, 1.0).addTransform(1.0, 1.0).addTransform(1.0, 2.0))).withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, new TrackCasingSpec(nd_narrow, 8)));
        TRACK_CASINGS.put(TrackShape.TE, new TrackCasingSpec(xo, 8).withAltSpec(flat_x).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(xo_wide, 8)).withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, new TrackCasingSpec(xo_narrow, 8)));
        TRACK_CASINGS.put(TrackShape.TW, new TrackCasingSpec(xo, 8).withAltSpec(flat_x).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(xo_wide, 8)).withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, new TrackCasingSpec(xo_narrow, 8)));
        TRACK_CASINGS.put(TrackShape.TN, new TrackCasingSpec(zo, 8).withAltSpec(flat_z).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(zo_wide, 8)).withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, new TrackCasingSpec(zo_narrow, 8)));
        TRACK_CASINGS.put(TrackShape.TS, new TrackCasingSpec(zo, 8).withAltSpec(flat_z).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(zo_wide, 8)).withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, new TrackCasingSpec(zo_narrow, 8)));
        TRACK_CASINGS.put(TrackShape.CR_O, new TrackCasingSpec(cr_o, 8).withAltSpec(spec_3x3).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(cr_o_wide, 8)).withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, new TrackCasingSpec(cr_o_narrow, 8)));
        TRACK_CASINGS.put(TrackShape.CR_D, new TrackCasingSpec(TRACK_CASING_FLAT, 3).addTransform(1.0, 2.0).addTransform(0.0, 2.0).addTransform(-1.0, 2.0).addTransform(2.0, 1.0).addTransform(1.0, 1.0).addTransform(0.0, 1.0).addTransform(-1.0, 1.0).addTransform(-2.0, 1.0).addTransform(2.0, 0.0).addTransform(1.0, 0.0).addTransform(-1.0, 0.0).addTransform(-2.0, 0.0).addTransform(1.0, -1.0).addTransform(0.0, -1.0).addTransform(-1.0, -1.0).addTransform(0.0, -2.0).withAltSpec(spec_3x3).withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, spec_3x3_cross));
        TRACK_CASINGS.put(TrackShape.CR_PDX, spec_3x3);
        TRACK_CASINGS.put(TrackShape.CR_PDZ, spec_3x3);
        TRACK_CASINGS.put(TrackShape.CR_NDX, spec_3x3);
        TRACK_CASINGS.put(TrackShape.CR_NDZ, spec_3x3);
        TRACK_CASINGS.put(TrackShape.AN, new TrackCasingSpec(an, 5).overlayShift(0.0, 0.1875).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(an_wide, 5)).withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, new TrackCasingSpec(an_narrow, 5)));
        TRACK_CASINGS.put(TrackShape.AS, new TrackCasingSpec(as, 5).overlayShift(0.0, -0.1875).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(as_wide, 5)).withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, new TrackCasingSpec(as_narrow, 5)));
        TRACK_CASINGS.put(TrackShape.AE, new TrackCasingSpec(ae, 5).overlayShift(-0.1875, 0.0).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(ae_wide, 5)).withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, new TrackCasingSpec(ae_narrow, 5)));
        TRACK_CASINGS.put(TrackShape.AW, new TrackCasingSpec(aw, 5).overlayShift(0.1875, 0.0).withTrackType(CRTrackMaterials.CRTrackType.WIDE_GAUGE, new TrackCasingSpec(aw_wide, 5)).withTrackType(CRTrackMaterials.CRTrackType.NARROW_GAUGE, new TrackCasingSpec(aw_narrow, 5)));
    }

    private static PartialModel createBlock(String path) {
        return new PartialModel(Create.asResource((String)("block/" + path)));
    }

    private static PartialModel block(String path) {
        return new PartialModel(Railways.asResource("block/" + path));
    }

    public static void init() {
    }

    static {
        CRBlockPartials.registerCasingSpecs();
        COUPLER_COUPLE = CRBlockPartials.block("track_overlay/coupler_couple");
        COUPLER_DECOUPLE = CRBlockPartials.block("track_overlay/coupler_decouple");
        COUPLER_BOTH = CRBlockPartials.block("track_overlay/coupler_both");
        COUPLER_NONE = CRBlockPartials.block("track_overlay/coupler_none");
        ANDESITE_SWITCH_FLAG = CRBlockPartials.block("track_switch_andesite/flag");
        ANDESITE_SWITCH_HANDLE = CRBlockPartials.block("track_switch_andesite/handle");
        BRASS_SWITCH_FLAG = CRBlockPartials.block("track_switch_brass/flag");
        SWITCH_NONE = CRBlockPartials.block("track_overlay/switch_none");
        SWITCH_RIGHT_STRAIGHT = CRBlockPartials.block("track_overlay/switch_right_straight");
        SWITCH_RIGHT_TURN = CRBlockPartials.block("track_overlay/switch_right_turn");
        SWITCH_LEFT_STRAIGHT = CRBlockPartials.block("track_overlay/switch_left_straight");
        SWITCH_LEFT_TURN = CRBlockPartials.block("track_overlay/switch_left_turn");
        SWITCH_3WAY_STRAIGHT = CRBlockPartials.block("track_overlay/switch_3way_straight");
        SWITCH_3WAY_LEFT = CRBlockPartials.block("track_overlay/switch_3way_left");
        SWITCH_3WAY_RIGHT = CRBlockPartials.block("track_overlay/switch_3way_right");
        SWITCH_2WAY_LEFT = CRBlockPartials.block("track_overlay/switch_2way_left");
        SWITCH_2WAY_RIGHT = CRBlockPartials.block("track_overlay/switch_2way_right");
        MONORAIL_SEGMENT_TOP = CRBlockPartials.block("monorail/monorail/segment_top");
        MONORAIL_SEGMENT_BOTTOM = CRBlockPartials.block("monorail/monorail/segment_bottom");
        MONORAIL_SEGMENT_MIDDLE = CRBlockPartials.block("monorail/monorail/segment_middle");
        MONORAIL_TRACK_ASSEMBLING_OVERLAY = CRBlockPartials.block("monorail/monorail/assembling_overlay");
        MONOBOGEY_FRAME = CRBlockPartials.block("bogey/monorail/frame");
        MONOBOGEY_WHEEL = CRBlockPartials.block("bogey/monorail/wheel");
        LONG_SHAFTED_WHEELS = CRBlockPartials.block("bogey/wheels/long_shaft_wheels");
        SINGLEAXLE_FRAME = CRBlockPartials.block("bogey/singleaxle/frame");
        LEAFSPRING_FRAME = CRBlockPartials.block("bogey/leafspring/frame");
        COILSPRING_FRAME = CRBlockPartials.block("bogey/coilspring/frame");
        FREIGHT_FRAME = CRBlockPartials.block("bogey/freight/frame");
        ARCHBAR_FRAME = CRBlockPartials.block("bogey/archbar/frame");
        PASSENGER_FRAME = CRBlockPartials.block("bogey/passenger/frame");
        MODERN_FRAME = CRBlockPartials.block("bogey/modern/frame");
        BLOMBERG_FRAME = CRBlockPartials.block("bogey/blomberg/frame");
        Y25_FRAME = CRBlockPartials.block("bogey/y25/frame");
        HEAVYWEIGHT_FRAME = CRBlockPartials.block("bogey/heavyweight/frame");
        RADIAL_FRAME = CRBlockPartials.block("bogey/radial/radial_frame");
        CR_BOGEY_WHEELS = CRBlockPartials.block("bogey/wheels/cr_bogey_wheels");
        CR_WIDE_BOGEY_WHEELS = CRBlockPartials.block("bogey/wide/wheels");
        WIDE_DEFAULT_FRAME = CRBlockPartials.block("bogey/wide/default/frame");
        WIDE_SCOTCH_FRAME = CRBlockPartials.block("bogey/wide/scotch_yoke/frame");
        WIDE_SCOTCH_PINS = CRBlockPartials.block("bogey/wide/scotch_yoke/pins");
        WIDE_SCOTCH_PISTONS = CRBlockPartials.block("bogey/wide/scotch_yoke/pistons");
        WIDE_SCOTCH_WHEELS = CRBlockPartials.block("bogey/wide/scotch_yoke/wheels");
        WIDE_COMICALLY_LARGE_FRAME = CRBlockPartials.block("bogey/wide/comically_large/frame");
        WIDE_COMICALLY_LARGE_PINS = CRBlockPartials.block("bogey/wide/comically_large/pins");
        WIDE_COMICALLY_LARGE_PISTONS = CRBlockPartials.block("bogey/wide/comically_large/pistons");
        WIDE_COMICALLY_LARGE_WHEELS = CRBlockPartials.block("bogey/wide/comically_large/wheels");
        NARROW_WHEELS = CRBlockPartials.block("bogey/narrow/wheels");
        NARROW_FRAME = CRBlockPartials.block("bogey/narrow/default_small/frame");
        NARROW_SCOTCH_WHEELS = CRBlockPartials.block("bogey/narrow/scotch_wheels");
        NARROW_SCOTCH_WHEEL_PINS = CRBlockPartials.block("bogey/narrow/scotch_wheel_pins");
        NARROW_SCOTCH_FRAME = CRBlockPartials.block("bogey/narrow/default_scotch/frame");
        NARROW_SCOTCH_PISTONS = CRBlockPartials.block("bogey/narrow/default_scotch/pistons");
        NARROW_DOUBLE_SCOTCH_FRAME = CRBlockPartials.block("bogey/narrow/double_scotch/frame");
        NARROW_DOUBLE_SCOTCH_PISTONS = CRBlockPartials.block("bogey/narrow/double_scotch/pistons");
        HANDCAR_WHEELS = CRBlockPartials.block("bogey/handcar/wheels");
        HANDCAR_COUPLING = CRBlockPartials.block("bogey/handcar/coupling");
        HANDCAR_FRAME = CRBlockPartials.block("bogey/handcar/frame");
        HANDCAR_HANDLE = CRBlockPartials.block("bogey/handcar/handle");
        HANDCAR_HANDLE_FIRST_PERSON = CRBlockPartials.block("bogey/handcar/handle_first_person");
        HANDCAR_LARGE_COG = CRBlockPartials.block("bogey/handcar/large_cog");
        HANDCAR_SMALL_COG = CRBlockPartials.block("bogey/handcar/small_cog");
        PORTABLE_FUEL_INTERFACE_MIDDLE = CRBlockPartials.block("portable_fuel_interface/block_middle");
        PORTABLE_FUEL_INTERFACE_MIDDLE_POWERED = CRBlockPartials.block("portable_fuel_interface/block_middle_powered");
        PORTABLE_FUEL_INTERFACE_TOP = CRBlockPartials.block("portable_fuel_interface/block_top");
        MEDIUM_SHARED_WHEELS = CRBlockPartials.block("bogey/medium/shared/wheels");
        MEDIUM_STANDARD_FRAME = CRBlockPartials.block("bogey/medium/standard/frame");
        MEDIUM_SINGLE_WHEEL_FRAME = CRBlockPartials.block("bogey/medium/single_wheel/frame");
        MEDIUM_TRIPLE_WHEEL_FRAME = CRBlockPartials.block("bogey/medium/triple_wheel/frame");
        MEDIUM_QUADRUPLE_WHEEL_FRAME = CRBlockPartials.block("bogey/medium/quadruple_wheel/frame");
        MEDIUM_QUINTUPLE_WHEEL_FRAME = CRBlockPartials.block("bogey/medium/quintuple_wheel/frame");
        MEDIUM_2_0_2_TRAILING_FRAME = CRBlockPartials.block("bogey/medium/2_0_2_trailing/frame");
        MEDIUM_4_0_4_TRAILING_FRAME = CRBlockPartials.block("bogey/medium/4_0_4_trailing/frame");
        MEDIUM_6_0_6_TRAILING_FRAME = CRBlockPartials.block("bogey/medium/6_0_6_trailing/frame");
        MEDIUM_6_0_6_TENDER_FRAME = CRBlockPartials.block("bogey/medium/6_0_6_tender/frame");
        MEDIUM_8_0_8_TENDER_FRAME = CRBlockPartials.block("bogey/medium/8_0_8_tender/frame");
        MEDIUM_10_0_10_TENDER_FRAME = CRBlockPartials.block("bogey/medium/10_0_10_tender/frame");
        LC_STYLE_SEMI_BLIND_WHEELS = CRBlockPartials.block("bogey/large/wheels/semi_blind_wheels");
        LC_STYLE_FULL_BLIND_WHEELS = CRBlockPartials.block("bogey/large/wheels/full_blind_wheels");
        LARGE_CREATE_STYLED_0_4_0_FRAME = CRBlockPartials.block("bogey/large/create_styled_0_4_0/frame/frame");
        LARGE_CREATE_STYLED_0_4_0_PISTON = CRBlockPartials.block("bogey/large/create_styled_0_4_0/piston/piston");
        LARGE_CREATE_STYLED_0_6_0_FRAME = CRBlockPartials.block("bogey/large/create_styled_0_6_0/frame/frame");
        LARGE_CREATE_STYLED_0_6_0_PISTON = CRBlockPartials.block("bogey/large/create_styled_0_6_0/piston/piston");
        LARGE_CREATE_STYLED_0_8_0_FRAME = CRBlockPartials.block("bogey/large/create_styled_0_8_0/frame/frame");
        LARGE_CREATE_STYLED_0_8_0_PISTON = CRBlockPartials.block("bogey/large/create_styled_0_8_0/piston/piston");
        LARGE_CREATE_STYLED_0_10_0_FRAME = CRBlockPartials.block("bogey/large/create_styled_0_10_0/frame/frame");
        LARGE_CREATE_STYLED_0_10_0_PISTON = CRBlockPartials.block("bogey/large/create_styled_0_10_0/piston/piston");
        LARGE_CREATE_STYLED_0_12_0_FRAME = CRBlockPartials.block("bogey/large/create_styled_0_12_0/frame/frame");
        LARGE_CREATE_STYLED_0_12_0_PISTON = CRBlockPartials.block("bogey/large/create_styled_0_12_0/piston/piston");
        DIESEL_STACK_FAN = CRBlockPartials.block("smokestack/block_diesel_fan");
        CONDUCTOR_ANTENNA = CRBlockPartials.block("conductor_antenna");
        for (class_1767 color : class_1767.values()) {
            TOOLBOX_BODIES.put(color, CRBlockPartials.createBlock(Lang.asId((String)color.name()) + "_toolbox"));
            CONDUCTOR_WHISTLE_FLAGS.put(color, CRBlockPartials.block("conductor_whistle/flag_" + Lang.asId((String)color.name())));
        }
    }

    public static final class TrackCasingSpec {
        public final PartialModel model;
        public final ModelTransform transform;
        public final List<ModelTransform> additionalTransforms = new ArrayList<ModelTransform>();
        private TrackCasingSpec altSpec;
        private final Map<TrackMaterial.TrackType, TrackCasingSpec> specsByTrackType = new HashMap<TrackMaterial.TrackType, TrackCasingSpec>();
        private final int topSurfacePixelHeight;
        private double xShift = 0.0;
        private double zShift = 0.0;
        private boolean shiftSet = false;

        public TrackCasingSpec(PartialModel model, int topSurfacePixelHeight) {
            this(model, ModelTransform.ZERO, topSurfacePixelHeight);
        }

        public TrackCasingSpec(PartialModel model, ModelTransform transform, int topSurfacePixelHeight) {
            this.model = model;
            this.transform = transform;
            this.topSurfacePixelHeight = topSurfacePixelHeight;
        }

        public TrackCasingSpec getFor(@Nullable TrackMaterial.TrackType type) {
            if (type == null || !this.specsByTrackType.containsKey(type)) {
                return this;
            }
            return this.specsByTrackType.get(type);
        }

        public TrackCasingSpec addTransform(ModelTransform transform) {
            this.additionalTransforms.add(transform);
            return this;
        }

        public TrackCasingSpec addTransform(double x, double z) {
            return this.addTransform(ModelTransform.of(x, z));
        }

        public TrackCasingSpec withAltSpec(@Nullable TrackCasingSpec altSpec) {
            this.altSpec = altSpec;
            return this;
        }

        public TrackCasingSpec getAltSpec() {
            return this.altSpec != null ? this.altSpec : this;
        }

        public int getTopSurfacePixelHeight(boolean alt) {
            return alt && this.altSpec != null ? this.altSpec.topSurfacePixelHeight : this.topSurfacePixelHeight;
        }

        @Nullable
        public TrackCasingSpec getAltSpec(@Nullable TrackMaterial.TrackType type) {
            if (type == null) {
                return this.getAltSpec();
            }
            if (this.altSpec != null && this.altSpec.specsByTrackType.containsKey(type)) {
                return this.altSpec.specsByTrackType.get(type);
            }
            if (this.specsByTrackType.containsKey(type) && this.specsByTrackType.get((Object)type).altSpec != null) {
                return this.specsByTrackType.get((Object)type).altSpec;
            }
            return null;
        }

        public TrackCasingSpec getNonNullAltSpec(@Nullable TrackMaterial.TrackType type) {
            TrackCasingSpec spec = this.getAltSpec(type);
            if (spec == null) {
                spec = this.getAltSpec();
            }
            return spec;
        }

        public int getTopSurfacePixelHeight(@Nullable TrackMaterial.TrackType type, boolean alt) {
            TrackCasingSpec altSpec;
            if (type == null) {
                return this.getTopSurfacePixelHeight(alt);
            }
            if (alt && (altSpec = this.getAltSpec(type)) != null) {
                return altSpec.topSurfacePixelHeight;
            }
            return this.getTopSurfacePixelHeight(alt);
        }

        public TrackCasingSpec withTrackType(@NotNull TrackMaterial.TrackType type, @Nullable TrackCasingSpec spec) {
            if (spec == null) {
                this.specsByTrackType.remove(type);
            } else {
                this.specsByTrackType.put(type, spec);
            }
            return this;
        }

        public TrackCasingSpec overlayShift(double x, double z) {
            this.xShift = x;
            this.zShift = z;
            this.shiftSet = true;
            return this;
        }

        public double getXShift() {
            return this.xShift;
        }

        public double getZShift() {
            return this.zShift;
        }

        public double getXShift(@Nullable TrackMaterial.TrackType type) {
            return this.getFor((TrackMaterial.TrackType)type).shiftSet ? this.getFor(type).getXShift() : this.getXShift();
        }

        public double getZShift(@Nullable TrackMaterial.TrackType type) {
            return this.getFor((TrackMaterial.TrackType)type).shiftSet ? this.getFor(type).getZShift() : this.getZShift();
        }

        public TrackCasingSpec copy() {
            TrackCasingSpec copy = new TrackCasingSpec(this.model, this.transform, this.topSurfacePixelHeight);
            copy.xShift = this.xShift;
            copy.zShift = this.zShift;
            copy.shiftSet = this.shiftSet;
            copy.additionalTransforms.addAll(this.additionalTransforms);
            return copy;
        }
    }

    public record ModelTransform(double x, double y, double z, float rx, float ry, float rz) {
        public static final ModelTransform ZERO = new ModelTransform(0.0, 0.0, 0.0, 0.0f, 0.0f, 0.0f);

        public static ModelTransform of(double x, double y, double z, float rx, float ry, float rz) {
            return new ModelTransform(x, y, z, rx, ry, rz);
        }

        public static ModelTransform of(double x, double y, double z) {
            return ModelTransform.of(x, y, z, 0.0f, 0.0f, 0.0f);
        }

        public static ModelTransform of(double x, double z) {
            return ModelTransform.of(x, 0.0, z);
        }
    }
}

