/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.multiblock;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.MultiblockWriter;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.StringUtils;
import reborncore.common.util.Torus;
import techreborn.api.recipe.recipes.FusionReactorRecipe;
import techreborn.blockentity.machine.GenericMachineBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModRecipes;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class FusionControlComputerBlockEntity
extends GenericMachineBlockEntity
implements BuiltScreenHandlerProvider {
    public int craftingTickTime = 0;
    public int neededPower = 0;
    public int size = 6;
    public int state = -1;
    int topStackSlot = 0;
    int bottomStackSlot = 1;
    int outputStackSlot = 2;
    FusionReactorRecipe currentRecipe = null;
    class_2960 currentRecipeID = null;
    boolean hasStartedCrafting = false;
    boolean checkNBTRecipe = false;
    long lastTick = -1L;

    public FusionControlComputerBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.FUSION_CONTROL_COMPUTER, pos, state, "FusionControlComputer", -1, -1, TRContent.Machine.FUSION_CONTROL_COMPUTER.block, -1);
        this.inventory = new RebornInventory(3, "FusionControlComputerBlockEntity", 64, (MachineBaseBlockEntity)this);
    }

    public FusionReactorRecipe getCurrentRecipeFromID() {
        if (this.currentRecipeID == null) {
            return null;
        }
        return ModRecipes.FUSION_REACTOR.getRecipes(this.field_11863).stream().filter(recipe -> recipe.method_8114().equals((Object)this.currentRecipeID)).findFirst().orElse(null);
    }

    public class_2561 getStateText() {
        if (this.state == -1) {
            return class_2561.method_43473();
        }
        if (this.state == 0) {
            return class_2561.method_43471((String)"gui.techreborn.fusion.norecipe");
        }
        if (this.state == 1) {
            FusionReactorRecipe r = this.getCurrentRecipeFromID();
            if (r == null) {
                return class_2561.method_43471((String)"gui.techreborn.fusion.charging");
            }
            int percentage = this.percentage(r.getStartEnergy(), this.getEnergy());
            return class_2561.method_43469((String)"gui.techreborn.fusion.chargingdetailed", (Object[])new Object[]{StringUtils.getPercentageText((int)percentage)});
        }
        if (this.state == 2) {
            return class_2561.method_43471((String)"gui.techreborn.fusion.crafting");
        }
        return class_2561.method_43473();
    }

    public void changeSize(int sizeDelta) {
        int newSize = this.size + sizeDelta;
        this.size = Math.max(6, Math.min(TechRebornConfig.fusionControlComputerMaxCoilSize, newSize));
    }

    private void resetCrafter() {
        this.currentRecipe = null;
        this.craftingTickTime = 0;
        this.neededPower = 0;
        this.hasStartedCrafting = false;
    }

    public boolean canFitStack(class_1799 stack, int slot, boolean tags) {
        if (stack.method_7960()) {
            return true;
        }
        if (this.inventory.method_5438(slot).method_7960()) {
            return true;
        }
        if (ItemUtils.isItemEqual((class_1799)this.inventory.method_5438(slot), (class_1799)stack, (boolean)true, (boolean)tags)) {
            return stack.method_7947() + this.inventory.method_5438(slot).method_7947() <= stack.method_7914();
        }
        return false;
    }

    private void updateCurrentRecipe() {
        for (RebornRecipe recipe : ModRecipes.FUSION_REACTOR.getRecipes(this.method_10997())) {
            if (!this.validateRecipe((FusionReactorRecipe)recipe)) continue;
            this.currentRecipe = (FusionReactorRecipe)recipe;
            this.craftingTickTime = 0;
            this.neededPower = this.currentRecipe.getStartEnergy();
            this.hasStartedCrafting = false;
            break;
        }
    }

    private boolean validateRecipe(FusionReactorRecipe recipe) {
        return this.hasAllInputs(recipe) && this.canFitStack((class_1799)recipe.getOutputs().get(0), this.outputStackSlot, true);
    }

    private boolean hasAllInputs(RebornRecipe recipeType) {
        if (recipeType == null) {
            return false;
        }
        for (RebornIngredient ingredient : recipeType.getRebornIngredients()) {
            boolean hasItem = false;
            if (ingredient.test(this.inventory.method_5438(this.topStackSlot)) || ingredient.test(this.inventory.method_5438(this.bottomStackSlot))) {
                hasItem = true;
            }
            if (hasItem) continue;
            return false;
        }
        return true;
    }

    private void useInput(int slot) {
        if (this.currentRecipe == null) {
            return;
        }
        for (RebornIngredient ingredient : this.currentRecipe.getRebornIngredients()) {
            if (!ingredient.test(this.inventory.method_5438(slot))) continue;
            this.inventory.shrinkSlot(slot, ingredient.getCount());
            break;
        }
    }

    private int percentage(double MaxValue, double CurrentValue) {
        if (CurrentValue == 0.0) {
            return 0;
        }
        return (int)(CurrentValue * 100.0 / MaxValue);
    }

    @Override
    public int getProgressScaled(int scale) {
        FusionReactorRecipe reactorRecipe = this.getCurrentRecipeFromID();
        if (this.craftingTickTime != 0 && reactorRecipe != null && reactorRecipe.getTime() != 0) {
            return this.craftingTickTime * scale / reactorRecipe.getTime();
        }
        return 0;
    }

    @Override
    public long getBaseMaxPower() {
        return Math.min((long)((double)TechRebornConfig.fusionControlComputerMaxEnergy * this.getPowerMultiplier()), Long.MAX_VALUE);
    }

    @Override
    public long getBaseMaxOutput() {
        if (!this.hasStartedCrafting) {
            return 0L;
        }
        return TechRebornConfig.fusionControlComputerMaxOutput;
    }

    @Override
    public long getBaseMaxInput() {
        if (this.hasStartedCrafting) {
            return 0L;
        }
        return TechRebornConfig.fusionControlComputerMaxInput;
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.field_9236) {
            return;
        }
        if (this.checkNBTRecipe) {
            this.checkNBTRecipe = false;
            for (RebornRecipe reactorRecipe : ModRecipes.FUSION_REACTOR.getRecipes(this.method_10997())) {
                if (!this.validateRecipe((FusionReactorRecipe)reactorRecipe)) continue;
                this.currentRecipe = (FusionReactorRecipe)reactorRecipe;
            }
        }
        if (this.lastTick == world.method_8510()) {
            return;
        }
        this.lastTick = world.method_8510();
        if (world.method_8510() % 20L == 0L) {
            this.inventory.setHashChanged();
        }
        if (!this.isMultiblockValid()) {
            this.resetCrafter();
            return;
        }
        if (this.currentRecipe == null && this.inventory.hasChanged()) {
            this.updateCurrentRecipe();
        }
        if (this.currentRecipe != null) {
            class_1799 result;
            if (!this.hasStartedCrafting && !this.validateRecipe(this.currentRecipe)) {
                this.resetCrafter();
                this.inventory.resetHasChanged();
                return;
            }
            if (!this.hasStartedCrafting && this.getStored() > (long)this.currentRecipe.getStartEnergy()) {
                this.useEnergy(this.currentRecipe.getStartEnergy());
                this.hasStartedCrafting = true;
                this.useInput(this.topStackSlot);
                this.useInput(this.bottomStackSlot);
            }
            if (this.hasStartedCrafting && this.craftingTickTime < this.currentRecipe.getTime()) {
                if (this.currentRecipe.getPower() > 0) {
                    long power = (long)((double)Math.abs(this.currentRecipe.getPower()) * this.getPowerMultiplier());
                    this.addEnergy(power);
                    this.powerChange = power;
                    ++this.craftingTickTime;
                } else if (this.getStored() > (long)this.currentRecipe.getPower()) {
                    this.setEnergy(this.getEnergy() - (long)this.currentRecipe.getPower());
                    ++this.craftingTickTime;
                }
            } else if (this.craftingTickTime >= this.currentRecipe.getTime() && this.canFitStack(result = (class_1799)this.currentRecipe.getOutputs().get(0), this.outputStackSlot, true)) {
                if (this.inventory.method_5438(this.outputStackSlot).method_7960()) {
                    this.inventory.method_5447(this.outputStackSlot, result.method_7972());
                } else {
                    this.inventory.shrinkSlot(this.outputStackSlot, -result.method_7947());
                }
                if (this.validateRecipe(this.currentRecipe)) {
                    this.craftingTickTime = 0;
                    this.useInput(this.topStackSlot);
                    this.useInput(this.bottomStackSlot);
                } else {
                    this.resetCrafter();
                }
            }
            this.method_5431();
        }
        this.inventory.resetHasChanged();
    }

    protected boolean canAcceptEnergy(@Nullable class_2350 side) {
        return side != class_2350.field_11033 && side != class_2350.field_11036;
    }

    @Override
    public boolean canProvideEnergy(@Nullable class_2350 side) {
        return side == class_2350.field_11033 || side == class_2350.field_11036;
    }

    public void method_11014(class_2487 tagCompound) {
        super.method_11014(tagCompound);
        this.craftingTickTime = tagCompound.method_10550("craftingTickTime");
        this.neededPower = tagCompound.method_10550("neededPower");
        this.hasStartedCrafting = tagCompound.method_10577("hasStartedCrafting");
        if (tagCompound.method_10545("hasActiveRecipe") && tagCompound.method_10577("hasActiveRecipe") && this.currentRecipe == null) {
            this.checkNBTRecipe = true;
        }
        if (tagCompound.method_10545("size")) {
            this.size = tagCompound.method_10550("size");
        }
        this.size = Math.min(this.size, TechRebornConfig.fusionControlComputerMaxCoilSize);
    }

    public void method_11007(class_2487 tagCompound) {
        super.method_11007(tagCompound);
        tagCompound.method_10569("craftingTickTime", this.craftingTickTime);
        tagCompound.method_10569("neededPower", this.neededPower);
        tagCompound.method_10556("hasStartedCrafting", this.hasStartedCrafting);
        tagCompound.method_10556("hasActiveRecipe", this.currentRecipe != null);
        tagCompound.method_10569("size", this.size);
    }

    public double getPowerMultiplier() {
        double calc = 0.5 * Math.pow(this.size - 5, 1.8);
        return Math.max((double)Math.round(calc * 100.0) / 100.0, 1.0);
    }

    public void writeMultiblock(MultiblockWriter writer) {
        class_2680 coil = TRContent.Machine.FUSION_COIL.block.method_9564();
        Torus.getOriginPositions((int)this.size).forEach(pos -> writer.add(pos.method_10263(), pos.method_10264(), pos.method_10260(), coil));
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("fusionreactor").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 34, 47).slot(1, 126, 47).outputSlot(2, 80, 47).syncEnergyValue().sync(this::getCraftingTickTime, this::setCraftingTickTime).sync(this::getSize, this::setSize).sync(this::getState, this::setState).sync(this::getNeededPower, this::setNeededPower).sync(this::getCurrentRecipeID, this::setCurrentRecipeID).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getCraftingTickTime() {
        return this.craftingTickTime;
    }

    public void setCraftingTickTime(int craftingTickTime) {
        this.craftingTickTime = craftingTickTime;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getState() {
        if (this.currentRecipe == null) {
            return 0;
        }
        if (!this.hasStartedCrafting) {
            return 1;
        }
        return 2;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getNeededPower() {
        return this.neededPower;
    }

    public void setNeededPower(int neededPower) {
        this.neededPower = neededPower;
    }

    public class_2960 getCurrentRecipeID() {
        if (this.currentRecipe == null) {
            return new class_2960("null", "null");
        }
        return this.currentRecipe.method_8114();
    }

    public void setCurrentRecipeID(class_2960 currentRecipeID) {
        if (currentRecipeID.method_12832().equals("null")) {
            currentRecipeID = null;
        }
        this.currentRecipeID = currentRecipeID;
    }
}

