/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModSounds;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class AutoCraftingTableBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
BuiltScreenHandlerProvider {
    public static final int CRAFTING_HEIGHT = 3;
    public static final int CRAFTING_WIDTH = 3;
    public static final int CRAFTING_AREA = 9;
    public RebornInventory<AutoCraftingTableBlockEntity> inventory = new RebornInventory(11, "AutoCraftingTableBlockEntity", 64, (MachineBaseBlockEntity)this);
    private final int OUTPUT_SLOT = 9;
    private final int EXTRA_OUTPUT_SLOT = 10;
    public int progress;
    public int maxProgress = 120;
    public int euTick = 10;
    public int balanceSlot = 0;
    class_1715 inventoryCrafting = null;
    class_3955 lastRecipe = null;
    class_1792[] layoutInv = new class_1792[9];
    public boolean locked = false;

    public AutoCraftingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.AUTO_CRAFTING_TABLE, pos, state);
    }

    @Nullable
    public class_3955 getCurrentRecipe() {
        if (this.field_11863 == null) {
            return null;
        }
        class_1715 crafting = this.getCraftingInventory();
        if (crafting.method_5442()) {
            return null;
        }
        if (this.lastRecipe != null && this.lastRecipe.method_8115((class_1263)crafting, this.field_11863)) {
            return this.lastRecipe;
        }
        Object[] currentInvLayout = this.getCraftingLayout(crafting);
        if (Arrays.equals(this.layoutInv, currentInvLayout)) {
            return null;
        }
        this.layoutInv = currentInvLayout;
        Optional testRecipe = this.field_11863.method_8433().method_8132(class_3956.field_17545, (class_1263)crafting, this.field_11863);
        if (testRecipe.isPresent()) {
            this.lastRecipe = (class_3955)testRecipe.get();
            return this.lastRecipe;
        }
        return null;
    }

    private class_1792[] getCraftingLayout(class_1715 craftingInventory) {
        class_1792[] layout = new class_1792[9];
        for (int i = 0; i < 9; ++i) {
            layout[i] = craftingInventory.method_5438(i).method_7909();
        }
        return layout;
    }

    private class_1715 getCraftingInventory() {
        if (this.inventoryCrafting == null) {
            this.inventoryCrafting = new class_1715(new class_1703(null, -1){

                public class_1799 method_7601(class_1657 player, int index) {
                    return class_1799.field_8037;
                }

                public boolean method_7597(class_1657 playerIn) {
                    return false;
                }
            }, 3, 3);
        }
        for (int i = 0; i < 9; ++i) {
            this.inventoryCrafting.method_5447(i, this.inventory.method_5438(i));
        }
        return this.inventoryCrafting;
    }

    private boolean canMake(class_3955 recipe) {
        if (this.field_11863 == null) {
            return false;
        }
        if (recipe == null) {
            return false;
        }
        class_1715 crafting = this.getCraftingInventory();
        if (crafting.method_5442()) {
            return false;
        }
        if (this.locked) {
            for (int i = 0; i < 9; ++i) {
                if (crafting.method_5438(i).method_7947() != 1) continue;
                return false;
            }
        }
        if (!recipe.method_8115((class_1263)crafting, this.field_11863)) {
            return false;
        }
        if (!this.hasOutputSpace(recipe.method_8110(), 9)) {
            return false;
        }
        class_2371 remainingStacks = recipe.method_8111((class_1263)crafting);
        for (class_1799 stack : remainingStacks) {
            if (stack.method_7960() || this.hasRoomForExtraItem(stack)) continue;
            return false;
        }
        return true;
    }

    private boolean hasRoomForExtraItem(class_1799 stack) {
        class_1799 extraOutputSlot = this.inventory.method_5438(10);
        if (extraOutputSlot.method_7960()) {
            return true;
        }
        return this.hasOutputSpace(stack, 10);
    }

    private boolean hasOutputSpace(class_1799 output, int slot) {
        class_1799 stack = this.inventory.method_5438(slot);
        if (stack.method_7960()) {
            return true;
        }
        if (ItemUtils.isItemEqual((class_1799)stack, (class_1799)output, (boolean)true, (boolean)true)) {
            return stack.method_7914() > stack.method_7947() + output.method_7947();
        }
        return false;
    }

    private boolean make(class_3955 recipe) {
        if (recipe == null || !this.canMake(recipe)) {
            return false;
        }
        class_2371 ingredients = recipe.method_8117();
        boolean[] slotUsed = new boolean[9];
        for (int i = 0; i < recipe.method_8117().size(); ++i) {
            class_1799 bestSlot;
            class_1856 ingredient = (class_1856)ingredients.get(i);
            if (ingredient.method_8093(bestSlot = this.inventory.method_5438(i)) && !slotUsed[i]) {
                slotUsed[i] = true;
                class_1799 remainderStack = this.getRemainderItem(bestSlot);
                bestSlot.method_7934(1);
                if (remainderStack.method_7960()) continue;
                this.moveExtraOutput(remainderStack);
                continue;
            }
            for (int j = 0; j < 9; ++j) {
                class_1799 stack = this.inventory.method_5438(j);
                if (!ingredient.method_8093(stack) || slotUsed[j]) continue;
                slotUsed[j] = true;
                class_1799 remainderStack = this.getRemainderItem(stack);
                stack.method_7934(1);
                if (remainderStack.method_7960()) continue;
                this.moveExtraOutput(remainderStack);
            }
        }
        class_1799 output = this.inventory.method_5438(9);
        class_1799 outputStack = recipe.method_8116((class_1263)this.getCraftingInventory());
        if (output.method_7960()) {
            this.inventory.method_5447(9, outputStack.method_7972());
        } else {
            output.method_7933(recipe.method_8110().method_7947());
        }
        return true;
    }

    private void moveExtraOutput(class_1799 stack) {
        class_1799 currentExtraOutput = this.inventory.method_5438(10);
        if (currentExtraOutput.method_7960()) {
            this.inventory.method_5447(10, stack.method_7972());
        } else {
            currentExtraOutput.method_7933(stack.method_7947());
        }
    }

    private class_1799 getRemainderItem(class_1799 stack) {
        if (stack.method_7909().method_7857()) {
            return new class_1799((class_1935)stack.method_7909().method_7858());
        }
        return class_1799.field_8037;
    }

    private Optional<class_1715> balanceRecipe(class_1715 craftCache) {
        class_1799 sourceStack;
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return Optional.empty();
        }
        if (craftCache.method_5442()) {
            return Optional.empty();
        }
        class_3955 currentRecipe = this.getCurrentRecipe();
        if (currentRecipe == null) {
            return Optional.empty();
        }
        ++this.balanceSlot;
        if (this.balanceSlot > craftCache.method_5439()) {
            this.balanceSlot = 0;
        }
        if ((sourceStack = this.inventory.method_5438(this.balanceSlot)).method_7960()) {
            return Optional.empty();
        }
        ArrayList<Integer> possibleSlots = new ArrayList<Integer>();
        block0: for (int s = 0; s < currentRecipe.method_8117().size(); ++s) {
            for (int i = 0; i < 9; ++i) {
                if (possibleSlots.contains(i)) continue;
                class_1799 stackInSlot = this.inventory.method_5438(i);
                class_1856 ingredient = (class_1856)currentRecipe.method_8117().get(s);
                if (ingredient == class_1856.field_9017 || !ingredient.method_8093(sourceStack) || stackInSlot.method_7909() != sourceStack.method_7909()) continue;
                possibleSlots.add(i);
                continue block0;
            }
        }
        if (!possibleSlots.isEmpty()) {
            int totalItems = possibleSlots.stream().mapToInt(value -> this.inventory.method_5438(value.intValue()).method_7947()).sum();
            int slots = possibleSlots.size();
            int[] split = new int[slots];
            int remainder = totalItems % slots;
            Arrays.fill(split, totalItems / slots);
            while (remainder > 0) {
                for (int i = 0; i < split.length; ++i) {
                    if (remainder <= 0) continue;
                    int n = i;
                    split[n] = split[n] + 1;
                    --remainder;
                }
            }
            List slotDistribution = possibleSlots.stream().mapToInt(value -> this.inventory.method_5438(value.intValue()).method_7947()).boxed().collect(Collectors.toList());
            boolean needsBalance = false;
            for (int required : split) {
                if (slotDistribution.contains(required)) {
                    slotDistribution.remove((Object)required);
                    continue;
                }
                needsBalance = true;
            }
            if (!needsBalance) {
                return Optional.empty();
            }
        } else {
            return Optional.empty();
        }
        Pair bestSlot = null;
        for (Integer slot : possibleSlots) {
            class_1799 slotStack = this.inventory.method_5438(slot.intValue());
            if (slotStack.method_7960()) {
                bestSlot = Pair.of((Object)slot, (Object)0);
            }
            if (bestSlot == null) {
                bestSlot = Pair.of((Object)slot, (Object)slotStack.method_7947());
                continue;
            }
            if ((Integer)bestSlot.getRight() < slotStack.method_7947()) continue;
            bestSlot = Pair.of((Object)slot, (Object)slotStack.method_7947());
        }
        if ((Integer)bestSlot.getLeft() == this.balanceSlot || ((Integer)bestSlot.getRight()).intValue() == sourceStack.method_7947() || this.inventory.method_5438(((Integer)bestSlot.getLeft()).intValue()).method_7960() || !ItemUtils.isItemEqual((class_1799)sourceStack, (class_1799)this.inventory.method_5438(((Integer)bestSlot.getLeft()).intValue()), (boolean)true, (boolean)true)) {
            return Optional.empty();
        }
        sourceStack.method_7934(1);
        this.inventory.method_5438(((Integer)bestSlot.getLeft()).intValue()).method_7933(1);
        this.inventory.setHashChanged();
        return Optional.of(this.getCraftingInventory());
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.field_9236) {
            return;
        }
        class_3955 recipe = this.getCurrentRecipe();
        if (recipe == null) {
            this.progress = 0;
            return;
        }
        Optional<class_1715> balanceResult = this.balanceRecipe(this.getCraftingInventory());
        balanceResult.ifPresent(craftingInventory -> {
            this.inventoryCrafting = craftingInventory;
        });
        if (this.progress >= this.maxProgress) {
            if (this.make(recipe)) {
                this.progress = 0;
            }
        } else if (this.canMake(recipe)) {
            if (this.getStored() > (long)this.euTick) {
                ++this.progress;
                if (this.progress == 1) {
                    world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), ModSounds.AUTO_CRAFTING, class_3419.field_15245, 0.3f, 0.8f);
                }
                this.useEnergy(this.euTick);
            }
        } else {
            this.progress = 0;
        }
    }

    public long getBaseMaxPower() {
        return TechRebornConfig.autoCraftingTableMaxEnergy;
    }

    public long getBaseMaxOutput() {
        return 0L;
    }

    public long getBaseMaxInput() {
        return TechRebornConfig.autoCraftingTableMaxInput;
    }

    public boolean canProvideEnergy(@Nullable class_2350 side) {
        return false;
    }

    public void method_11007(class_2487 tag) {
        tag.method_10556("locked", this.locked);
        super.method_11007(tag);
    }

    public void method_11014(class_2487 tag) {
        if (tag.method_10545("locked")) {
            this.locked = tag.method_10577("locked");
        }
        super.method_11014(tag);
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public boolean hasSlotConfig() {
        return true;
    }

    public class_1799 getToolDrop(class_1657 playerIn) {
        return TRContent.Machine.AUTO_CRAFTING_TABLE.getStack();
    }

    public RebornInventory<AutoCraftingTableBlockEntity> getInventory() {
        return this.inventory;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("autocraftingtable").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 28, 25).slot(1, 46, 25).slot(2, 64, 25).slot(3, 28, 43).slot(4, 46, 43).slot(5, 64, 43).slot(6, 28, 61).slot(7, 46, 61).slot(8, 64, 61).outputSlot(9, 145, 42).outputSlot(10, 145, 70).syncEnergyValue().sync(this::getProgress, this::setProgress).sync(this::getMaxProgress, this::setMaxProgress).sync(this::getLockedInt, this::setLockedInt).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getMaxProgress() {
        if (this.maxProgress == 0) {
            this.maxProgress = 1;
        }
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public int getLockedInt() {
        return this.locked ? 1 : 0;
    }

    public void setLockedInt(int lockedInt) {
        this.locked = lockedInt == 1;
    }
}

