/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.world.state;

import com.yungnickyoung.minecraft.betterdeserttemples.BetterDesertTemplesCommon;
import com.yungnickyoung.minecraft.betterdeserttemples.world.state.TempleStateRegion;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_2338;

public class TempleStateCache {
    public ConcurrentHashMap<String, TempleStateRegion> templeStateRegionMap = new ConcurrentHashMap();
    private final Path savePath;

    public TempleStateCache(Path dimensionPath) {
        this.savePath = dimensionPath.resolve("betterdeserttemples");
        this.createDirectoryIfDoesNotExist();
    }

    public boolean isTempleCleared(class_2338 templePos) {
        String templeRegionKey = this.getRegionKey(templePos);
        TempleStateRegion templeStateRegion = this.templeStateRegionMap.computeIfAbsent(templeRegionKey, key -> new TempleStateRegion(this.savePath, (String)key));
        return templeStateRegion.isTempleCleared(templePos);
    }

    public void setTempleCleared(class_2338 templePos, boolean isCleared) {
        String templeRegionKey = this.getRegionKey(templePos);
        TempleStateRegion templeStateRegion = this.templeStateRegionMap.computeIfAbsent(templeRegionKey, key -> new TempleStateRegion(this.savePath, (String)key));
        templeStateRegion.setTempleCleared(templePos, isCleared);
    }

    private String getRegionKey(class_2338 templePos) {
        class_1923 chunkPos = new class_1923(templePos);
        return "r." + chunkPos.method_17885() + "." + chunkPos.method_17886() + ".temples";
    }

    private void createDirectoryIfDoesNotExist() {
        try {
            Files.createDirectories(this.savePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            BetterDesertTemplesCommon.LOGGER.error("Unable to create temples save path {}", (Object)this.savePath);
            BetterDesertTemplesCommon.LOGGER.error((Object)e);
        }
    }
}

