/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.processor.small_nether_dungeon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeonsCommon;
import com.yungnickyoung.minecraft.betterdungeons.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.betterdungeons.world.DungeonContext;
import com.yungnickyoung.minecraft.betterdungeons.world.DungeonType;
import com.yungnickyoung.minecraft.yungsapi.world.banner.Banner;
import net.minecraft.class_2185;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class SmallNetherDungeonBannerProcessor
extends class_3491 {
    public static final Codec<SmallNetherDungeonBannerProcessor> CODEC = RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.STRING.fieldOf("dungeon_type").forGetter(processor -> processor.getDungeonType().getName())).apply((Applicative)codecBuilder, codecBuilder.stable(SmallNetherDungeonBannerProcessor::new)));
    private final DungeonType dungeonType;
    public static final Banner SKELETON_BANNER = new Banner.Builder().blockState(class_2246.field_10537.method_9564()).pattern("cbo", 0).pattern("cs", 0).pattern("bs", 15).pattern("ts", 0).pattern("cre", 0).pattern("gra", 15).customName("Vengeful Banner").customColor("dark_gray").build();
    public static final Banner WITHER_SKELETON_BANNER = new Banner.Builder().blockState(class_2246.field_10279.method_9564()).pattern("cbo", 15).pattern("cs", 15).pattern("bs", 14).pattern("cre", 15).pattern("ts", 15).pattern("gru", 15).customName("Banner of Decay").customColor("dark_purple").build();
    public static final Banner ZOMBIFIED_PIGLIN_BANNER = new Banner.Builder().blockState(class_2246.field_10531.method_9564()).pattern("ls", 13).pattern("tts", 15).pattern("tts", 6).pattern("cs", 6).pattern("vhr", 8).pattern("rd", 13).pattern("cre", 0).pattern("hhb", 6).pattern("mr", 6).pattern("pig", 15).pattern("gru", 6).pattern("bs", 15).customName("Banner of Pork").customColor("light_purple").build();
    public static final Banner BLAZE_BANNER = new Banner.Builder().blockState(class_2246.field_10279.method_9564()).pattern("ss", 4).pattern("tt", 14).pattern("tt", 14).pattern("flo", 1).pattern("sku", 4).pattern("cbo", 14).pattern("gru", 15).customName("Banner of Rage").customColor("gold").build();

    private SmallNetherDungeonBannerProcessor(String dungeonType) {
        this.dungeonType = DungeonType.fromString(dungeonType);
    }

    public DungeonType getDungeonType() {
        return this.dungeonType;
    }

    public class_3499.class_3501 method_15110(class_4538 levelReader, class_2338 jigsawPiecePos, class_2338 jigsawPieceBottomCenterPos, class_3499.class_3501 blockInfoLocal, class_3499.class_3501 blockInfoGlobal, class_3492 structurePlacementData) {
        if (blockInfoGlobal.field_15596.method_26204() instanceof class_2185 && blockInfoGlobal.field_15596.method_26204() == class_2246.field_10267 && (blockInfoGlobal.field_15595.method_10580("Patterns") == null || blockInfoGlobal.field_15595.method_10554("Patterns", 10).size() == 0)) {
            DungeonContext context = DungeonContext.peek();
            if (context.getBannerCount() >= BetterDungeonsCommon.CONFIG.smallNetherDungeons.bannerMaxCount) {
                return new class_3499.class_3501(blockInfoGlobal.field_15597, class_2246.field_10124.method_9564(), blockInfoGlobal.field_15595);
            }
            class_5819 random = structurePlacementData.method_15115(blockInfoGlobal.field_15597);
            if (random.method_43057() > 0.1f) {
                return new class_3499.class_3501(blockInfoGlobal.field_15597, class_2246.field_10124.method_9564(), blockInfoGlobal.field_15595);
            }
            Banner banner = this.getBannerForType();
            class_2350 facing = (class_2350)blockInfoGlobal.field_15596.method_11654((class_2769)class_2741.field_12481);
            class_2680 newState = (class_2680)banner.getState().method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
            class_2487 newNBT = this.copyNBT(banner.getNbt());
            blockInfoGlobal = new class_3499.class_3501(blockInfoGlobal.field_15597, newState, newNBT);
            context.incrementBannerCount();
        }
        return blockInfoGlobal;
    }

    protected class_3828<?> method_16772() {
        return StructureProcessorTypeModule.SMALL_NETHER_DUNGEON_BANNER_PROCESSOR;
    }

    private Banner getBannerForType() {
        switch (this.dungeonType) {
            case SKELETON: {
                return SKELETON_BANNER;
            }
            case ZOMBIFIED_PIGLIN: {
                return ZOMBIFIED_PIGLIN_BANNER;
            }
            case WITHER_SKELETON: {
                return WITHER_SKELETON_BANNER;
            }
            case BLAZE: {
                return BLAZE_BANNER;
            }
        }
        BetterDungeonsCommon.LOGGER.warn("Invalid DungeonType {} for small_nether_dungeon_banner_processor! This shouldn't happen!", (Object)this.dungeonType);
        return SKELETON_BANNER;
    }

    private class_2487 copyNBT(class_2487 other) {
        class_2487 nbt = new class_2487();
        nbt.method_10543(other);
        return nbt;
    }
}

